/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.model.migrate.MigrationUtilitiesHolder;

@Service(value=MigrationUtilities.class)
public class MigrationUtilities {
    private final Map<String, List<String>> syllableMap = new HashMap<String, List<String>>();

    public static MigrationUtilities getInstance() {
        return MigrationUtilitiesHolder.INSTANCE;
    }

    public boolean isVowel(char c) {
        return c == 'a' || c == 'A' || c == 'e' || c == 'E' || c == 'i' || c == 'I' || c == 'o' || c == 'O' || c == 'u' || c == 'U' || c == 'y' || c == 'Y';
    }

    public boolean containsVowel(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!this.isVowel(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public List<String> extractSyllables(String name) {
        return this.syllableMap.computeIfAbsent(name, n -> {
            ArrayList<String> syllables = new ArrayList<String>();
            StringBuilder syllable = new StringBuilder();
            for (String s : n.split("_")) {
                syllable.setLength(0);
                char lastChar = '\u0000';
                boolean containsVowel = false;
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char c = s.charAt(i);
                    if (Character.isDigit(c)) {
                        if (syllable.length() > 0 && !Character.isDigit(lastChar)) {
                            syllables.add(syllable.toString());
                            syllable.setLength(0);
                            containsVowel = false;
                        }
                        syllable.append(c);
                        lastChar = c;
                        continue;
                    }
                    if (!Character.isLetter(c)) continue;
                    c = Character.toLowerCase(c);
                    if (syllable.length() > 0 && !Character.isLetter(lastChar)) {
                        syllables.add(syllable.toString());
                        syllable.setLength(0);
                        containsVowel = false;
                    }
                    if (lastChar == c) continue;
                    boolean isVwl = this.isVowel(c);
                    if (syllable.length() == 0) {
                        syllable.append(c);
                        containsVowel |= isVwl;
                        lastChar = c;
                        continue;
                    }
                    if (!isVwl && containsVowel && i < len - 2 && this.containsVowel(s.substring(i + 1))) {
                        syllable.append(c);
                        syllables.add(syllable.toString());
                        syllable.setLength(0);
                        containsVowel = false;
                    } else {
                        syllable.append(c);
                        containsVowel |= isVwl;
                    }
                    lastChar = c;
                }
                if (syllable.length() <= 0) continue;
                syllables.add(syllable.toString());
            }
            return syllables;
        });
    }

    public String bestMatch(String modelName, List<String> existingNames) {
        TreeSet<MatchResult> results = new TreeSet<MatchResult>();
        for (String existingName : existingNames) {
            results.add(new MatchResult(modelName, existingName));
        }
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            return ((MatchResult)iterator.next()).existingName;
        }
        return null;
    }

    private class MatchResult
    implements Comparable<MatchResult> {
        private final String existingName;
        private final int[] distances;

        private MatchResult(String modelName, String existingName) {
            this.existingName = existingName;
            List<String> modelSyllables = MigrationUtilities.this.extractSyllables(modelName);
            List<String> existingSyllables = MigrationUtilities.this.extractSyllables(existingName);
            this.distances = new int[existingSyllables.size() * modelSyllables.size()];
            int ndx = 0;
            for (String existingSyllable : existingSyllables) {
                for (String modelSyllable : modelSyllables) {
                    this.distances[ndx++] = StringHelper.levenshteinDistance((String)existingSyllable, (String)modelSyllable);
                }
            }
            Arrays.sort(this.distances);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchResult that = (MatchResult)o;
            return this.existingName.equals(that.existingName);
        }

        public int hashCode() {
            return this.existingName.hashCode();
        }

        @Override
        public int compareTo(MatchResult o) {
            int max = Math.max(this.distances.length, o.distances.length);
            int rv = 0;
            for (int ndx = 0; rv == 0 && ndx < max; ++ndx) {
                rv = ndx >= this.distances.length ? Integer.MIN_VALUE : (ndx >= o.distances.length ? Integer.MAX_VALUE : this.distances[ndx] - o.distances[ndx]);
            }
            return rv;
        }
    }
}

