/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

public class OptionParser {
    private final String text;
    private final int max;
    private int pos;
    private StringBuilder other;
    private int optionLevel;
    private int braceLevel;

    public OptionParser(String text, StringBuilder other) {
        this.text = text;
        this.max = text.length();
        this.other = other;
        this.optionLevel = other != null ? 0 : 1;
    }

    public String nextOption() {
        return this.nextOption(0);
    }

    public String nextOption(int stopAtOptionLevel) {
        String opt;
        StringBuilder option = new StringBuilder();
        while (this.pos < this.max) {
            char c;
            if ((c = this.text.charAt(this.pos++)) == '\\' && this.pos < this.max - 1) {
                c = this.text.charAt(this.pos++);
                if (this.optionLevel > 0) {
                    if (c != '[' && c != ']' && c != '(' && c != ')') {
                        option.append('\\');
                    }
                    option.append(c);
                    continue;
                }
                if (this.other == null) continue;
                this.other.append(c);
                continue;
            }
            if (this.optionLevel > 0) {
                if (c == ']' && this.braceLevel == 0) {
                    --this.optionLevel;
                    if (this.optionLevel == stopAtOptionLevel) {
                        if (stopAtOptionLevel <= 0) break;
                        option.append(c);
                        break;
                    }
                    option.append(c);
                    continue;
                }
                if (c == '[' && this.braceLevel == 0) {
                    ++this.optionLevel;
                    option.append(c);
                    continue;
                }
                if (c == ',' && this.braceLevel == 0) break;
                option.append(c);
                if (c == ')') {
                    if (this.braceLevel <= 0) continue;
                    --this.braceLevel;
                    continue;
                }
                if (c != '(') continue;
                ++this.braceLevel;
                continue;
            }
            if (c == '[' && this.braceLevel == 0) {
                ++this.optionLevel;
                continue;
            }
            if (this.other == null) continue;
            this.other.append(c);
        }
        if ((opt = option.toString().trim()).length() > 0) {
            return opt;
        }
        return this.pos >= this.max ? null : opt;
    }
}

