/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.ArrayList;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Relation;
import org.tentackle.model.print.AnnotationPrinter;
import org.tentackle.model.print.AttributeSectionPrinter;
import org.tentackle.model.print.GlobalOptionsPrinter;
import org.tentackle.model.print.IndexPrinter;
import org.tentackle.model.print.PrintConfiguration;
import org.tentackle.model.print.RelationPrinter;

public class EntityPrinter {
    private final Entity entity;
    private final PrintConfiguration configuration;
    private final StringBuilder buf;

    public EntityPrinter(Entity entity, PrintConfiguration configuration) {
        this.entity = entity;
        this.configuration = configuration;
        this.buf = new StringBuilder();
    }

    public String print() {
        this.buf.setLength(0);
        if (this.configuration.isPrintingAsComment()) {
            this.buf.append("/*\n");
            if (this.configuration.isUsingVariables()) {
                this.buf.append(" * @> $mapping\n");
            } else {
                this.buf.append(" * @> ").append(this.entity.getTableName()).append(".map\n");
            }
        }
        this.line("\n");
        this.line("# ").append(this.entity.getOptions().getComment()).append('\n');
        this.line("name := ");
        if (this.configuration.isUsingVariables()) {
            this.buf.append("$classname\n");
        } else {
            this.buf.append(this.entity.getName()).append('\n');
        }
        if (this.entity.getTableName() != null) {
            this.line("table := ");
            if (this.configuration.isUsingVariables()) {
                this.buf.append("$tablename\n");
            } else {
                this.buf.append(this.entity.getTableName()).append('\n');
            }
        }
        if (this.entity.getClassId() != 0) {
            this.line("id := ");
            if (this.configuration.isUsingVariables()) {
                this.buf.append("$classid\n");
            } else {
                this.buf.append(this.entity.getClassId()).append('\n');
            }
        }
        this.line("integrity := ");
        if (this.configuration.isUsingVariables()) {
            this.buf.append("$integrity\n");
        } else {
            this.buf.append(this.entity.getIntegrity().toString().toLowerCase()).append('\n');
        }
        if (this.entity.getInheritanceType() != InheritanceType.NONE) {
            this.line("inheritance := ").append(this.entity.getInheritanceType().toString().toLowerCase()).append('\n');
        }
        if (this.entity.getSuperEntityName() != null) {
            this.line("extends := ").append(this.entity.getSuperEntityName()).append('\n');
        }
        if (this.entity.getDefinedTableAlias() != null) {
            this.line("alias := ").append(this.entity.getDefinedTableAlias()).append('\n');
        }
        this.line("\n");
        this.line("## attributes\n");
        String globalOptions = new GlobalOptionsPrinter(this.entity, this.configuration).print();
        if (!"[]".equals(globalOptions)) {
            this.line(globalOptions).append('\n');
        }
        this.buf.append(new AttributeSectionPrinter(this.entity, this.configuration).print());
        this.line("\n");
        this.line("## indexes\n");
        for (Index index : this.entity.getIndexes()) {
            this.buf.append(new IndexPrinter(index, this.configuration).print());
        }
        this.line("\n");
        this.line("## relations\n");
        boolean needBlankLine = false;
        for (Relation relation : this.entity.getRelations()) {
            if (needBlankLine) {
                this.line("\n");
            } else {
                needBlankLine = true;
            }
            this.buf.append(new RelationPrinter(relation, this.configuration).print());
        }
        this.line("\n");
        this.line("## annotations\n");
        needBlankLine = false;
        for (Attribute attribute : this.entity.getAttributes()) {
            ArrayList<String> annotations = new ArrayList<String>();
            for (String anno : attribute.getOptions().getAnnotations()) {
                if (this.configuration.isOptionAnnotation(anno)) continue;
                annotations.add(anno);
            }
            if (annotations.isEmpty()) continue;
            if (needBlankLine) {
                this.line("\n");
            } else {
                needBlankLine = true;
            }
            this.line(attribute.getName()).append(":\n");
            int size = annotations.size();
            int ndx = 0;
            for (String annotation : annotations) {
                this.line("    ").append(new AnnotationPrinter(annotation).print());
                if (++ndx < size) {
                    this.buf.append(',');
                }
                this.buf.append('\n');
            }
        }
        this.line("\n");
        if (this.configuration.isPrintingAsComment()) {
            this.buf.append(" * @<\n */\n");
        }
        return this.buf.toString();
    }

    private StringBuilder line(String str) {
        if (this.configuration.isPrintingAsComment()) {
            this.buf.append(" * ");
        }
        this.buf.append(str);
        return this.buf;
    }
}

