/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.model.ModelException;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.LineType;
import org.tentackle.model.parse.OptionParser;
import org.tentackle.model.parse.SingleLine;

public class AttributeLine
extends SingleLine {
    private String javaType;
    private String innerType;
    private Integer size;
    private Integer scale;
    private String javaName;
    private String columnName;
    private String comment;
    private List<String> options;

    public AttributeLine(Document document, int offset, LineType lineType) {
        super(document, offset, lineType);
    }

    @Override
    public void parse() throws ModelException {
        super.parse();
        String text = this.getText();
        StringTokenizer stok = new StringTokenizer(text, " \t");
        StringBuilder obuf = new StringBuilder();
        StringBuilder ssBuf = null;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (this.javaType == null) {
                this.extractJavaType(token);
                continue;
            }
            if (this.javaName == null) {
                if (token.charAt(0) == '(') {
                    ssBuf = new StringBuilder(token);
                }
                if (ssBuf != null) {
                    if (token.endsWith(")")) {
                        ssBuf.append(token);
                    }
                    if (ssBuf.charAt(ssBuf.length() - 1) != ')') continue;
                    this.extractSizeAndOrScale(ssBuf.substring(1, ssBuf.length() - 1));
                    ssBuf = null;
                    continue;
                }
                this.javaName = token;
                continue;
            }
            if (this.columnName == null) {
                this.columnName = token;
                continue;
            }
            obuf.append(' ').append(token);
        }
        if (this.javaType == null || this.javaName == null || this.columnName == null) {
            throw this.createModelException("syntax error");
        }
        this.parseCommentAndOptions(obuf.toString());
    }

    public String getJavaType() throws ModelException {
        this.assertParsed();
        return this.javaType;
    }

    public String getInnerType() throws ModelException {
        this.assertParsed();
        return this.innerType;
    }

    public Integer getSize() throws ModelException {
        this.assertParsed();
        return this.size;
    }

    public Integer getScale() throws ModelException {
        this.assertParsed();
        return this.scale;
    }

    public String getJavaName() throws ModelException {
        this.assertParsed();
        return this.javaName;
    }

    public String getColumnName() throws ModelException {
        this.assertParsed();
        return this.columnName;
    }

    public String getComment() throws ModelException {
        this.assertParsed();
        return this.comment;
    }

    public List<String> getOptions() throws ModelException {
        this.assertParsed();
        return this.options;
    }

    private void parseCommentAndOptions(String text) {
        String option;
        StringBuilder commentBuf = new StringBuilder();
        OptionParser parser = new OptionParser(text, commentBuf);
        this.options = new ArrayList<String>();
        while ((option = parser.nextOption()) != null) {
            this.options.add(option);
        }
        this.comment = commentBuf.toString().trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractJavaType(String token) throws ModelException {
        if (token == null || token.length() <= 0) throw this.createModelException("java type is empty");
        int genBegin = token.indexOf(60);
        if (genBegin > 0) {
            int genEnd = token.lastIndexOf(62);
            if (genEnd <= genBegin) throw this.createModelException("mangled generic Java type '" + token + "'");
            this.javaType = token.substring(0, genBegin);
            this.innerType = token.substring(genBegin + 1, genEnd);
            int sizeBegin = token.indexOf(40);
            if (sizeBegin <= 0) return;
            int sizeEnd = token.indexOf(41);
            if (sizeEnd <= sizeBegin) throw this.createModelException("mangled inner type with size and/or scale '" + token + "'");
            this.extractSizeAndOrScale(token.substring(sizeBegin + 1, sizeEnd));
            return;
        } else {
            int sizeBegin = token.indexOf(40);
            if (sizeBegin > 0) {
                int sizeEnd = token.indexOf(41);
                if (sizeEnd <= sizeBegin) throw this.createModelException("mangled type with size and/or scale '" + token + "'");
                this.javaType = token.substring(0, sizeBegin);
                this.extractSizeAndOrScale(token.substring(sizeBegin + 1, sizeEnd));
                return;
            } else {
                this.javaType = token;
            }
        }
    }

    private void extractSizeAndOrScale(String str) throws ModelException {
        int scaleBegin = str.indexOf(44);
        if (scaleBegin > 0) {
            try {
                String sizeStr = str.substring(0, scaleBegin).trim();
                this.size = sizeStr.length() == 0 ? 0 : Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException rex) {
                throw this.createModelException("cannot determine size from '" + str + "'", rex);
            }
            try {
                String scaleStr = str.substring(scaleBegin + 1).trim();
                this.scale = scaleStr.length() == 0 ? 0 : Integer.parseInt(scaleStr);
            }
            catch (NumberFormatException rex) {
                throw this.createModelException("cannot determine scale from '" + str + "'", rex);
            }
        }
        try {
            this.size = Integer.valueOf(str.trim());
        }
        catch (NumberFormatException rex) {
            throw this.createModelException("cannot determine size from '" + str + "'", rex);
        }
    }
}

