/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.StringTokenizer;
import org.tentackle.model.ModelException;
import org.tentackle.model.TrackType;

public class ModelDefaults {
    private TrackType trackType;
    private Boolean deletionCascaded;
    private Boolean root;
    private Boolean rootId;
    private Boolean rootClassId;
    private Boolean bind;
    private Boolean size;
    private Boolean autoSelect;
    private Boolean remote;

    public ModelDefaults() {
    }

    public ModelDefaults(String str) throws ModelException {
        this.parse(str);
    }

    public void parse(String str) throws ModelException {
        this.clear();
        StringTokenizer stok = new StringTokenizer(str, " ,\t\n\r");
        block29: while (stok.hasMoreTokens()) {
            String token;
            switch (token = stok.nextToken().toLowerCase()) {
                case "tracked": {
                    this.trackType = TrackType.TRACKED;
                    continue block29;
                }
                case "attracked": {
                    this.trackType = TrackType.ATTRACKED;
                    continue block29;
                }
                case "fulltracked": {
                    this.trackType = TrackType.FULLTRACKED;
                    continue block29;
                }
                case "deletioncascaded": 
                case "cascadeddelete": 
                case "cascaded": 
                case "cascade": {
                    this.deletionCascaded = true;
                    continue block29;
                }
                case "root": {
                    this.root = true;
                    continue block29;
                }
                case "rootid": {
                    this.rootId = true;
                    continue block29;
                }
                case "rootclassid": {
                    this.rootClassId = true;
                    continue block29;
                }
                case "bind": {
                    this.bind = true;
                    continue block29;
                }
                case "size": {
                    this.size = true;
                    continue block29;
                }
                case "autoselect": {
                    this.autoSelect = true;
                    continue block29;
                }
                case "remote": {
                    this.remote = true;
                    continue block29;
                }
            }
            throw new ModelException("unknown model default: " + token);
        }
    }

    public String toString() {
        String str;
        StringBuilder buf = new StringBuilder();
        if (this.trackType != null) {
            buf.append((Object)this.trackType).append(", ");
        }
        if (this.deletionCascaded != null) {
            if (!this.deletionCascaded.booleanValue()) {
                buf.append('!');
            }
            buf.append("CASCADE, ");
        }
        if (this.root != null) {
            if (!this.root.booleanValue()) {
                buf.append('!');
            }
            buf.append("ROOT, ");
        }
        if (this.rootId != null) {
            if (!this.rootId.booleanValue()) {
                buf.append('!');
            }
            buf.append("ROOTID, ");
        }
        if (this.rootClassId != null) {
            if (!this.rootClassId.booleanValue()) {
                buf.append('!');
            }
            buf.append("ROOTCLASSID, ");
        }
        if (this.bind != null) {
            if (!this.bind.booleanValue()) {
                buf.append('!');
            }
            buf.append("BIND, ");
        }
        if (this.size != null) {
            if (!this.size.booleanValue()) {
                buf.append('!');
            }
            buf.append("SIZE, ");
        }
        if (this.autoSelect != null) {
            if (!this.autoSelect.booleanValue()) {
                buf.append('!');
            }
            buf.append("AUTOSELECT, ");
        }
        if (this.remote != null) {
            if (!this.remote.booleanValue()) {
                buf.append('!');
            }
            buf.append("REMOTE, ");
        }
        if ((str = buf.toString()).endsWith(", ")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    public void clear() {
        this.trackType = null;
        this.deletionCascaded = null;
        this.root = null;
        this.rootId = null;
        this.rootClassId = null;
        this.bind = null;
        this.size = null;
        this.autoSelect = null;
        this.remote = null;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public Boolean getDeletionCascaded() {
        return this.deletionCascaded;
    }

    public Boolean getRoot() {
        return this.root;
    }

    public Boolean getRootId() {
        return this.rootId;
    }

    public Boolean getRootClassId() {
        return this.rootClassId;
    }

    public Boolean getBind() {
        return this.bind;
    }

    public Boolean getSize() {
        return this.size;
    }

    public Boolean getAutoSelect() {
        return this.autoSelect;
    }

    public Boolean getRemote() {
        return this.remote;
    }
}

