/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.Collection;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelError;

public class ModelException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final transient ModelElement element;
    public static final String AT_ELEMENT = " @ ";

    public ModelException(String message, ModelElement element, Throwable cause) {
        super(message, cause);
        this.element = element;
    }

    public ModelException(String message, ModelElement element) {
        super(message);
        this.element = element;
    }

    public ModelException(String message, Throwable cause) {
        super(message, cause);
        this.element = null;
    }

    public ModelException(String message) {
        super(message);
        this.element = null;
    }

    public ModelException(Collection<ModelError> errors) {
        super(ModelError.toString(errors));
        this.element = this.pickFirstElement(errors);
    }

    public ModelElement getElement() {
        return this.element;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (!(this.element == null || message != null && message.contains(AT_ELEMENT) || this.element.getSourceInfo() == null)) {
            return message + AT_ELEMENT + this.element.getSourceInfo();
        }
        return message;
    }

    public boolean isRelatedTo(ModelElement otherElement) {
        for (ModelElement elem = this.element; elem != null; elem = elem.getParent()) {
            if (!elem.equals(otherElement)) continue;
            return true;
        }
        return false;
    }

    private ModelElement pickFirstElement(Collection<ModelError> errors) {
        for (ModelError error : errors) {
            if (error.getElement() == null) continue;
            return error.getElement();
        }
        return null;
    }
}

