/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeOptions;
import org.tentackle.model.EntityOptions;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.CommonOptionsImpl;
import org.tentackle.sql.DataType;

public class AttributeOptionsImpl
extends CommonOptionsImpl
implements AttributeOptions {
    public static final String OPTION_DEFAULT = "DEFAULT";
    public static final String OPTION_INIT = "INIT";
    public static final String OPTION_NEW = "NEW";
    public static final String OPTION_CONTEXT = "CONTEXT";
    public static final String OPTION_DOMAINKEY = "KEY";
    public static final String OPTION_TZ = "TZ";
    public static final String OPTION_HIDDEN = "HIDDEN";
    public static final String OPTION_SHALLOW = "SHALLOW";
    public static final String OPTION_NORMTEXT = "NORMTEXT";
    private final AttributeImpl attribute;
    private List<String> annotations;
    private Object defaultValue;
    private String initialValue;
    private String newValue;
    private boolean contextId;
    private boolean domainKey;
    private boolean utc;
    private boolean withTimezone;
    private boolean unsigned;
    private boolean digitsOnly;
    private boolean hidden;
    private boolean shallow;
    private boolean partOfNormText;

    public AttributeOptionsImpl(Attribute attribute, SourceInfo sourceInfo) {
        super(sourceInfo);
        this.attribute = (AttributeImpl)attribute;
        this.annotations = new ArrayList<String>();
    }

    @Override
    public AttributeImpl getAttribute() {
        return this.attribute;
    }

    public void applyEntityOptions(EntityOptions options, DataType<?> dataType) {
        this.setNoDeclare(options.isNoDeclare());
        this.setNoMethod(options.isNoMethod());
        this.setNoConstant(options.isNoConstant());
        this.setMute(options.isMute());
        this.setFromSuper(options.isFromSuper());
        this.setReadOnly(options.isReadOnly());
        this.setWriteOnly(options.isWriteOnly());
        this.setAccessScope(options.getAccessScope());
        this.setTrimRead(options.isTrimRead());
        this.setTrimWrite(options.isTrimWrite());
        if (dataType.isMapNullSupported()) {
            this.setMapNull(options.isMapNull());
        }
        this.setBindable(options.isBindable());
        this.setUpperCase(options.isUpperCase());
        this.setLowerCase(options.isLowerCase());
        this.setMaxCol(options.isMaxCol());
        this.setBindOptions(options.getBindOptions());
        if (dataType.isNumeric() || dataType.isDateOrTime()) {
            this.setAutoSelect(options.isAutoSelect());
        } else {
            this.removeBindOption("AUTOSELECT");
        }
    }

    @Override
    public boolean applyOption(String option, Boolean ctrl) throws ModelException {
        boolean on;
        boolean applied = super.applyOption(option, ctrl);
        boolean bl = on = ctrl == null || ctrl != false;
        if (!applied) {
            String uco = option.toUpperCase();
            if (uco.startsWith(OPTION_DEFAULT)) {
                if (on) {
                    String str = option.substring(OPTION_DEFAULT.length()).trim();
                    Object value = this.getAttribute().getEffectiveDataType().valueOf(str);
                    this.setDefaultValue(value);
                } else {
                    this.setDefaultValue(null);
                }
                applied = true;
            } else if (uco.startsWith(OPTION_INIT)) {
                if (on) {
                    this.setInitialValue(option.substring(OPTION_INIT.length()).trim());
                } else {
                    this.setInitialValue(null);
                }
                applied = true;
            } else if (uco.startsWith(OPTION_NEW)) {
                if (on) {
                    this.setNewValue(option.substring(OPTION_NEW.length()).trim());
                } else {
                    this.setNewValue(null);
                }
                applied = true;
            } else if (uco.equals(OPTION_CONTEXT)) {
                this.setContextId(on);
                applied = true;
            } else if (uco.equals(OPTION_DOMAINKEY)) {
                this.setDomainKey(on);
                applied = true;
            } else if (uco.equals(OPTION_TZ)) {
                this.setWithTimezone(on);
                applied = true;
            } else if (uco.equals(OPTION_HIDDEN)) {
                this.setHidden(on);
                applied = true;
            } else if (uco.equals(OPTION_SHALLOW)) {
                this.setShallow(on);
                applied = true;
            } else if (uco.equals(OPTION_NORMTEXT)) {
                this.setPartOfNormText(on);
                applied = true;
            } else if (uco.equals("UTC")) {
                this.setUTC(on);
                this.processBindOption(uco, on);
                applied = true;
            } else if (uco.equals("UNSIGNED")) {
                this.setUnsigned(on);
                this.processBindOption(uco, on);
                applied = true;
            } else if (uco.equals("DIGITS")) {
                this.setDigitsOnly(on);
                this.processBindOption(uco, on);
                applied = true;
            }
        }
        return applied;
    }

    @Override
    public List<String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getInitialValue() {
        return this.initialValue;
    }

    @Override
    public String getNewValue() {
        return this.newValue;
    }

    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Override
    public boolean isContextId() {
        return this.contextId;
    }

    public void setContextId(boolean contextId) {
        this.contextId = contextId;
    }

    @Override
    public boolean isDomainKey() {
        return this.domainKey;
    }

    public void setDomainKey(boolean domainKey) {
        this.domainKey = domainKey;
    }

    @Override
    public boolean isUTC() {
        return this.utc;
    }

    public void setUTC(boolean utc) {
        this.utc = utc;
    }

    @Override
    public boolean isWithTimezone() {
        return this.withTimezone;
    }

    public void setWithTimezone(boolean withTimezone) {
        this.withTimezone = withTimezone;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    @Override
    public boolean isDigitsOnly() {
        return this.digitsOnly;
    }

    public void setDigitsOnly(boolean digitsOnly) {
        this.digitsOnly = digitsOnly;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isShallow() {
        return this.shallow;
    }

    public void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    @Override
    public boolean isPartOfNormText() {
        return this.partOfNormText;
    }

    public void setPartOfNormText(boolean partOfNormText) {
        this.partOfNormText = partOfNormText;
    }

    @Override
    public ModelException createModelException(String message) {
        if (this.attribute != null) {
            return this.attribute.createModelException(message);
        }
        return super.createModelException(message);
    }
}

