/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import java.net.URL;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityInfo;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;

public class EntityInfoImpl
implements EntityInfo {
    private final Entity entity;
    private final URL url;
    private final String modelSource;
    private final ModelDefaults defaults;
    private final File file;
    private final long lastModified;

    public EntityInfoImpl(Entity entity, URL url, String modelSource, ModelDefaults defaults) throws ModelException {
        this.entity = entity;
        this.url = url;
        this.modelSource = modelSource;
        this.defaults = defaults;
        if ("file".equals(url.getProtocol())) {
            this.file = new File(url.getPath());
            if (!this.file.exists()) {
                throw new ModelException(this.file + " does not exist");
            }
            if (!this.file.isFile()) {
                throw new ModelException(this.file + " is not a regular file");
            }
            this.lastModified = this.file.lastModified();
        } else {
            this.file = null;
            this.lastModified = 0L;
        }
    }

    public String toString() {
        return this.entity.toString();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean isFile() {
        return this.file != null;
    }

    @Override
    public File getFile() throws ModelException {
        if (this.isFile()) {
            return this.file;
        }
        throw new ModelException(this.url + " is not a file");
    }

    @Override
    public String getModelSource() {
        return this.modelSource;
    }

    @Override
    public ModelDefaults getModelDefaults() {
        return this.defaults;
    }

    @Override
    public boolean hasChanged() {
        return this.file != null && this.file.lastModified() > this.lastModified;
    }
}

