/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.CustomModelValidator;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.EntityInfo;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelDirectory;
import org.tentackle.model.ModelError;
import org.tentackle.model.ModelException;
import org.tentackle.model.ModelUtilities;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.impl.EntityInfoImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.ForeignKeyImpl;
import org.tentackle.model.impl.IndexImpl;
import org.tentackle.model.impl.ModelDirectoryImpl;
import org.tentackle.model.impl.RelationImpl;
import org.tentackle.model.parse.Document;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlNameType;

@Service(value=Model.class)
public class ModelImpl
implements Model {
    private final Map<URL, EntityInfo> urlToEntityInfoMap;
    private final Map<Entity, SourceInfo> entityToSourceInfoMap;
    private final Map<String, EntityInfo> nameToEntityInfoMap;
    private final Map<String, EntityInfo> tableToEntityInfoMap;
    private final Map<Integer, EntityInfo> classidToEntityInfoMap;
    private final Map<String, ModelDirectory> modelDirs;
    private final EntityFactory entityFactory = this.createEntityFactory();
    private final Collection<CustomModelValidator> customModelValidators;
    private Collection<ForeignKey> foreignKeys;
    private boolean mapSchemas;
    private ModelDefaults modelDefaults;
    private EntityAliases entityAliases;

    public ModelImpl() {
        this.nameToEntityInfoMap = new TreeMap<String, EntityInfo>();
        this.tableToEntityInfoMap = new HashMap<String, EntityInfo>();
        this.classidToEntityInfoMap = new HashMap<Integer, EntityInfo>();
        this.urlToEntityInfoMap = new HashMap<URL, EntityInfo>();
        this.entityToSourceInfoMap = new HashMap<Entity, SourceInfo>();
        this.modelDirs = new HashMap<String, ModelDirectory>();
        this.customModelValidators = CustomModelValidator.loadValidators();
    }

    @Override
    public void setSchemaNameMapped(boolean mapSchemas) {
        this.mapSchemas = mapSchemas;
    }

    @Override
    public boolean isSchemaNameMapped() {
        return this.mapSchemas;
    }

    @Override
    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    @Override
    public void setModelDefaults(ModelDefaults modelDefaults) {
        this.modelDefaults = modelDefaults;
    }

    @Override
    public EntityAliases getEntityAliases() {
        return this.entityAliases;
    }

    @Override
    public void setEntityAliases(EntityAliases entityAliases) {
        this.entityAliases = entityAliases;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public synchronized Collection<EntityInfo> loadFromDirectory(String modelDir, boolean updateRelations) throws ModelException {
        ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
        boolean modelChanged = false;
        ModelDirectory dir = this.modelDirs.get(modelDir);
        if (dir == null || dir.hasChanged()) {
            modelChanged = true;
            dir = this.createModelDirectory(modelDir);
            this.modelDirs.put(modelDir, dir);
            for (URL url : dir.getURLs()) {
                entityInfos.add(this.loadFromURL(url, false));
            }
            if (updateRelations) {
                this.updateRelations();
            }
        }
        boolean updateRelationsNecessary = false;
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            ModelDefaults defaults = entityInfo.getModelDefaults();
            Entity entity = entityInfo.getEntity();
            if (defaults == null || entity.getOptions().noModelDefaults()) continue;
            if (defaults.getTrackType() != null && defaults.getTrackType().ordinal() > entity.getOptions().getTrackType().ordinal()) {
                ((EntityImpl)entity).getOptions().setTrackType(defaults.getTrackType());
                updateRelationsNecessary = true;
            }
            if (!Boolean.TRUE.equals(defaults.getDeletionCascaded())) continue;
            for (Relation relation : entity.getRelations()) {
                if (!relation.isComposite() || relation.isDeletionCascaded()) continue;
                ((RelationImpl)relation).setDeletionCascaded(true);
                updateRelationsNecessary = true;
            }
        }
        if (updateRelationsNecessary && updateRelations) {
            this.updateRelations();
        }
        if (modelChanged) {
            for (CustomModelValidator validator : this.customModelValidators) {
                validator.validate(this);
            }
        }
        return entityInfos;
    }

    @Override
    public synchronized EntityInfo loadFromURL(URL url, boolean updateRelations) throws ModelException {
        EntityInfo entityInfo = this.urlToEntityInfoMap.get(url);
        if (entityInfo != null && entityInfo.hasChanged()) {
            entityInfo = null;
        }
        if (entityInfo == null) {
            try {
                entityInfo = this.createEntityInfo(this.modelDefaults, url);
            }
            catch (ModelException mex) {
                String msg = "parsing '" + url + "' failed:\n    " + ExceptionHelper.concatenateMessages((Throwable)mex);
                throw new ModelException(msg, mex.getElement(), mex);
            }
            this.addEntityInfo(entityInfo);
            this.foreignKeys = null;
            if (updateRelations) {
                this.updateRelations(entityInfo);
            }
        }
        return entityInfo;
    }

    @Override
    public Collection<EntityInfo> loadFromJar(File file, boolean updateRelations) throws ModelException {
        ArrayList<EntityInfo> entityInfos;
        block16: {
            entityInfos = new ArrayList<EntityInfo>();
            String indexName = "META-INF/MODEL-INDEX.LIST";
            try (JarFile jarFile = new JarFile(file);){
                JarEntry indexEntry = jarFile.getJarEntry(indexName);
                if (indexEntry != null) {
                    String urlLead = "jar:file:" + file.getCanonicalPath() + "!/";
                    try (BufferedReader indexReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(indexEntry), Settings.getEncodingCharset()));){
                        String line;
                        while ((line = indexReader.readLine()) != null) {
                            JarEntry modelEntry = jarFile.getJarEntry(line);
                            if (modelEntry != null) {
                                URL url = new URL(urlLead + modelEntry.getName());
                                entityInfos.add(this.loadFromURL(url, false));
                                continue;
                            }
                            throw new ModelException("no such model resource '" + line + "' in " + file);
                        }
                        break block16;
                    }
                }
                throw new ModelException("missing " + indexName + " in " + file);
            }
            catch (IOException e) {
                throw new ModelException("cannot load model from jar " + file, e);
            }
        }
        if (updateRelations) {
            this.updateRelations();
        }
        return entityInfos;
    }

    @Override
    public Collection<EntityInfo> loadFromResources(boolean updateRelations) throws ModelException {
        ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
        for (Map.Entry entry : ServiceFactory.getServiceFinder((String)"META-INF/").findServiceConfigurations("MODEL-INDEX.LIST").entrySet()) {
            Object urlName = ((URL)entry.getValue()).toString();
            int ndx = ((String)urlName).indexOf("META-INF/");
            if (ndx >= 0) {
                urlName = ((String)urlName).substring(0, ndx) + (String)entry.getKey();
                try {
                    URL url = new URL((String)urlName);
                    entityInfos.add(this.loadFromURL(url, false));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ModelException("cannot create model URL for " + (String)entry.getKey() + " in " + entry.getValue());
                }
            }
            throw new ModelException("unexpected url: " + (String)urlName);
        }
        if (updateRelations) {
            this.updateRelations();
        }
        return entityInfos;
    }

    @Override
    public void updateRelations() throws ModelException {
        this.updateRelations(null);
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            EntityImpl entity = (EntityImpl)entityInfo.getEntity();
            for (Index idx : entity.getIndexes()) {
                IndexImpl index = (IndexImpl)idx;
                if (index.isParsed()) continue;
                index.parse(entity);
            }
            entity.validate();
        }
    }

    @Override
    public synchronized void clearModel() {
        this.nameToEntityInfoMap.clear();
        this.tableToEntityInfoMap.clear();
        this.classidToEntityInfoMap.clear();
        this.urlToEntityInfoMap.clear();
        this.entityToSourceInfoMap.clear();
        this.modelDirs.clear();
    }

    @Override
    public void refreshModel() throws ModelException {
        for (ModelDirectory modelDir : this.modelDirs.values()) {
            modelDir.markDirty();
            this.loadFromDirectory(modelDir.getPath(), false);
        }
        this.updateRelations();
    }

    @Override
    public synchronized Collection<Entity> getAllEntities() throws ModelException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        boolean refreshed = false;
        block0: do {
            for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
                if (entityInfo.hasChanged()) {
                    this.refreshModel();
                    list.clear();
                    refreshed = true;
                    continue block0;
                }
                list.add(entityInfo.getEntity());
            }
        } while (refreshed);
        return list;
    }

    @Override
    public synchronized Entity getByURL(URL url) throws ModelException {
        EntityInfo entityInfo = this.urlToEntityInfoMap.get(url);
        if (entityInfo != null && entityInfo.hasChanged()) {
            this.refreshModel();
            entityInfo = this.urlToEntityInfoMap.get(url);
        }
        return entityInfo == null ? null : entityInfo.getEntity();
    }

    @Override
    public synchronized Entity getByEntityName(String entityName) throws ModelException {
        String name = entityName.toLowerCase();
        EntityInfo entityInfo = this.nameToEntityInfoMap.get(name);
        if (entityInfo != null && entityInfo.hasChanged()) {
            this.refreshModel();
            entityInfo = this.nameToEntityInfoMap.get(name);
        }
        return entityInfo == null ? null : entityInfo.getEntity();
    }

    @Override
    public synchronized Entity getByTableName(String tableName) throws ModelException {
        EntityInfo entityInfo;
        int ndx = (tableName = tableName.toLowerCase()).indexOf(46);
        if (ndx >= 0) {
            tableName = tableName.substring(ndx + 1);
        }
        if ((entityInfo = this.tableToEntityInfoMap.get(tableName)) != null && entityInfo.hasChanged()) {
            this.refreshModel();
            entityInfo = this.tableToEntityInfoMap.get(tableName);
        }
        return entityInfo == null ? null : entityInfo.getEntity();
    }

    @Override
    public synchronized Entity getByClassId(int classId) throws ModelException {
        EntityInfo entityInfo = this.classidToEntityInfoMap.get(classId);
        if (entityInfo != null && entityInfo.hasChanged()) {
            this.refreshModel();
            entityInfo = this.classidToEntityInfoMap.get(classId);
        }
        return entityInfo == null ? null : entityInfo.getEntity();
    }

    @Override
    public EntityInfo getEntityInfo(Entity entity) throws ModelException {
        String name = entity.getName().toLowerCase();
        EntityInfo entityInfo = this.nameToEntityInfoMap.get(name);
        if (entityInfo != null && entityInfo.hasChanged()) {
            this.refreshModel();
            entityInfo = this.nameToEntityInfoMap.get(name);
        }
        if (entityInfo == null) {
            throw new ModelException("no such entity " + entity);
        }
        return entityInfo;
    }

    @Override
    public synchronized Collection<ForeignKey> getForeignKeys() throws ModelException {
        if (this.foreignKeys == null) {
            TreeMap<ForeignKeyImpl, ForeignKeyImpl> foreignKeyMap = new TreeMap<ForeignKeyImpl, ForeignKeyImpl>();
            LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
            for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
                Entity entity = entityInfo.getEntity();
                if (!entity.getInheritanceType().isMappingToOwnTable()) continue;
                for (Relation relation : entity.getTableRelations()) {
                    List<Object> referencingEntities;
                    Relation foreignRelation;
                    Attribute referencingAttribute = null;
                    Entity referencingEntity = null;
                    Attribute referencedAttribute = null;
                    Entity referencedEntity = null;
                    boolean composite = relation.isComposite();
                    if (!composite && (foreignRelation = relation.getForeignRelation()) != null && foreignRelation.getRelationType() == RelationType.LIST && foreignRelation.isComposite()) {
                        composite = true;
                    }
                    if (relation.getAttribute() != null) {
                        if (relation.getForeignEntity() == null) {
                            errors.add(new ModelError(relation, "no foreign entity for " + relation));
                        } else {
                            referencingEntity = relation.getEntity();
                            referencingAttribute = relation.getAttribute();
                            referencedEntity = relation.getForeignEntity();
                            referencedAttribute = referencedEntity.getAttributeByJavaName("id", true);
                        }
                    } else if (relation.getForeignAttribute() != null) {
                        referencingEntity = relation.getForeignEntity();
                        referencingAttribute = relation.getForeignAttribute();
                        referencedEntity = entity;
                        referencedAttribute = entity.getAttributeByJavaName("id", true);
                    } else {
                        if (!relation.getMethodArgs().isEmpty()) continue;
                        errors.add(new ModelError(relation, "broken foreign key relation " + relation + " in " + entity));
                    }
                    if (referencingEntity != null && referencingEntity.getTableProvidingEntity() == null) {
                        referencingEntities = referencingEntity.getLeafEntities();
                    } else {
                        referencingEntities = new ArrayList();
                        if (referencedEntity != null) {
                            referencingEntities.add(referencingEntity);
                        }
                    }
                    for (Entity entity2 : referencingEntities) {
                        if (entity2.getOptions().isProvided() || referencingAttribute == null || referencedAttribute == null || (composite || !referencedAttribute.getEntity().getIntegrity().isRelatedCheckedByDatabase()) && (!composite || !referencedAttribute.getEntity().getIntegrity().isCompositesCheckedByDatabase())) continue;
                        ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity2, referencingAttribute, referencedEntity, referencedAttribute, composite);
                        ForeignKey oppositeForeignKey = (ForeignKey)foreignKeyMap.get(foreignKey);
                        if (oppositeForeignKey != null) {
                            if (!composite || oppositeForeignKey.isComposite()) continue;
                            ((ForeignKeyImpl)oppositeForeignKey).setComposite(true);
                            continue;
                        }
                        foreignKeyMap.put(foreignKey, foreignKey);
                    }
                }
                if (entity.getOptions().isProvided() || entity.getSuperEntity() == null || !entity.getHierarchyInheritanceType().isMappingToOwnTable()) continue;
                Entity topEntity = entity.getTopSuperEntity();
                Attribute idAttribute = topEntity.getAttributeByJavaName("id", false);
                ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity, idAttribute, topEntity, idAttribute, false);
                foreignKeyMap.put(foreignKey, foreignKey);
            }
            if (!errors.isEmpty()) {
                throw new ModelException(errors);
            }
            this.foreignKeys = foreignKeyMap.values();
        }
        return this.foreignKeys;
    }

    protected void addEntityInfo(EntityInfo entityInfo) throws ModelException {
        String tableName;
        SourceInfo otherSourceInfo;
        String tableName2;
        if (this.mapSchemas && (tableName2 = entityInfo.getEntity().getTableName()) != null) {
            ((EntityImpl)entityInfo.getEntity()).setTableName(tableName2.replace('.', '_'));
        }
        URL url = entityInfo.getURL();
        this.urlToEntityInfoMap.put(url, entityInfo);
        SourceInfo sourceInfo = entityInfo.getEntity().getSourceInfo();
        if (sourceInfo != null && (otherSourceInfo = this.entityToSourceInfoMap.put(entityInfo.getEntity(), sourceInfo)) != null && !otherSourceInfo.equals(sourceInfo)) {
            throw new ModelException("entity " + entityInfo.getEntity() + " defined from more than one model file:\n" + otherSourceInfo + "\n" + sourceInfo);
        }
        EntityInfo oldEntityInfo = this.nameToEntityInfoMap.put(entityInfo.getEntity().getName().toLowerCase(), entityInfo);
        if (entityInfo.getEntity().getClassId() != 0) {
            if (oldEntityInfo != null && oldEntityInfo.getEntity().getClassId() != entityInfo.getEntity().getClassId()) {
                throw new ModelException("duplicate entity " + entityInfo.getEntity().getName() + " in " + url, entityInfo.getEntity());
            }
            oldEntityInfo = this.classidToEntityInfoMap.put(entityInfo.getEntity().getClassId(), entityInfo);
            if (oldEntityInfo != null && !oldEntityInfo.getEntity().getName().equals(entityInfo.getEntity().getName())) {
                throw new ModelException("duplicate entity id " + entityInfo.getEntity().getClassId() + " for " + entityInfo.getEntity().getName() + ", already assigned to " + oldEntityInfo.getEntity().getName(), entityInfo.getEntity());
            }
        }
        if ((tableName = entityInfo.getEntity().getTableNameWithoutSchema()) != null && (oldEntityInfo = this.tableToEntityInfoMap.put(tableName, entityInfo)) != null && !oldEntityInfo.getEntity().getName().equals(entityInfo.getEntity().getName())) {
            throw new ModelException("duplicate table name '" + entityInfo.getEntity().getTableNameWithoutSchema() + "' for " + entityInfo.getEntity().getName() + ", already assigned to " + oldEntityInfo.getEntity().getName(), entityInfo.getEntity());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void updateRelations(EntityInfo loadedEntityInfo) throws ModelException {
        Entity entity;
        LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
        Entity loadedEntity = loadedEntityInfo == null ? null : loadedEntityInfo.getEntity();
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entityInfo.getEntity().getSubEntities().clear();
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            if (entity.getSuperEntityName() == null) continue;
            Entity superEntity = this.getByEntityName(this.translateAlias(entity.getSuperEntityName()));
            if (superEntity == null) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, "no such super entity '" + entity.getSuperEntityName() + "' to be extended by '" + entity + "'"));
                continue;
            }
            ((EntityImpl)entity).setSuperEntity(superEntity);
            if (superEntity.getInheritanceType() == InheritanceType.NONE && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                errors.add(new ModelError(entity, "super entity '" + superEntity + "' extended by '" + entity + "' is not extensible (missing inheritance := ... ?)"));
            }
            superEntity.getSubEntities().add(entity);
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            void var8_61;
            entity = entityInfo.getEntity();
            boolean normTextProvided = entity.getOptions().isNormTextProvided();
            if (normTextProvided) continue;
            for (Attribute attribute : entity.getAttributes()) {
                if (!attribute.getOptions().isPartOfNormText()) continue;
                normTextProvided = true;
                break;
            }
            if (!normTextProvided) {
                for (Relation relation : entity.getRelations()) {
                    if (!relation.isPartOfNormText()) continue;
                    normTextProvided = true;
                    break;
                }
            }
            if (!normTextProvided) continue;
            Entity entity2 = entity.getSuperEntity();
            while (var8_61 != null) {
                entity = var8_61;
                if (var8_61.getOptions().isNormTextProvided()) {
                    normTextProvided = false;
                    break;
                }
                Entity entity3 = var8_61.getSuperEntity();
            }
            if (!normTextProvided) continue;
            ((EntityOptionsImpl)entity.getOptions()).setNormTextProvided(true);
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            entity.getReferencingRelations().clear();
            entity.getCompositePaths().clear();
            entity.getDeepReferences().clear();
            entity.getDeepReferencesToComponents().clear();
            ((EntityImpl)entity).setDeeplyReferenced(false);
            for (Relation relation : entity.getRelations()) {
                void var11_122;
                ((RelationImpl)relation).setForeignRelation(null);
                Entity entity4 = this.getByEntityName(this.translateAlias(relation.getClassName()));
                if (entity4 == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such entity: " + relation.getClassName()));
                    continue;
                }
                if (entity.getOptions().isProvided() && !entity4.getOptions().isProvided()) {
                    errors.add(new ModelError(relation, "provided entities cannot have relations to managed entities"));
                }
                ((RelationImpl)relation).setForeignEntity(entity4);
                if (relation.getRelationType() != RelationType.LIST) continue;
                Object attributeName = relation.getMethodName() != null ? relation.getMethodName() : relation.getEntity().getName() + "Id";
                Attribute attribute = entity4.getAttributeByJavaName((String)(attributeName = StringHelper.firstToLower((String)attributeName)), true);
                if (attribute == null) {
                    for (Relation fRel : entity4.getRelations()) {
                        if (fRel.getRelationType() != RelationType.OBJECT || !relation.getEntity().getName().equals(fRel.getClassName())) continue;
                        attributeName = StringHelper.firstToLower((String)(fRel.getName() + "Id"));
                        Attribute attribute2 = entity4.getAttributeByJavaName((String)attributeName, true);
                        break;
                    }
                    if (var11_122 == null && relation.getMethodArgs().isEmpty() && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                        errors.add(new ModelError(relation, "no such attribute: " + (String)attributeName + " in " + entity4 + " referenced by " + entity));
                    }
                }
                ((RelationImpl)relation).setForeignAttribute((Attribute)var11_122);
                if (relation.getNmName() == null) continue;
                Relation nmRelation = entity4.getRelation(relation.getNmName(), false);
                if (nmRelation == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such nm-relation: " + relation.getNmName() + " in " + entity4));
                    continue;
                }
                if ((nmRelation.isComposite() || nmRelation.getRelationType() == RelationType.LIST) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity4 + " must be non-composite object"));
                }
                if (this.translateAlias(nmRelation.getClassName()).equals(entity.getName()) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity4 + " points back to " + entity));
                }
                if (nmRelation.getSelectionType() == SelectionType.LAZY && !nmRelation.isSerialized()) {
                    ((RelationImpl)nmRelation).setSerialized(true);
                    ((RelationImpl)nmRelation).setClearOnRemoteSave(true);
                }
                ((RelationImpl)relation).setNmRelation(nmRelation);
                ((RelationImpl)nmRelation).setDefiningNmRelation(relation);
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            for (EntityInfo entityInfo2 : this.nameToEntityInfoMap.values()) {
                Entity entity5 = entityInfo2.getEntity();
                for (Relation relation : entity5.getRelations()) {
                    Entity foreignEntity = relation.getForeignEntity();
                    if (foreignEntity == null || !foreignEntity.equals(entity)) continue;
                    entity.getReferencingRelations().add(relation);
                }
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            block15: for (Relation relation : entity.getReferencingRelations()) {
                if (relation.getForeignRelation() != null) continue;
                for (Relation otherRelation : relation.getForeignEntity().getTableRelations()) {
                    if (!Objects.equals(relation.getEntity(), otherRelation.getForeignEntity()) || !Objects.equals(relation.getAttribute(), otherRelation.getForeignAttribute())) continue;
                    ((RelationImpl)relation).setForeignRelation(otherRelation);
                    ((RelationImpl)otherRelation).setForeignRelation(relation);
                    continue block15;
                }
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            boolean isRootEntity = true;
            for (Relation relation : entity.getAllReferencingRelations()) {
                if (!relation.isComposite() || entity.equals(relation.getEntity())) continue;
                isRootEntity = false;
                break;
            }
            ((EntityImpl)entity).setRootEntityAccordingToModel(isRootEntity);
            if (!isRootEntity) continue;
            for (Relation relation : entity.getAllRelations()) {
                if (!relation.isComposite() || relation.getForeignEntity() == null) continue;
                Iterator<Entity> compositePath = new ArrayList<Relation>();
                compositePath.add((Entity)((Object)relation));
                this.updateCompositePath((List<Relation>)((Object)compositePath), relation.getForeignEntity());
            }
        }
        block20: for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            Set<Entity> rootEntities = entity.getRootEntities();
            if (rootEntities.size() > 1 && entity.getRootAttribute() != null) {
                ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
            }
            if (!rootEntities.isEmpty()) {
                for (Relation relation : entity.getReferencingRelationsIncludingSubEntities()) {
                    if (relation.isComposite() || relation.getForeignRelation() != null && relation.getForeignRelation().isComposite() || rootEntities.containsAll(relation.getEntity().getRootEntities())) continue;
                    ((RelationImpl)relation).setDeepReference(true);
                    ((EntityImpl)entity).setDeeplyReferenced(true);
                    entity.getDeepReferences().add(relation);
                    for (List list : entity.getCompositePaths()) {
                        for (Relation compositeRelation : list) {
                            ((EntityImpl)compositeRelation.getEntity()).setDeeplyReferenced(true);
                        }
                    }
                    for (Entity entity6 : rootEntities) {
                        entity6.getDeepReferencesToComponents().add(relation);
                    }
                    if (entity.getRootEntity() != null) continue;
                    ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
                }
            }
            for (List<Relation> list : entity.getCompositePaths()) {
                if (list.size() <= 1 && list.get(list.size() - 1).getRelationType() != RelationType.OBJECT) continue;
                ((EntityImpl)entity).setProvidingRootIdAccordingToModel(true);
                continue block20;
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            ModelDefaults defaults = entityInfo.getModelDefaults();
            Entity entity2 = entityInfo.getEntity();
            if (defaults == null || entity2.getOptions().noModelDefaults()) continue;
            if (defaults.getTrackType() != null && defaults.getTrackType().ordinal() > entity2.getOptions().getTrackType().ordinal()) {
                ((EntityOptionsImpl)entity2.getOptions()).setTrackType(defaults.getTrackType());
            }
            if (Boolean.TRUE.equals(defaults.getRoot()) && entity2.isRootEntityAccordingToModel()) {
                ((EntityImpl)entity2.getTopSuperEntity()).getOptions().setRootEntity(true);
            }
            if (Boolean.TRUE.equals(defaults.getRootClassId()) && entity2.isProvidingRootClassIdAccordingToModel()) {
                ((EntityImpl)entity2.getTopSuperEntity()).getOptions().setRootClassIdProvided(true);
            }
            if (Boolean.TRUE.equals(defaults.getRootId()) && entity2.isProvidingRootIdAccordingToModel()) {
                ((EntityImpl)entity2.getTopSuperEntity()).getOptions().setRootIdProvided(true);
            }
            if (defaults.getRemote() == null) continue;
            ((EntityOptionsImpl)entity2.getOptions()).setRemote(defaults.getRemote());
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            if (entity.getOptions().isRootClassIdProvided()) {
                if (entity.getAttributeByColumnName("rootclassid", true) == null) {
                    ((EntityImpl)entity).getOptions().applyOption("ROOTCLASSID", Boolean.TRUE);
                }
            } else {
                Attribute rootClassAttribute = entity.getAttributeByColumnName("rootclassid", false);
                if (rootClassAttribute != null) {
                    entity.getAttributes().remove(rootClassAttribute);
                }
            }
            if (entity.getOptions().isRootIdProvided()) {
                if (entity.getAttributeByColumnName("rootid", true) != null) continue;
                ((EntityImpl)entity).getOptions().applyOption("ROOTID", Boolean.TRUE);
                continue;
            }
            Attribute rootAttribute = entity.getAttributeByColumnName("rootid", false);
            if (rootAttribute == null) continue;
            entity.getAttributes().remove(rootAttribute);
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            if (entity.getOptions().isCached() && !entity.isRootEntityAccordingToModel()) {
                errors.add(new ModelError(entity, "component " + entity + " cannot be cached"));
            }
            for (Relation relation : entity.getRelations()) {
                if (relation.getEntity().getOptions().getTrackType().isTracked()) {
                    ((RelationImpl)relation).setTracked(true);
                }
                if (relation.getForeignEntity() == null) continue;
                if (relation.isComposite()) {
                    if (relation.getRelationType() == RelationType.LIST) {
                        void var9_108;
                        Iterator parentRelations;
                        Relation relation2 = relation.getForeignEntity().getRelation(entity.getName(), true);
                        if (relation2 == null && (parentRelations = relation.getForeignEntity().getRelations(entity, true)).size() == 1) {
                            Relation relation3 = (Relation)parentRelations.get(0);
                        }
                        if (var9_108 != null && var9_108.getRelationType() == RelationType.OBJECT && var9_108.getSelectionType() == SelectionType.LAZY) {
                            if (relation.getLinkMethodName() == null || "set".equals(relation.getLinkMethodName())) {
                                ((RelationImpl)relation).setLinkMethodName("set" + StringHelper.firstToUpper((String)var9_108.getName()));
                            }
                            if (var9_108.getEntity().getOptions().isRemote()) {
                                ((RelationImpl)var9_108).setSerialized(true);
                            }
                        }
                    }
                    if (relation.getLinkMethodName() != null) {
                        ((RelationImpl)relation).setReferenced(true);
                    }
                    if (relation.isTracked() || !entity.getIntegrity().isCompositesCheckedByDatabase()) continue;
                    errors.add(new ModelError(relation, "untracked relation " + relation + " not allowed in conjunction with " + entity.getIntegrity() + "-integrity in " + entity));
                    continue;
                }
                if (relation.getRelationType() != RelationType.OBJECT || !relation.getForeignEntity().getOptions().isCached() || relation.isSerialized() || !((RelationImpl)relation).isSelectionTypeDetermined()) continue;
                ((RelationImpl)relation).setSelectionType(SelectionType.ALWAYS);
                ((RelationImpl)relation).setSelectionCached(true);
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            try {
                ((EntityImpl)entity).validateRelated();
            }
            catch (ModelException mex) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, mex.getMessage() + " in " + entity));
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            entity = entityInfo.getEntity();
            if (entity.getSuperEntity() != null || entity.getInheritanceType().isMappingToNoTable()) continue;
            HashMap<String, AttributeImpl> columnMap = new HashMap<String, AttributeImpl>();
            HashMap<String, AttributeImpl> hashMap = new HashMap<String, AttributeImpl>();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(entity.getAttributes());
            for (Entity entity7 : entity.getAllSubEntities()) {
                arrayList.addAll(entity7.getAttributes());
            }
            for (Attribute attribute : arrayList) {
                AttributeImpl attribute3 = (AttributeImpl)attribute;
                AttributeImpl oldAttribute = hashMap.put(attribute3.getName().toLowerCase(), attribute3);
                if (oldAttribute != null && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    StringBuilder exMsg = new StringBuilder();
                    exMsg.append("attribute '").append(attribute3.getName()).append("' in ").append(attribute3.getEntity());
                    exMsg.append(" already defined in ").append(oldAttribute.getEntity());
                    if (oldAttribute.getSourceLine() != null) {
                        exMsg.append("(").append(oldAttribute.getSourceLine()).append(")");
                    }
                    errors.add(new ModelError(attribute3, exMsg.toString()));
                }
                AttributeImpl oldColumn = columnMap.put(attribute3.getColumnName().toLowerCase(), attribute3);
                if (oldAttribute != null || oldColumn == null || loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                StringBuilder exMsg = new StringBuilder();
                exMsg.append("column '").append(attribute3.getColumnName()).append("' in ").append(attribute3.getEntity());
                exMsg.append(" already defined in ").append(oldColumn.getEntity());
                if (oldColumn.getSourceLine() != null) {
                    exMsg.append("(").append(oldColumn.getSourceLine()).append(")");
                }
                exMsg.append(" as attribute '").append(attribute3).append("'");
                errors.add(new ModelError(attribute3, exMsg.toString()));
            }
        }
        HashMap<String, Entity> aliasMap = new HashMap<String, Entity>();
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            Entity entity3 = entityInfo.getEntity();
            if (entity3.getTableAlias() == null) continue;
            Entity entity8 = (Entity)aliasMap.get(entity3.getTableAlias());
            if (entity8 != null) {
                errors.add(new ModelError(entity8, "table alias '" + entity3.getTableAlias() + "' defined more than once in " + entity3 + " and " + entity8));
                continue;
            }
            aliasMap.put(entity3.getTableAlias(), entity3);
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            Entity entity4 = entityInfo.getEntity();
            if (entity4.getTableName() == null || entity4.getTableAlias() != null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < entity4.getName().length(); ++i) {
                char currentChar = entity4.getName().charAt(i);
                if (!Character.isUpperCase(currentChar) && !Character.isDigit(currentChar)) continue;
                stringBuilder.append(currentChar);
            }
            this.applyTableAlias(aliasMap, entity4, stringBuilder.toString().toLowerCase());
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            void var11_135;
            Entity entity5 = entityInfo.getEntity();
            if (entity5.getTableName() == null || entity5.getTableAlias() != null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            List<String> syllables = ModelUtilities.getInstance().extractSyllables(entity5.getName());
            if (!syllables.isEmpty()) {
                for (String syllable : syllables) {
                    stringBuilder.append(syllable.charAt(0));
                    if (!this.applyTableAlias(aliasMap, entity5, stringBuilder.toString().toLowerCase())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.setLength(1);
            }
            boolean bl2 = true;
            while (var11_135 < entity5.getName().length() && var11_135 < 6) {
                char c = Character.toLowerCase(entity5.getName().charAt((int)var11_135));
                if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u') {
                    stringBuilder.append(c);
                    if (stringBuilder.length() >= 3 && this.applyTableAlias(aliasMap, entity5, stringBuilder.toString().toLowerCase())) {
                        bl = true;
                        break;
                    }
                }
                ++var11_135;
            }
            if (bl) continue;
            String string = entity5.getName().substring(0, 1).toLowerCase();
            int count = 1;
            while (!this.applyTableAlias(aliasMap, entity5, string + count)) {
                ++count;
            }
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            void var8_88;
            void var9_114;
            Entity entity6 = entityInfo.getEntity();
            boolean bl = false;
            Entity entity9 = entity6.getSuperEntity();
            while (var9_114 != null) {
                ++var8_88;
                Entity entity10 = var9_114.getSuperEntity();
            }
            ((EntityImpl)entity6).setOrdinal((int)var8_88);
        }
        for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
            int n;
            Entity entity7 = entityInfo.getEntity();
            if (entity7.isAbstract()) continue;
            Entity[] entityArray = new Entity[entityInfo.getEntity().getOrdinal() + 1];
            List<Entity> list = entity7.getSuperEntities();
            int superNdx = list.size() - 1;
            boolean bl = false;
            while (n < entityArray.length) {
                entityArray[n] = n < list.size() ? list.get(superNdx--) : entity7;
                ++n;
            }
            n = 0;
            int relationOrdinal = 0;
            int indexOrdinal = 0;
            for (Entity nextEntity : entityArray) {
                for (Attribute attribute : nextEntity.getAttributes()) {
                    void var11_139;
                    ((AttributeImpl)attribute).setOrdinal((int)(++var11_139));
                }
                for (Relation relation : nextEntity.getRelations()) {
                    ((RelationImpl)relation).setOrdinal(relationOrdinal++);
                }
                for (Index index : nextEntity.getIndexes()) {
                    ((IndexImpl)index).setOrdinal(indexOrdinal++);
                }
            }
        }
        if (loadedEntity != null) {
            Entity entity11 = loadedEntity.getTopSuperEntity();
            this.validateInheritanceHierarchy(entity11, entity11.getInheritanceType(), entity11.getOptions().getTrackType(), entity11.getIntegrity(), errors);
            this.validateComponents(entity11, entity11.getIntegrity(), errors);
        } else {
            for (EntityInfo entityInfo : this.nameToEntityInfoMap.values()) {
                Entity entity8 = entityInfo.getEntity();
                this.validateInheritanceHierarchy(entity8, entity8.getInheritanceType(), entity8.getOptions().getTrackType(), entity8.getIntegrity(), errors);
                this.validateComponents(entity8, entity8.getIntegrity(), errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new ModelException(errors);
        }
    }

    protected boolean applyTableAlias(Map<String, Entity> aliasMap, Entity entity, String alias) {
        if (aliasMap.get(alias) == null && this.isValidTableAlias(alias)) {
            ((EntityImpl)entity).setTableAlias(alias);
            aliasMap.put(alias, entity);
            return true;
        }
        return false;
    }

    protected boolean isValidTableAlias(String alias) {
        boolean valid = true;
        for (Backend backend : this.getEntityFactory().getBackends()) {
            try {
                backend.assertValidName(SqlNameType.TABLE_ALIAS, alias);
            }
            catch (RuntimeException rex) {
                valid = false;
                break;
            }
        }
        return valid;
    }

    protected void updateCompositePath(List<Relation> compositePath, Entity entity) {
        Relation lastRelation = compositePath.get(compositePath.size() - 1);
        if (lastRelation.getForeignAttribute() != null) {
            entity = lastRelation.getForeignAttribute().getEntity();
        }
        entity.getCompositePaths().add(compositePath);
        for (Relation relation : entity.getAllRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            ArrayList<Relation> newPath = new ArrayList<Relation>(compositePath);
            newPath.add(relation);
            this.updateCompositePath(newPath, foreignEntity);
        }
    }

    protected EntityFactory createEntityFactory() {
        return new EntityFactoryImpl();
    }

    protected ModelDirectory createModelDirectory(String modelDir) throws ModelException {
        return new ModelDirectoryImpl(modelDir, this.modelDefaults, this.entityAliases);
    }

    protected EntityInfo createEntityInfo(ModelDefaults defaults, URL url) throws ModelException {
        StringBuilder modelBuf = new StringBuilder();
        try (Reader reader = this.createReader(url);){
            int len;
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                modelBuf.append(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new ModelException("reading model '" + url + "' failed", ex);
        }
        String modelSource = modelBuf.toString();
        Document document = new Document(modelSource);
        if (document.getModelDefaults() != null) {
            defaults = document.getModelDefaults();
        }
        Entity entity = this.getEntityFactory().createEntity(document, defaults);
        return new EntityInfoImpl(entity, url, modelSource, defaults);
    }

    protected Reader createReader(URL url) throws ModelException {
        try {
            return new BufferedReader(new InputStreamReader(url.openStream(), Settings.getEncodingCharset()));
        }
        catch (IOException ex) {
            throw new ModelException("cannot open reader for " + url, ex);
        }
    }

    protected void validateInheritanceHierarchy(Entity entity, InheritanceType inheritanceType, TrackType trackType, Integrity integrity, Set<ModelError> errors) {
        if (entity.getOptions().getTrackType() != trackType) {
            errors.add(new ModelError(entity, entity + " has wrong track type " + entity.getOptions().getTrackType() + ", expected " + trackType));
        }
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        if (!entity.getSubEntities().isEmpty()) {
            if (entity.getInheritanceType() != inheritanceType) {
                errors.add(new ModelError(entity, entity + " has wrong inheritance type " + entity.getInheritanceType() + ", expected " + inheritanceType));
            }
            for (Entity child : entity.getSubEntities()) {
                this.validateInheritanceHierarchy(child, inheritanceType, trackType, integrity, errors);
            }
        }
    }

    protected void validateComponents(Entity entity, Integrity integrity, Set<ModelError> errors) {
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        for (Relation relation : entity.getRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            this.validateComponents(foreignEntity, integrity, errors);
        }
    }

    protected String translateAlias(String name) {
        String mappedName;
        if (this.entityAliases != null && (mappedName = (String)this.entityAliases.get(name)) != null) {
            name = mappedName;
        }
        return name;
    }
}

