/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;

public class MethodArgument {
    private final Relation relation;
    private String foreignAttributeName;
    private Attribute foreignAttribute;
    private Attribute attribute;
    private String value;

    public MethodArgument(Relation relation, Attribute attribute) {
        this.relation = relation;
        this.attribute = attribute;
    }

    public MethodArgument(Relation relation, String foreignAttributeName, Attribute attribute) {
        this.relation = relation;
        this.foreignAttributeName = foreignAttributeName;
        this.attribute = attribute;
    }

    public MethodArgument(Relation relation, String foreignAttributeName, String value) {
        this.relation = relation;
        this.foreignAttributeName = foreignAttributeName;
        this.value = value;
    }

    public boolean isValue() {
        return this.attribute == null;
    }

    public Attribute getForeignAttribute() {
        if (this.foreignAttribute == null) {
            if (this.foreignAttributeName != null) {
                Entity foreignEntity = this.relation.getForeignEntity();
                if (foreignEntity != null) {
                    this.foreignAttribute = foreignEntity.getAttributeByJavaName(this.foreignAttributeName, true);
                }
            } else {
                Entity foreignEntity;
                this.foreignAttribute = this.relation.getForeignAttribute();
                if (this.foreignAttribute == null && (foreignEntity = this.relation.getForeignEntity()) != null) {
                    this.foreignAttribute = foreignEntity.getAttributeByJavaName("id", true);
                }
            }
        }
        return this.foreignAttribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    public String getMethodArgument() {
        if (this.isValue()) {
            return this.value;
        }
        if (this.attribute.getOptions().isFromSuper() || !this.attribute.getEntity().equals(this.relation.getEntity())) {
            return "get" + StringHelper.firstToUpper((String)this.attribute.getName()) + "()";
        }
        return this.attribute.getName();
    }

    public String getSetterMethod() {
        return "set" + StringHelper.firstToUpper((String)this.getForeignAttribute().getName());
    }

    public String toString() {
        return this.getForeignAttribute() + "=" + this.getMethodArgument();
    }
}

