/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.Collection;
import java.util.Objects;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;

public class ModelError {
    private final ModelElement element;
    private final String message;

    public static String toString(Collection<ModelError> errors) {
        StringBuilder buf = new StringBuilder();
        for (ModelError error : errors) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(error);
        }
        return buf.toString();
    }

    public ModelError(ModelElement element, String message) {
        this.element = element;
        this.message = message;
    }

    public ModelError(ModelException modelException) {
        this(modelException.getElement(), modelException.getMessage());
    }

    public ModelElement getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean needSep = false;
        if (this.element != null) {
            needSep = true;
            buf.append(this.element.getName());
            SourceInfo sourceInfo = this.element.getSourceInfo();
            if (sourceInfo != null) {
                buf.append(" (").append(sourceInfo).append(')');
            }
        }
        if (this.message != null) {
            if (needSep) {
                buf.append(": ");
            }
            buf.append(this.message);
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.element);
        hash = 19 * hash + Objects.hashCode(this.message);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelError other = (ModelError)obj;
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        return Objects.equals(this.element, other.element);
    }
}

