/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.NameVerifier;
import org.tentackle.model.Relation;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeOptionsImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.parse.AttributeLine;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlNameType;

public class AttributeImpl
implements Attribute,
Comparable<AttributeImpl>,
Cloneable {
    private final EntityFactoryImpl factory;
    private final Entity entity;
    private final SourceInfo sourceInfo;
    private final boolean implicit;
    private Entity embeddingEntity;
    private AttributeOptionsImpl options;
    private AttributeLine sourceLine;
    private int ordinal;
    private String javaName;
    private String pathName;
    private String columnName;
    private DataType<?> dataType;
    private String applicationTypeName;
    private String innerTypeName;
    private DataType<?> innerType;
    private Integer size;
    private Integer scale;
    private Boolean nullable;
    private Relation relation;

    public AttributeImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo, boolean implicit, AttributeOptionsImpl options) {
        this.factory = factory;
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.implicit = implicit;
        this.options = options == null ? factory.createAttributeOptions(this, sourceInfo) : options;
    }

    public AttributeImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo, boolean implicit) {
        this(factory, entity, sourceInfo, implicit, null);
    }

    @Override
    public Attribute createEmbedded(Entity embeddingEntity, String pathName, String columnName) {
        AttributeImpl attribute = this.clone();
        attribute.embeddingEntity = embeddingEntity;
        attribute.options = this.options.clone(attribute);
        attribute.pathName = pathName;
        attribute.columnName = columnName;
        return attribute;
    }

    protected AttributeImpl clone() {
        try {
            return (AttributeImpl)super.clone();
        }
        catch (CloneNotSupportedException cnx) {
            throw new TentackleRuntimeException((Throwable)cnx);
        }
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public ModelElement getParent() {
        return this.entity;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + Objects.hashCode(this.entity);
        hash = 73 * hash + Objects.hashCode(this.getPathName());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (!Objects.equals(this.entity, other.entity)) {
            return false;
        }
        return Objects.equals(this.getPathName(), other.getPathName());
    }

    @Override
    public int compareTo(AttributeImpl o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int rv = Compare.compare((Comparable)((EntityImpl)this.entity), (Comparable)((EntityImpl)o.entity));
        if (rv == 0) {
            rv = Compare.compare((Comparable)((Object)this.getPathName()), (Comparable)((Object)o.getPathName()));
        }
        return rv;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isHidden() {
        return this.options.isHidden() || this.options.isFromSuper() || this.options.getAccessScope() != AccessScope.PUBLIC;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(Entity entity, AttributeLine line) throws ModelException {
        this.setSourceLine(line);
        this.setColumnName(line.getColumnName());
        this.setName(line.getJavaName());
        this.setScale(line.getScale());
        this.setSize(line.getSize());
        try {
            DataType dataType = DataTypeFactory.getInstance().get(line.getJavaType());
            if (dataType == null) {
                if (line.getInnerType() == null) throw line.createModelException("unknown type " + line.getJavaType());
                this.setDataType((DataType<?>)DataTypeFactory.getInstance().getConvertibleType());
                this.setInnerTypeName(line.getInnerType());
                this.setApplicationTypeName(line.getJavaType());
            } else {
                this.setDataType(dataType);
                if (line.getInnerType() != null) {
                    this.setInnerTypeName(line.getInnerType());
                }
            }
            if ("String".equals(line.getJavaType()) && Integer.valueOf(0).equals(line.getSize())) {
                this.setDataType(DataTypeFactory.getInstance().get(line.getJavaType(), "Large"));
            }
            if (this.isConvertible()) {
                this.setApplicationTypeName(line.getJavaType());
                this.getInnerTypeName();
            }
            this.getOptions().applyEntityOptions(entity.getOptions(), this.getDataType());
            this.getOptions().setComment(line.getComment());
            for (String option : line.getOptions()) {
                if (this.getOptions().processOption(option)) continue;
                if (option.startsWith("@")) {
                    if (StringHelper.isAllWhitespace((String)option.substring(1))) continue;
                    this.getOptions().getAnnotations().add(option);
                    continue;
                }
                if (!option.startsWith("#")) throw line.createModelException("illegal attribute option: " + option);
                String stereotype = option.substring(1);
                if (StringHelper.isAllWhitespace((String)stereotype)) continue;
                this.getOptions().getStereotypes().add(stereotype);
            }
            if (!this.getOptions().getBindOptions().contains("SIZE")) return;
            this.getOptions().removeBindOption("SIZE");
            if (this.getSize() != null && !this.getOptions().getBindOptions().contains("MAXCOLS")) {
                this.getOptions().addBindOption("MAXCOLS=" + this.getSize());
            }
            if (this.getScale() == null || this.getOptions().getBindOptions().contains("SCALE")) return;
            this.getOptions().addBindOption("SCALE=" + this.getScale());
            return;
        }
        catch (RuntimeException rx) {
            throw line.createModelException("syntax error", rx);
        }
    }

    @Override
    public boolean isConvertible() {
        return this.getDataType() == DataTypeFactory.getInstance().getConvertibleType();
    }

    @Override
    public boolean isEmbedded() {
        return this.entity.isEmbedded();
    }

    @Override
    public Entity getEmbeddingEntity() {
        return this.embeddingEntity;
    }

    @Override
    public String getPathName() {
        return this.pathName != null ? this.pathName : this.javaName;
    }

    public void setApplicationTypeName(String applicationTypeName) {
        this.applicationTypeName = applicationTypeName;
    }

    @Override
    public String getApplicationTypeName() throws ModelException {
        if (this.isConvertible()) {
            if (StringHelper.isAllWhitespace((String)this.applicationTypeName)) {
                throw this.createModelException("application specific type not set");
            }
        } else {
            throw this.createModelException("application specific type not supported for " + this.dataType);
        }
        return this.applicationTypeName;
    }

    public void setInnerTypeName(String innerTypeName) throws ModelException {
        if (!this.dataType.isModelProvidingInnerType()) {
            throw this.createModelException("type " + this.dataType + " does not support inner types");
        }
        if (this.isConvertible()) {
            this.innerType = DataTypeFactory.getInstance().get(innerTypeName);
            if (this.innerType == null) {
                throw this.createModelException("inner type " + innerTypeName + " not supported for type " + this.dataType);
            }
        }
        this.innerTypeName = innerTypeName;
    }

    @Override
    public String getInnerTypeName() throws ModelException {
        if (!this.dataType.isModelProvidingInnerType()) {
            throw this.createModelException("inner type not supported for type " + this.dataType);
        }
        if (StringHelper.isAllWhitespace((String)this.innerTypeName)) {
            throw this.createModelException("inner type not set for type " + this.dataType);
        }
        return this.innerTypeName;
    }

    @Override
    public DataType<?> getInnerDataType() throws ModelException {
        if (this.innerType == null) {
            throw this.createModelException("not a Convertible type");
        }
        return this.innerType;
    }

    @Override
    public DataType<?> getEffectiveDataType() throws ModelException {
        return this.isConvertible() ? this.getInnerDataType() : this.getDataType();
    }

    @Override
    public String getJavaType() throws ModelException {
        StringBuilder buf = new StringBuilder();
        if (this.isConvertible()) {
            buf.append(this.getApplicationTypeName());
        } else {
            String genType;
            buf.append(this.dataType.getJavaType());
            if (this.dataType.isJavaTypeGenerified() && (genType = this.getInnerTypeName()) != null) {
                buf.append('<');
                buf.append(genType);
                buf.append('>');
            }
        }
        return buf.toString();
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public String getName() {
        return this.javaName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getColumnName(Backend backend, int columnIndex) throws ModelException {
        DataType<?> effectiveDataType = this.getEffectiveDataType();
        if (effectiveDataType.isColumnCountBackendSpecific() && backend == null) {
            throw new ModelException("backend-specific type " + effectiveDataType + " has no known column names");
        }
        return this.getColumnName() + this.getEffectiveDataType().getColumnSuffix(backend, columnIndex).orElse("");
    }

    @Override
    public DataType<?> getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public AttributeOptionsImpl getOptions() {
        return this.options;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setDataType(DataType<?> dataType) {
        this.dataType = dataType;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setName(String javaName) {
        this.javaName = javaName;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public boolean isNullable() throws ModelException {
        if (this.nullable != null) {
            return this.nullable;
        }
        DataType<?> type = this.getEffectiveDataType();
        return !type.isPrimitive() && !this.getOptions().isMapNull();
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.getPathName();
    }

    @Override
    public void validate() throws ModelException {
        if (StringHelper.isAllWhitespace((String)this.getName())) {
            throw this.createModelException("missing Java name");
        }
        if (StringHelper.isReservedWord((String)this.getName())) {
            throw this.createModelException("'" + this.getName() + "' is a reserved Java keyword");
        }
        String diag = NameVerifier.getInstance().verifyAttributeName(this);
        if (diag != null) {
            throw this.createModelException(diag);
        }
        if (StringHelper.isAllWhitespace((String)this.getColumnName())) {
            throw this.createModelException("missing column name");
        }
        diag = NameVerifier.getInstance().verifyColumnName(this);
        if (diag != null) {
            throw this.createModelException(diag);
        }
        for (Backend backend : this.factory.getBackends()) {
            try {
                backend.assertValidName(SqlNameType.COLUMN_NAME, this.getColumnName());
            }
            catch (RuntimeException rex) {
                throw new ModelException(rex.getMessage(), this, rex);
            }
        }
        if (this.dataType == null) {
            throw this.createModelException("missing data type");
        }
        if (this.dataType.isModelProvidingInnerType() && StringHelper.isAllWhitespace((String)this.getInnerTypeName())) {
            throw this.createModelException("missing inner type");
        }
        if (this.getScale() != null && !this.dataType.isNumeric()) {
            throw this.createModelException("non-numeric type does not support scale");
        }
        this.getOptions().validate();
        if (this.getOptions().isUTC() && !this.dataType.isUTCSupported()) {
            throw this.createModelException("UTC option not applicable to " + this.dataType);
        }
        if (this.getOptions().isWithTimezone() && !this.dataType.isTimezoneApplicable()) {
            throw this.createModelException("TZ option not applicable to " + this.dataType);
        }
        if (this.getOptions().isMapNull() && !this.dataType.isMapNullSupported()) {
            throw this.createModelException("MAPNULL option not applicable to " + this.dataType);
        }
        if (this.getOptions().isMute() && this.dataType.isPrimitive() && this.getOptions().getDefaultValue() == null) {
            throw this.createModelException("MUTE only applicable to nullable columns or columns with a default value");
        }
        if (this.isEmbedded()) {
            if (this.getOptions().isContextId()) {
                throw this.createModelException("CONTEXT option not allowed for embedded attributes");
            }
            if (this.getOptions().isDomainKey()) {
                throw this.createModelException("KEY option not allowed for embedded attributes");
            }
        }
    }

    public AttributeLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(AttributeLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this);
        return ex;
    }

    @Override
    public String getMethodNameSuffix() {
        return StringHelper.firstToUpper((String)this.javaName);
    }

    @Override
    public String getGetterName() {
        return CodeFactory.getInstance().createGetterName(this);
    }

    @Override
    public String getSetterName() {
        return CodeFactory.getInstance().createSetterName(this);
    }

    @Override
    public String getBindableAnnotation() {
        return CodeFactory.getInstance().createBindableAnnotation(this);
    }

    @Override
    public String toMethodArgument(String value) throws ModelException {
        return CodeFactory.getInstance().createMethodArgument(this, value);
    }
}

