/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.Entity;
import org.tentackle.model.ForeignKey;
import org.tentackle.sql.Backend;

public class ForeignKeyImpl
implements ForeignKey,
Comparable<ForeignKey> {
    private final Entity referencingEntity;
    private final Attribute referencingAttribute;
    private final Entity referencedEntity;
    private final Attribute referencedAttribute;
    private boolean composite;

    public ForeignKeyImpl(Entity referencingEntity, Attribute referencingAttribute, Entity referencedEntity, Attribute referencedAttribute, boolean composite) {
        this.referencingEntity = referencingEntity;
        this.referencingAttribute = referencingAttribute;
        this.referencedEntity = referencedEntity;
        this.referencedAttribute = referencedAttribute;
        this.composite = composite;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.referencingEntity);
        hash = 89 * hash + Objects.hashCode(this.referencingAttribute);
        hash = 89 * hash + Objects.hashCode(this.referencedAttribute);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKeyImpl other = (ForeignKeyImpl)obj;
        if (!Objects.equals(this.referencingEntity, other.referencingEntity)) {
            return false;
        }
        if (!Objects.equals(this.referencingAttribute, other.referencingAttribute)) {
            return false;
        }
        return Objects.equals(this.referencedAttribute, other.referencedAttribute);
    }

    @Override
    public int compareTo(ForeignKey o) {
        int rv;
        if (o == null) {
            rv = Integer.MAX_VALUE;
        } else {
            rv = Compare.compare((Comparable)((Object)this.getReferencingEntity().getName()), (Comparable)((Object)o.getReferencingEntity().getName()));
            if (rv == 0) {
                rv = Compare.compare((Comparable)((Object)this.getReferencingAttribute().getPathName()), (Comparable)((Object)o.getReferencingAttribute().getPathName()));
            }
        }
        return rv;
    }

    @Override
    public Entity getReferencingEntity() {
        return this.referencingEntity;
    }

    @Override
    public Attribute getReferencingAttribute() {
        return this.referencingAttribute;
    }

    @Override
    public Entity getReferencedEntity() {
        return this.referencedEntity;
    }

    @Override
    public Attribute getReferencedAttribute() {
        return this.referencedAttribute;
    }

    @Override
    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    @Override
    public String sqlCreateForeignKey(Backend backend) {
        return CodeFactory.getInstance().createSqlForeignKey(this, backend);
    }

    @Override
    public Entity getReferencingTableProvidingEntity() {
        Entity entity = this.getReferencingEntity().getTableProvidingEntity();
        if (entity == null) {
            entity = this.getReferencingEntity();
        }
        return entity;
    }

    @Override
    public Entity getReferencedTableProvidingEntity() {
        Entity entity = this.getReferencedEntity().getTableProvidingEntity();
        if (entity == null) {
            entity = this.getReferencedEntity();
        }
        return entity;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.referencingEntity != null) {
            buf.append(this.referencingEntity).append('.').append(this.referencingAttribute);
        }
        buf.append(": ");
        if (this.referencedEntity != null) {
            buf.append(this.referencedEntity).append('.').append(this.referencedAttribute);
        }
        return buf.toString();
    }
}

