/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import java.util.Locale;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;

public class IndexMigrator {
    private final Backend backend;
    private final Entity entity;
    private final Index index;
    private final IndexMetaData indexMetaData;

    public IndexMigrator(Entity entity, Index index, Backend backend, IndexMetaData indexMetaData) {
        this.backend = backend;
        this.entity = entity;
        this.index = index;
        this.indexMetaData = indexMetaData;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Index getIndex() {
        return this.index;
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public Result migrate() {
        StringBuilder dropSql = new StringBuilder();
        StringBuilder createSql = new StringBuilder();
        if (this.indexMetaData == null) {
            createSql.append(this.createIndex());
        } else if (this.index == null) {
            dropSql.append(this.dropIndex());
        } else {
            StringBuilder buf = new StringBuilder();
            if (IndexMigrator.isLogicallyDifferent(this.backend, this.index, this.indexMetaData, buf)) {
                dropSql.append((CharSequence)buf);
                dropSql.append(this.dropIndex());
                createSql.append(this.createIndex());
            }
        }
        return new Result(dropSql.toString(), createSql.toString());
    }

    public static boolean isLogicallyDifferent(Backend backend, Index modelIndex, IndexMetaData dbIndex, StringBuilder commentBuf) {
        boolean different;
        boolean bl = different = modelIndex.isUnique() != dbIndex.isUnique();
        if (!different) {
            String modelFilter = modelIndex.getFilterCondition();
            modelFilter = StringHelper.isAllWhitespace((String)modelFilter) ? "" : modelFilter.toUpperCase(Locale.ROOT);
            String currentFilter = dbIndex.getFilterCondition();
            currentFilter = StringHelper.isAllWhitespace((String)currentFilter) ? "" : currentFilter.toUpperCase(Locale.ROOT);
            boolean bl2 = different = !IndexMigrator.equalsIgnoreMatchingParenthesis(modelFilter, currentFilter);
            if (different && commentBuf != null) {
                commentBuf.append(backend.getSingleLineComment()).append(" filter in database = ").append(IndexMigrator.encloseInParenthesis(currentFilter)).append('\n').append(backend.getSingleLineComment()).append("        in model    = ").append(IndexMigrator.encloseInParenthesis(modelFilter)).append('\n');
            }
        }
        if (!different) {
            if (modelIndex.getAttributes().size() == dbIndex.getColumns().size()) {
                for (int position = 0; position < modelIndex.getAttributes().size(); ++position) {
                    IndexAttribute indexAttribute = modelIndex.getAttributes().get(position);
                    IndexColumnMetaData indexColumn = (IndexColumnMetaData)dbIndex.getColumns().get(position);
                    if (indexAttribute.isDescending() == indexColumn.isDescending() && indexAttribute.getAttribute().getColumnName().equals(indexColumn.getColumnName()) && Objects.equals(indexAttribute.getFunctionName(), indexColumn.getFunctionName())) continue;
                    different = true;
                    break;
                }
            } else {
                different = true;
            }
        }
        return different;
    }

    private String createIndex() {
        return this.index.sqlCreateIndex(this.backend, this.entity);
    }

    private String dropIndex() {
        return this.backend.sqlDropIndex(this.indexMetaData.getTableMetaData().getSchemaName(), this.indexMetaData.getTableMetaData().getTableName(), this.indexMetaData.getIndexName());
    }

    private static boolean equalsIgnoreMatchingParenthesis(String s1, String s2) {
        s1 = s1.replace(" ", "");
        s2 = s2.replace(" ", "");
        int ndx1 = 0;
        int ndx2 = 0;
        int pending1 = 0;
        int pending2 = 0;
        while (ndx1 < s1.length() || ndx2 < s2.length()) {
            char c2;
            char c1 = ndx1 < s1.length() ? s1.charAt(ndx1) : (char)'\u0000';
            char c = c2 = ndx2 < s2.length() ? s2.charAt(ndx2) : (char)'\u0000';
            if (c1 != c2) {
                if (c1 == '(') {
                    ++pending1;
                    ++ndx1;
                    continue;
                }
                if (c1 == ')') {
                    if (pending1 <= 0) break;
                    --pending1;
                    ++ndx1;
                    continue;
                }
                if (c2 == '(') {
                    ++pending2;
                    ++ndx2;
                    continue;
                }
                if (c2 != ')' || pending2 <= 0) break;
                --pending2;
                ++ndx2;
                continue;
            }
            if (ndx1 < s1.length()) {
                ++ndx1;
            }
            if (ndx2 >= s2.length()) continue;
            ++ndx2;
        }
        return ndx1 == s1.length() && ndx2 == s2.length() && pending1 == 0 && pending2 == 0;
    }

    private static String encloseInParenthesis(String s) {
        return !s.startsWith("(") || !s.endsWith(")") ? "(" + s + ")" : s;
    }

    public record Result(String dropSql, String createSql) {
        public Result sum(Result result) {
            return new Result(this.dropSql + result.dropSql, this.createSql + result.createSql);
        }
    }
}

