/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tentackle.model.ModelException;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.LineType;
import org.tentackle.model.parse.MultiLine;
import org.tentackle.model.parse.OptionParser;

public class RelationLine
extends MultiLine {
    private String className;
    private Map<String, String> properties;

    public RelationLine(Document document, int offset, LineType lineType) {
        super(document, offset, lineType);
    }

    @Override
    public void parse() throws ModelException {
        String prop;
        super.parse();
        String text = this.getText();
        int ndx = text.indexOf(58);
        if (ndx < 0) {
            throw this.createModelException("missing colon (:)");
        }
        this.className = text.substring(0, ndx).trim();
        if (this.className.length() == 0) {
            throw this.createModelException("missing classname");
        }
        String configText = text.substring(ndx + 1);
        this.properties = new LinkedHashMap<String, String>();
        OptionParser parser = new OptionParser(configText, null);
        while ((prop = parser.nextOption()) != null) {
            if (prop.length() <= 0) continue;
            int n = ndx = prop.charAt(0) == '@' ? -1 : prop.indexOf(61);
            if (ndx > 0) {
                String propName = prop.substring(0, ndx).trim();
                if (propName.length() == 0) {
                    throw this.createModelException("missing property name");
                }
                String propValue = prop.substring(ndx + 1).trim();
                this.properties.put(propName, propValue);
                continue;
            }
            this.properties.put(prop, "");
        }
    }

    public String getClassName() throws ModelException {
        this.assertParsed();
        return this.className;
    }

    public Map<String, String> getProperties() throws ModelException {
        this.assertParsed();
        return this.properties;
    }
}

