/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.print.AttributePrinter;
import org.tentackle.model.print.PrintConfiguration;

public class AttributeSectionPrinter {
    private final List<AttributePrinter> printers;
    private final PrintConfiguration configuration;

    public AttributeSectionPrinter(Entity entity, PrintConfiguration configuration) {
        this.configuration = configuration;
        this.printers = new ArrayList<AttributePrinter>();
        for (Attribute attribute : entity.getAttributes()) {
            if (attribute.isImplicit()) continue;
            this.printers.add(new AttributePrinter(attribute, configuration));
        }
    }

    public String print() {
        int maxTypeLen = 0;
        int maxNameLen = 0;
        int maxColumnLen = 0;
        for (AttributePrinter printer : this.printers) {
            String str = printer.printType();
            if (maxTypeLen < str.length()) {
                maxTypeLen = str.length();
            }
            if (maxNameLen < (str = printer.printJavaName()).length()) {
                maxNameLen = str.length();
            }
            if (maxColumnLen >= (str = printer.printColumnName()).length()) continue;
            maxColumnLen = str.length();
        }
        maxTypeLen += this.configuration.getColumnGap();
        maxNameLen += this.configuration.getColumnGap();
        maxColumnLen += this.configuration.getColumnGap();
        StringBuilder buf = new StringBuilder();
        for (AttributePrinter printer : this.printers) {
            if (this.configuration.isPrintingAsComment()) {
                buf.append(" * ");
            }
            buf.append(StringHelper.fillRight((String)printer.printType(), (int)maxTypeLen, (char)' ')).append(StringHelper.fillRight((String)printer.printJavaName(), (int)maxNameLen, (char)' ')).append(StringHelper.fillRight((String)printer.printColumnName(), (int)maxColumnLen, (char)' ')).append(printer.printComment()).append('\n');
        }
        return buf.toString();
    }
}

