/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.model.ModelUtilities;
import org.tentackle.model.migrate.ColumnMigration;
import org.tentackle.model.migrate.ColumnMigrator;
import org.tentackle.model.migrate.ForeignKeyMigrator;
import org.tentackle.model.migrate.IndexMigrator;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyAction;
import org.tentackle.sql.metadata.ForeignKeyColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public class TableMigrator {
    private final Entity entity;
    private final Collection<ForeignKey> foreignKeys;
    private final Backend backend;
    private final TableMetaData table;

    public TableMigrator(Entity entity, Collection<ForeignKey> foreignKeys, Backend backend, TableMetaData table) {
        this.entity = entity;
        this.foreignKeys = foreignKeys;
        this.backend = backend;
        this.table = table;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public TableMetaData getTable() {
        return this.table;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.entity.getName());
        buf.append(" -> ");
        if (this.table == null) {
            buf.append("table missing");
        } else {
            buf.append(this.table.getFullTableName());
        }
        return buf.toString();
    }

    public Result migrate(Collection<Pattern> hints, Collection<ColumnMigration> columnMigrations, Map<String, String> renameColumns) throws ModelException {
        StringBuilder tableSql = new StringBuilder();
        StringBuilder foreignKeySql = new StringBuilder();
        StringBuilder warningSql = new StringBuilder();
        if (this.table == null) {
            tableSql.append(this.createTable());
            foreignKeySql.append(this.createForeignKeys());
        } else {
            IndexMigrator.Result indexResult = this.migrateIndexes();
            tableSql.append(indexResult.dropSql());
            tableSql.append(this.migrateForeignKeysToDrop());
            ColumnsResult columnsResult = this.migrateColumns(hints, columnMigrations, renameColumns);
            tableSql.append(columnsResult.tableSql);
            warningSql.append(columnsResult.warningSql);
            tableSql.append(this.migrateTable());
            tableSql.append(indexResult.createSql());
            foreignKeySql.append(this.migrateForeignKeysToAdd());
        }
        if (!tableSql.isEmpty()) {
            tableSql.insert(0, '\n');
        }
        return new Result(hints, columnMigrations, renameColumns, tableSql.toString(), foreignKeySql.toString(), warningSql.toString());
    }

    private String createTable() throws ModelException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entity.sqlCreateTable(this.backend));
        for (Index index : this.entity.getTableIndexes()) {
            buf.append(index.sqlCreateIndex(this.backend, this.entity));
        }
        return buf.toString();
    }

    private String createForeignKeys() {
        StringBuilder buf = new StringBuilder();
        for (ForeignKey foreignKey : this.foreignKeys) {
            buf.append(foreignKey.sqlCreateForeignKey(this.backend));
        }
        return buf.toString();
    }

    private ColumnMigration getColumnMigrationForColumn(String columName, Collection<ColumnMigration> columnMigrations) {
        if (columnMigrations != null && columName != null) {
            for (ColumnMigration migration : columnMigrations) {
                if (!StringHelper.equalsIgnoreCase((String)columName, (String)migration.getColumnName())) continue;
                return migration;
            }
        }
        return null;
    }

    private ColumnMigration getColumnMigrationForNewColumn(String newColumName, Collection<ColumnMigration> columnMigrations) {
        if (columnMigrations != null && newColumName != null) {
            for (ColumnMigration migration : columnMigrations) {
                if (!StringHelper.equalsIgnoreCase((String)newColumName, (String)migration.getNewColumnName())) continue;
                return migration;
            }
        }
        return null;
    }

    private String migrateTable() {
        String sql;
        if (!Objects.equals(this.table.getComment(), this.entity.getOptions().getComment()) && (sql = this.backend.sqlAlterTableComment(this.entity.getTableName(), this.entity.getOptions().getComment())) != null && !sql.isEmpty()) {
            return sql;
        }
        return "";
    }

    private ColumnsResult migrateColumns(Collection<Pattern> hints, Collection<ColumnMigration> columnMigrations, Map<String, String> renameColumns) throws ModelException {
        DataType<?> addDataType;
        StringBuilder sqlBuf = new StringBuilder();
        StringBuilder warnBuf = new StringBuilder();
        LinkedHashMap<String, ColumnMetaData> columnsToDrop = new LinkedHashMap<String, ColumnMetaData>();
        LinkedHashSet<Attribute> attributesToAdd = new LinkedHashSet<Attribute>();
        LinkedHashMap attributesToMigrate = new LinkedHashMap();
        for (ColumnMetaData columnMetaData : this.table.getColumns()) {
            columnsToDrop.put(columnMetaData.getColumnName(), columnMetaData);
        }
        for (Attribute attribute : this.entity.getTableAttributes()) {
            int columnIndex;
            ArrayList<ColumnMetaData> matchingColumns = new ArrayList<ColumnMetaData>();
            DataType<?> dataType = attribute.getEffectiveDataType();
            for (columnIndex = 0; columnIndex < dataType.getColumnCount(this.backend); ++columnIndex) {
                ColumnMetaData column = this.table.getColumnByName(attribute.getColumnName(this.backend, columnIndex));
                if (column == null) continue;
                matchingColumns.add(column);
            }
            if (matchingColumns.isEmpty()) {
                if (renameColumns != null) {
                    for (columnIndex = 0; columnIndex < dataType.getColumnCount(this.backend); ++columnIndex) {
                        ColumnMetaData column;
                        ColumnMetaData oldColumn;
                        String oldColumnName = renameColumns.get(attribute.getColumnName(this.backend, columnIndex));
                        if (oldColumnName == null || (oldColumn = (ColumnMetaData)columnsToDrop.get(oldColumnName)) == null || (column = this.table.getColumnByName(oldColumnName)) == null) continue;
                        matchingColumns.add(column);
                    }
                    if (matchingColumns.size() == dataType.getColumnCount(this.backend)) {
                        attributesToMigrate.put(attribute, matchingColumns);
                        for (ColumnMetaData column : matchingColumns) {
                            columnsToDrop.remove(column.getColumnName());
                        }
                        continue;
                    }
                }
                attributesToAdd.add(attribute);
                continue;
            }
            for (ColumnMetaData matchingColumn : matchingColumns) {
                columnsToDrop.remove(matchingColumn.getColumnName());
            }
            attributesToMigrate.put(attribute, matchingColumns);
        }
        Iterator<Object> addAttributeIterator = attributesToAdd.iterator();
        while (addAttributeIterator.hasNext()) {
            Attribute attribute = (Attribute)addAttributeIterator.next();
            addDataType = attribute.getEffectiveDataType();
            String addSql = new ColumnMigrator(this.entity, attribute, this.backend, new ColumnMetaData[0]).migrate();
            Pattern addHint = this.sqlMatchesHint(addSql, hints);
            ColumnMetaData typeMatchingColumn = null;
            for (ColumnMetaData dropColumn : columnsToDrop.values()) {
                if (!dropColumn.matchesSqlType(addDataType.getSqlType(this.backend, 0))) continue;
                if (typeMatchingColumn == null) {
                    typeMatchingColumn = dropColumn;
                    continue;
                }
                typeMatchingColumn = null;
                break;
            }
            ArrayList<ColumnMetaData> matchingColumns = new ArrayList<ColumnMetaData>();
            if (typeMatchingColumn != null) {
                for (int columnIndex = 0; columnIndex < addDataType.getColumnCount(this.backend); ++columnIndex) {
                    String columnName = typeMatchingColumn.getColumnName() + addDataType.getColumnSuffix(this.backend, columnIndex).orElse("");
                    ColumnMetaData dropColumn = (ColumnMetaData)columnsToDrop.get(columnName);
                    if (dropColumn == null) continue;
                    matchingColumns.add(dropColumn);
                }
            }
            if (matchingColumns.size() != addDataType.getColumnCount(this.backend)) continue;
            String renameSql = new ColumnMigrator(this.entity, attribute, this.backend, matchingColumns).migrate();
            Pattern renameHint = this.sqlMatchesHint(renameSql, hints);
            String dropSql = new ColumnMigrator(this.entity, null, this.backend, matchingColumns).migrate();
            Pattern dropHint = this.sqlMatchesHint(dropSql, hints);
            if (renameHint != null) {
                if (addHint != null) {
                    throw new ModelException("migration hints collision:\n'" + addHint + "' applies to '" + (String)addSql + "'\n'" + renameHint + "' applies to '" + renameSql + "'\n-> fix hints!");
                }
                if (dropHint != null) {
                    throw new ModelException("migration hints collision:\n'" + dropHint + "' applies to '" + dropSql + "'\n'" + renameHint + "' applies to '" + renameSql + "'\n-> fix hints!");
                }
            } else {
                if (addHint != null || dropHint != null) {
                    sqlBuf.append(this.backend.sqlComment(renameSql));
                    sqlBuf.append(this.backend.getSingleLineComment()).append(" disabled by hint '");
                    if (addHint != null) {
                        sqlBuf.append(addHint);
                    }
                    if (dropHint != null) {
                        sqlBuf.append(dropHint);
                    }
                    sqlBuf.append("'\n");
                    continue;
                }
                sqlBuf.append(this.backend.sqlComment(addSql));
                sqlBuf.append(this.backend.sqlComment(dropSql));
            }
            addAttributeIterator.remove();
            for (ColumnMetaData dropColumn : matchingColumns) {
                columnsToDrop.remove(dropColumn.getColumnName());
            }
            attributesToMigrate.put(attribute, matchingColumns);
        }
        if (!columnsToDrop.isEmpty() && hints != null && !hints.isEmpty()) {
            addAttributeIterator = attributesToAdd.iterator();
            block10: while (addAttributeIterator.hasNext()) {
                Attribute attribute = (Attribute)addAttributeIterator.next();
                addDataType = attribute.getEffectiveDataType();
                for (ColumnMetaData dropColumn : new ArrayList(columnsToDrop.values())) {
                    String renameSql;
                    Pattern renameHint;
                    ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
                    for (int columnIndex = 0; columnIndex < addDataType.getColumnCount(this.backend); ++columnIndex) {
                        String columnName = dropColumn.getColumnName() + addDataType.getColumnSuffix(this.backend, columnIndex).orElse("");
                        ColumnMetaData column = (ColumnMetaData)columnsToDrop.get(columnName);
                        if (column == null) continue;
                        columns.add(column);
                    }
                    if (columns.size() != addDataType.getColumnCount(this.backend) || (renameHint = this.sqlMatchesHint(renameSql = new ColumnMigrator(this.entity, attribute, this.backend, columns).migrate(), hints)) == null) continue;
                    addAttributeIterator.remove();
                    for (ColumnMetaData column : columns) {
                        columnsToDrop.remove(column.getColumnName());
                    }
                    attributesToMigrate.put(attribute, columns);
                    continue block10;
                }
            }
        }
        for (Attribute attribute : attributesToAdd.stream().sorted((o1, o2) -> o2.getColumnName().length() - o1.getColumnName().length()).toList()) {
            String dropSql;
            Pattern dropHint;
            String addSql = new ColumnMigrator(this.entity, attribute, this.backend, new ColumnMetaData[0]).migrate();
            Pattern addHint = this.sqlMatchesHint(addSql, hints);
            if (addHint != null) continue;
            DataType<?> addDataType2 = attribute.getEffectiveDataType();
            ArrayList<ColumnMetaData> matchingColumns = new ArrayList<ColumnMetaData>();
            for (int columnIndex = 0; columnIndex < addDataType2.getColumnCount(this.backend); ++columnIndex) {
                String columnName = attribute.getColumnName() + addDataType2.getColumnSuffix(this.backend, columnIndex).orElse("");
                ArrayList<String> possibleNames = new ArrayList<String>();
                for (ColumnMetaData dropColumn : columnsToDrop.values()) {
                    if (!dropColumn.matchesSqlType(addDataType2.getSqlType(this.backend, columnIndex))) continue;
                    possibleNames.add(dropColumn.getColumnName());
                }
                String matchingName = ModelUtilities.getInstance().bestMatch(columnName, possibleNames);
                if (matchingName == null) continue;
                matchingColumns.add((ColumnMetaData)columnsToDrop.get(matchingName));
            }
            if (matchingColumns.size() != addDataType2.getColumnCount(this.backend) || (dropHint = this.sqlMatchesHint(dropSql = new ColumnMigrator(this.entity, null, this.backend, matchingColumns).migrate(), hints)) != null) continue;
            attributesToAdd.remove(attribute);
            attributesToMigrate.put(attribute, matchingColumns);
            for (ColumnMetaData matchingColumn : matchingColumns) {
                columnsToDrop.remove(matchingColumn.getColumnName());
            }
            sqlBuf.append(this.backend.sqlComment(addSql));
            sqlBuf.append(this.backend.sqlComment(dropSql));
        }
        for (ColumnMetaData columnMetaData : columnsToDrop.values()) {
            if (this.getColumnMigrationForColumn(columnMetaData.getColumnName(), columnMigrations) != null) continue;
            sqlBuf.append(new ColumnMigrator(this.entity, null, this.backend, columnMetaData).migrate());
        }
        for (Attribute attribute : attributesToAdd) {
            if (this.getColumnMigrationForNewColumn(attribute.getColumnName(), columnMigrations) != null) continue;
            sqlBuf.append(new ColumnMigrator(this.entity, attribute, this.backend, new ColumnMetaData[0]).migrate());
        }
        for (Map.Entry entry : attributesToMigrate.entrySet()) {
            String columnName = ((ColumnMetaData)((Collection)entry.getValue()).iterator().next()).getColumnName();
            ColumnMigration explicitMigration = this.getColumnMigrationForColumn(columnName, columnMigrations);
            String migrationCode = new ColumnMigrator(this.entity, (Attribute)entry.getKey(), this.backend, (Collection)entry.getValue()).migrate();
            if (migrationCode.isEmpty()) {
                if (explicitMigration == null) continue;
                columnMigrations.remove(explicitMigration);
                continue;
            }
            if (StringHelper.startsWithAnyOf((String)migrationCode, (String[])this.backend.getSingleLineComments()) != null) {
                warnBuf.append(migrationCode);
                continue;
            }
            if (explicitMigration == null) {
                sqlBuf.append(migrationCode);
                continue;
            }
            sqlBuf.append(this.backend.sqlComment(migrationCode));
        }
        if (!sqlBuf.isEmpty() && columnMigrations != null) {
            for (ColumnMigration columnMigration : columnMigrations) {
                sqlBuf.append(columnMigration.getSql()).append('\n');
            }
        }
        if (!sqlBuf.isEmpty() && hints != null && !hints.isEmpty()) {
            StringBuilder hintsBuf = new StringBuilder();
            hintsBuf.append(this.backend.getSingleLineComment()).append(" hints for ").append(this.entity).append('\n');
            for (Pattern hint : hints) {
                hintsBuf.append(this.backend.getSingleLineComment()).append(' ').append(hint).append('\n');
            }
            sqlBuf.insert(0, hintsBuf);
        }
        return new ColumnsResult(sqlBuf.toString(), warnBuf.toString());
    }

    private Pattern sqlMatchesHint(String sql, Collection<Pattern> hints) {
        Pattern matchingHint = null;
        if (hints != null) {
            for (Pattern hint : hints) {
                if (!hint.matcher(sql).matches()) continue;
                matchingHint = hint;
                break;
            }
        }
        return matchingHint;
    }

    private IndexMigrator.Result migrateIndexes() {
        boolean found;
        IndexMigrator.Result result = new IndexMigrator.Result("", "");
        Collection existingIndexes = this.table.getIndexes();
        List<Index> tableIndexes = this.entity.getTableIndexes();
        ArrayList<IndexMetaData> renamedIndexes = new ArrayList<IndexMetaData>();
        for (Index index : tableIndexes) {
            found = false;
            for (IndexMetaData existingIndex : existingIndexes) {
                String existingName;
                String indexName = index.createDatabaseIndexName(this.entity);
                if (existingIndex.getIndexName().equalsIgnoreCase(indexName)) {
                    result = result.sum(new IndexMigrator(this.entity, index, this.backend, existingIndex).migrate());
                    found = true;
                    break;
                }
                if (IndexMigrator.isLogicallyDifferent(this.backend, index, existingIndex, null)) continue;
                int count = 0;
                for (IndexMetaData exNdx : existingIndexes) {
                    if (IndexMigrator.isLogicallyDifferent(this.backend, index, exNdx, null)) continue;
                    ++count;
                }
                if (count != true) continue;
                String string = existingName = this.entity.getSchemaName() == null || Model.getInstance().isSchemaNameMapped() ? existingIndex.getIndexName() : this.entity.getSchemaName() + "." + existingIndex.getIndexName();
                String sql = this.backend.sqlRenameIndex(this.entity.getTableName(), existingName, indexName);
                if (sql == null) continue;
                result = result.sum(new IndexMigrator.Result(sql, ""));
                found = true;
                renamedIndexes.add(existingIndex);
                break;
            }
            if (found) continue;
            result = result.sum(new IndexMigrator(this.entity, index, this.backend, null).migrate());
        }
        for (IndexMetaData existingIndex : existingIndexes) {
            if (existingIndex.isPrimaryIdKey() || renamedIndexes.contains(existingIndex)) continue;
            found = false;
            for (Index index : tableIndexes) {
                if (!index.createDatabaseIndexName(this.entity).equalsIgnoreCase(existingIndex.getIndexName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = result.sum(new IndexMigrator(this.entity, null, this.backend, existingIndex).migrate());
        }
        return result;
    }

    private String migrateForeignKeysToAdd() throws ModelException {
        StringBuilder buf = new StringBuilder();
        for (ForeignKey foreignKey : this.foreignKeys) {
            boolean found = false;
            for (ForeignKeyMetaData existingForeignKey : this.table.getForeignKeys()) {
                if (!this.foreignKeysMatch(foreignKey, existingForeignKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            buf.append(new ForeignKeyMigrator(this.backend, foreignKey, null).migrate());
        }
        return buf.toString();
    }

    private String migrateForeignKeysToDrop() throws ModelException {
        StringBuilder buf = new StringBuilder();
        for (ForeignKeyMetaData existingForeignKey : this.table.getForeignKeys()) {
            boolean found = false;
            for (ForeignKey foreignKey : this.foreignKeys) {
                if (!this.foreignKeysMatch(foreignKey, existingForeignKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            buf.append(new ForeignKeyMigrator(this.backend, null, existingForeignKey).migrate());
        }
        return buf.toString();
    }

    private boolean foreignKeysMatch(ForeignKey foreignKey, ForeignKeyMetaData existingForeignKey) {
        Entity referencingTableProvidingEntity = foreignKey.getReferencingTableProvidingEntity();
        Entity referencedTableProvidingEntity = foreignKey.getReferencedTableProvidingEntity();
        boolean mapSchemas = Model.getInstance().isSchemaNameMapped();
        return !(existingForeignKey.getForeignKeyColumns().size() != 1 || existingForeignKey.getDeleteRule() == ForeignKeyAction.CASCADE != foreignKey.isComposite() || !foreignKey.getReferencingAttribute().getColumnName().equalsIgnoreCase(((ForeignKeyColumnMetaData)existingForeignKey.getForeignKeyColumns().get(0)).getForeignKeyColumn()) || !mapSchemas && !StringHelper.equalsIgnoreCase((String)referencingTableProvidingEntity.getSchemaName(), (String)existingForeignKey.getForeignKeySchema()) || !referencingTableProvidingEntity.getTableNameWithoutSchema().equalsIgnoreCase(existingForeignKey.getForeignKeyTable()) || !foreignKey.getReferencedAttribute().getColumnName().equalsIgnoreCase(((ForeignKeyColumnMetaData)existingForeignKey.getForeignKeyColumns().get(0)).getPrimaryKeyColumn()) || !mapSchemas && !StringHelper.equalsIgnoreCase((String)referencedTableProvidingEntity.getSchemaName(), (String)existingForeignKey.getPrimaryKeySchema()) || !referencedTableProvidingEntity.getTableNameWithoutSchema().equalsIgnoreCase(existingForeignKey.getPrimaryKeyTable()));
    }

    private record ColumnsResult(String tableSql, String warningSql) {
    }

    public record Result(Collection<Pattern> hints, Collection<ColumnMigration> columnMigrations, Map<String, String> renameColumns, String tableSql, String foreignKeySql, String warningSql) {
    }
}

