/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parse;

import org.tentackle.model.parse.AttributeLine;
import org.tentackle.model.parse.CommentLine;
import org.tentackle.model.parse.ConfigurationLine;
import org.tentackle.model.parse.Document;
import org.tentackle.model.parse.EmptyLine;
import org.tentackle.model.parse.GlobalOptionLine;
import org.tentackle.model.parse.Line;
import org.tentackle.model.parse.OptionLine;
import org.tentackle.model.parse.RelationLine;

public enum LineType {
    EMPTY,
    COMMENT,
    CONFIGURATION,
    GLOBAL_OPTION,
    ATTRIBUTE,
    ATTRIBUTE_OPTION,
    RELATION,
    RELATION_OPTION;


    public Line createLine(Document document, int offset) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY -> new EmptyLine(document, offset, this);
            case COMMENT -> new CommentLine(document, offset, this);
            case CONFIGURATION -> new ConfigurationLine(document, offset, this);
            case GLOBAL_OPTION -> new GlobalOptionLine(document, offset, this);
            case ATTRIBUTE_OPTION, RELATION_OPTION -> new OptionLine(document, offset, this);
            case ATTRIBUTE -> new AttributeLine(document, offset, this);
            case RELATION -> new RelationLine(document, offset, this);
        };
    }
}

