/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.CustomModelValidator;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelError;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.ForeignKeyImpl;
import org.tentackle.model.impl.IndexImpl;
import org.tentackle.model.impl.ModelDirectory;
import org.tentackle.model.impl.ModelDirectoryImpl;
import org.tentackle.model.impl.ModelEntity;
import org.tentackle.model.impl.ModelEntityImpl;
import org.tentackle.model.impl.RelationImpl;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlNameType;

@Service(value=Model.class)
public class ModelImpl
implements Model {
    private final Map<String, ModelEntity> mapByFilePath;
    private final Map<String, String> mapJavaFilePath;
    private final Map<String, ModelEntity> mapByEntityName;
    private final Map<String, ModelEntity> mapByTableName;
    private final Map<Integer, ModelEntity> mapByClassId;
    private final Map<String, ModelDirectory> modelDirs;
    private final EntityFactory entityFactory = this.createEntityFactory();
    private final Collection<CustomModelValidator> customModelValidators;
    private Collection<ForeignKey> foreignKeys;
    private boolean mapSchemas;

    public ModelImpl() {
        this.mapByEntityName = new TreeMap<String, ModelEntity>();
        this.mapByTableName = new HashMap<String, ModelEntity>();
        this.mapByClassId = new HashMap<Integer, ModelEntity>();
        this.mapByFilePath = new HashMap<String, ModelEntity>();
        this.mapJavaFilePath = new HashMap<String, String>();
        this.modelDirs = new HashMap<String, ModelDirectory>();
        this.customModelValidators = CustomModelValidator.loadValidators();
    }

    @Override
    public void setSchemaNameMapped(boolean mapSchemas) {
        this.mapSchemas = mapSchemas;
    }

    @Override
    public boolean isSchemaNameMapped() {
        return this.mapSchemas;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public synchronized void loadModel(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        ModelDirectory dir = this.modelDirs.get(modelDir);
        if (dir == null || dir.hasChanged()) {
            dir = this.createModelDirectory(modelDir, defaults, aliases);
            this.modelDirs.put(modelDir, dir);
            for (String string : dir.getFilePaths()) {
                this.loadByFilePath(string, defaults, aliases, false);
            }
            this.updateRelations(defaults, aliases);
        }
        if (defaults != null) {
            Entity entity;
            boolean updateRelations = false;
            if (defaults.getTrackType() != null) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults() || defaults.getTrackType().ordinal() <= entity.getOptions().getTrackType().ordinal()) continue;
                    ((EntityImpl)entity).getOptions().setTrackType(defaults.getTrackType());
                    updateRelations = true;
                }
            }
            if (defaults.getDeletionCascaded() != null && defaults.getDeletionCascaded().booleanValue()) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults()) continue;
                    for (Relation relation : entity.getRelations()) {
                        if (!relation.isComposite() || relation.isDeletionCascaded()) continue;
                        ((RelationImpl)relation).setDeletionCascaded(defaults.getDeletionCascaded());
                        updateRelations = true;
                    }
                }
            }
            if (updateRelations) {
                this.updateRelations(defaults, aliases);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            EntityImpl entity = (EntityImpl)modelEntity.getEntity();
            for (Index idx : entity.getIndexes()) {
                IndexImpl index = (IndexImpl)idx;
                if (index.isParsed()) continue;
                index.parse(entity);
            }
            entity.validate();
        }
        for (CustomModelValidator customModelValidator : this.customModelValidators) {
            customModelValidator.validate(this);
        }
    }

    @Override
    public synchronized void clearModel() {
        this.mapByEntityName.clear();
        this.mapByTableName.clear();
        this.mapByClassId.clear();
        this.mapByFilePath.clear();
        this.mapJavaFilePath.clear();
        this.modelDirs.clear();
    }

    @Override
    public void refreshModel() throws ModelException {
        for (ModelDirectory modelDir : this.modelDirs.values()) {
            modelDir.markDirty();
            this.loadModel(modelDir.getPath(), modelDir.getModelDefaults(), modelDir.getEntityAliases());
        }
    }

    @Override
    public synchronized Collection<Entity> getAllEntitites() throws ModelException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        boolean refreshed = false;
        block0: do {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                if (modelEntity.hasChanged()) {
                    this.refreshModel();
                    list.clear();
                    refreshed = true;
                    continue block0;
                }
                list.add(modelEntity.getEntity());
            }
        } while (refreshed);
        return list;
    }

    @Override
    public synchronized Entity getByFilePath(String filePath) throws ModelException {
        ModelEntity modelEntity = this.mapByFilePath.get(filePath);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByFilePath.get(filePath);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByEntityName(String entityName) throws ModelException {
        String name = entityName.toLowerCase();
        ModelEntity modelEntity = this.mapByEntityName.get(name);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByEntityName.get(name);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByTableName(String tableName) throws ModelException {
        ModelEntity modelEntity;
        int ndx = (tableName = tableName.toLowerCase()).indexOf(46);
        if (ndx >= 0) {
            tableName = tableName.substring(ndx + 1);
        }
        if ((modelEntity = this.mapByTableName.get(tableName)) != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByTableName.get(tableName);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByClassId(int classId) throws ModelException {
        ModelEntity modelEntity = this.mapByClassId.get(classId);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByClassId.get(classId);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public Entity loadByFilePath(String filePath, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        return this.loadByFilePath(filePath, defaults, aliases, true);
    }

    protected synchronized Entity loadByFilePath(String filePath, ModelDefaults defaults, EntityAliases aliases, boolean updateRelations) throws ModelException {
        ModelEntity modelEntity = this.mapByFilePath.get(filePath);
        if (modelEntity != null && modelEntity.hasChanged()) {
            modelEntity = null;
        }
        if (modelEntity == null) {
            try {
                Entity entity = this.parseEntity(defaults, filePath);
                modelEntity = this.createModelEntity(entity, filePath);
            }
            catch (ModelException mex) {
                String msg = "parsing '" + filePath + "' failed:\n    " + ExceptionHelper.concatenateMessages((Throwable)mex);
                throw new ModelException(msg, mex.getElement(), mex);
            }
            this.addModelEntity(modelEntity);
            this.foreignKeys = null;
            if (updateRelations) {
                this.updateRelations(defaults, aliases, modelEntity);
            }
        }
        return modelEntity.getEntity();
    }

    protected Entity parseEntity(ModelDefaults defaults, String fileName) throws ModelException {
        StringBuilder modelSource = new StringBuilder();
        try (Reader reader = this.createReader(fileName);){
            int len;
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                modelSource.append(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new ModelException("reading model '" + fileName + "' failed", ex);
        }
        return this.getEntityFactory().createEntity(modelSource.toString(), defaults);
    }

    protected void addModelEntity(ModelEntity modelEntity) throws ModelException {
        String tableName;
        String tableName2;
        if (this.mapSchemas && (tableName2 = modelEntity.getEntity().getTableName()) != null) {
            ((EntityImpl)modelEntity.getEntity()).setTableName(tableName2.replace('.', '_'));
        }
        String filePath = modelEntity.getFilePath();
        this.mapByFilePath.put(filePath, modelEntity);
        String javaPath = modelEntity.getEntity().getSourceInfo().getFileName();
        String oldFilePath = this.mapJavaFilePath.put(javaPath, filePath);
        if (oldFilePath != null && !oldFilePath.equals(filePath)) {
            throw new ModelException("entity " + modelEntity.getEntity() + " defined from more than one model file:\n" + oldFilePath + "\n" + filePath);
        }
        ModelEntity oldModelEntity = this.mapByEntityName.put(modelEntity.getEntity().getName().toLowerCase(), modelEntity);
        if (modelEntity.getEntity().getClassId() != 0) {
            if (oldModelEntity != null && oldModelEntity.getEntity().getClassId() != modelEntity.getEntity().getClassId()) {
                throw new ModelException("duplicate entity " + modelEntity.getEntity().getName() + " in file " + filePath, modelEntity.getEntity());
            }
            oldModelEntity = this.mapByClassId.put(modelEntity.getEntity().getClassId(), modelEntity);
            if (oldModelEntity != null && !oldModelEntity.getEntity().getName().equals(modelEntity.getEntity().getName())) {
                throw new ModelException("duplicate entity id " + modelEntity.getEntity().getClassId() + " for " + modelEntity.getEntity().getName() + ", already assigned to " + oldModelEntity.getEntity().getName(), modelEntity.getEntity());
            }
        }
        if ((tableName = modelEntity.getEntity().getTableNameWithoutSchema()) != null && (oldModelEntity = this.mapByTableName.put(tableName, modelEntity)) != null && !oldModelEntity.getEntity().getName().equals(modelEntity.getEntity().getName())) {
            throw new ModelException("duplicate table name '" + modelEntity.getEntity().getTableNameWithoutSchema() + "' for " + modelEntity.getEntity().getName() + ", already assigned to " + oldModelEntity.getEntity().getName(), modelEntity.getEntity());
        }
    }

    protected void updateRelations(ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        this.updateRelations(defaults, aliases, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateRelations(ModelDefaults defaults, EntityAliases aliases, ModelEntity loadedModelEntity) throws ModelException {
        Entity entity;
        LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
        Entity loadedEntity = loadedModelEntity == null ? null : loadedModelEntity.getEntity();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            modelEntity.getEntity().getSubEntities().clear();
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntityName() == null) continue;
            Entity superEntity = this.getByEntityName(this.translateAlias(aliases, entity.getSuperEntityName()));
            if (superEntity == null) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, "no such super entity '" + entity.getSuperEntityName() + "' to be extended by '" + entity + "'"));
                continue;
            }
            ((EntityImpl)entity).setSuperEntity(superEntity);
            if (superEntity.getInheritanceType() == InheritanceType.NONE && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                errors.add(new ModelError(entity, "super entity '" + superEntity + "' extended by '" + entity + "' is not extensible (missing inheritance := ... ?)"));
            }
            superEntity.getSubEntities().add(entity);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            void var10_60;
            entity = modelEntity.getEntity();
            boolean normTextProvided = entity.getOptions().isNormTextProvided();
            if (normTextProvided) continue;
            for (Attribute attribute : entity.getAttributes()) {
                if (!attribute.getOptions().isPartOfNormText()) continue;
                normTextProvided = true;
                break;
            }
            if (!normTextProvided) {
                for (Relation relation : entity.getRelations()) {
                    if (!relation.isPartOfNormText()) continue;
                    normTextProvided = true;
                    break;
                }
            }
            if (!normTextProvided) continue;
            Entity entity2 = entity.getSuperEntity();
            while (var10_60 != null) {
                entity = var10_60;
                if (var10_60.getOptions().isNormTextProvided()) {
                    normTextProvided = false;
                    break;
                }
                Entity entity3 = var10_60.getSuperEntity();
            }
            if (!normTextProvided) continue;
            ((EntityOptionsImpl)entity.getOptions()).setNormTextProvided(true);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            entity.getReferencingRelations().clear();
            entity.getCompositePaths().clear();
            entity.getDeepReferences().clear();
            entity.getDeepReferencesToComponents().clear();
            ((EntityImpl)entity).setDeeplyReferenced(false);
            for (Relation relation : entity.getRelations()) {
                void var13_117;
                ((RelationImpl)relation).setForeignRelation(null);
                Entity entity4 = this.getByEntityName(this.translateAlias(aliases, relation.getClassName()));
                if (entity4 == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such entity: " + relation.getClassName()));
                    continue;
                }
                if (entity.getOptions().isProvided() && !entity4.getOptions().isProvided()) {
                    errors.add(new ModelError(relation, "provided entities cannot have relations to managed entities"));
                }
                ((RelationImpl)relation).setForeignEntity(entity4);
                if (relation.getRelationType() != RelationType.LIST) continue;
                Object attributeName = relation.getMethodName() != null ? relation.getMethodName() : relation.getEntity().getName() + "Id";
                Attribute attribute = entity4.getAttributeByJavaName((String)(attributeName = StringHelper.firstToLower((String)attributeName)), true);
                if (attribute == null) {
                    for (Relation fRel : entity4.getRelations()) {
                        if (fRel.getRelationType() != RelationType.OBJECT || !relation.getEntity().getName().equals(fRel.getClassName())) continue;
                        attributeName = StringHelper.firstToLower((String)(fRel.getName() + "Id"));
                        Attribute attribute2 = entity4.getAttributeByJavaName((String)attributeName, true);
                        break;
                    }
                    if (var13_117 == null && relation.getMethodArgs().isEmpty() && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                        errors.add(new ModelError(relation, "no such attribute: " + (String)attributeName + " in " + entity4 + " referenced by " + entity));
                    }
                }
                ((RelationImpl)relation).setForeignAttribute((Attribute)var13_117);
                if (relation.getNmName() == null) continue;
                Relation nmRelation = entity4.getRelation(relation.getNmName(), false);
                if (nmRelation == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    errors.add(new ModelError(relation, "no such nm-relation: " + relation.getNmName() + " in " + entity4));
                    continue;
                }
                if ((nmRelation.isComposite() || nmRelation.getRelationType() == RelationType.LIST) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity4 + " must be non-composite object"));
                }
                if (this.translateAlias(aliases, nmRelation.getClassName()).equals(entity.getName()) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    errors.add(new ModelError(nmRelation, "nm-relation " + nmRelation.getName() + " in " + entity4 + " points back to " + entity));
                }
                if (nmRelation.getSelectionType() == SelectionType.LAZY && !nmRelation.isSerialized()) {
                    ((RelationImpl)nmRelation).setSerialized(true);
                    ((RelationImpl)nmRelation).setClearOnRemoteSave(true);
                }
                ((RelationImpl)relation).setNmRelation(nmRelation);
                ((RelationImpl)nmRelation).setDefiningNmRelation(relation);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            for (ModelEntity modelEntity2 : this.mapByEntityName.values()) {
                Entity entity5 = modelEntity2.getEntity();
                for (Relation relation : entity5.getRelations()) {
                    Entity foreignEntity = relation.getForeignEntity();
                    if (foreignEntity == null || !foreignEntity.equals(entity)) continue;
                    entity.getReferencingRelations().add(relation);
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            block15: for (Relation relation : entity.getReferencingRelations()) {
                if (relation.getForeignRelation() != null) continue;
                for (Relation otherRelation : relation.getForeignEntity().getTableRelations()) {
                    if (!Objects.equals(relation.getEntity(), otherRelation.getForeignEntity()) || !Objects.equals(relation.getAttribute(), otherRelation.getForeignAttribute())) continue;
                    ((RelationImpl)relation).setForeignRelation(otherRelation);
                    ((RelationImpl)otherRelation).setForeignRelation(relation);
                    continue block15;
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            boolean isRootEntity = true;
            for (Relation relation : entity.getAllReferencingRelations()) {
                if (!relation.isComposite() || entity.equals(relation.getEntity())) continue;
                isRootEntity = false;
                break;
            }
            ((EntityImpl)entity).setRootEntityAccordingToModel(isRootEntity);
            if (!isRootEntity) continue;
            for (Relation relation : entity.getAllRelations()) {
                if (!relation.isComposite() || relation.getForeignEntity() == null) continue;
                Iterator<Entity> compositePath = new ArrayList<Relation>();
                compositePath.add((Entity)((Object)relation));
                this.updateCompositePath((List<Relation>)((Object)compositePath), relation.getForeignEntity());
            }
        }
        block20: for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            Set<Entity> rootEntities = entity.getRootEntities();
            if (rootEntities.size() > 1 && entity.getRootAttribute() != null) {
                ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
            }
            if (!rootEntities.isEmpty()) {
                for (Relation relation : entity.getReferencingRelationsIncludingSubEntities()) {
                    if (relation.isComposite() || relation.getForeignRelation() != null && relation.getForeignRelation().isComposite() || rootEntities.containsAll(relation.getEntity().getRootEntities())) continue;
                    ((RelationImpl)relation).setDeepReference(true);
                    ((EntityImpl)entity).setDeeplyReferenced(true);
                    entity.getDeepReferences().add(relation);
                    for (List list : entity.getCompositePaths()) {
                        for (Relation compositeRelation : list) {
                            ((EntityImpl)compositeRelation.getEntity()).setDeeplyReferenced(true);
                        }
                    }
                    for (Entity entity6 : rootEntities) {
                        entity6.getDeepReferencesToComponents().add(relation);
                    }
                    if (entity.getRootEntity() != null) continue;
                    ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
                }
            }
            for (List<Relation> list : entity.getCompositePaths()) {
                if (list.size() <= 1 && list.get(list.size() - 1).getRelationType() != RelationType.OBJECT) continue;
                ((EntityImpl)entity).setProvidingRootIdAccordingToModel(true);
                continue block20;
            }
        }
        if (defaults != null) {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                entity = modelEntity.getEntity();
                if (entity.getOptions().noModelDefaults()) continue;
                if (defaults.getTrackType() != null && defaults.getTrackType().ordinal() > entity.getOptions().getTrackType().ordinal()) {
                    ((EntityOptionsImpl)entity.getOptions()).setTrackType(defaults.getTrackType());
                }
                if (Boolean.TRUE.equals(defaults.getRoot()) && entity.isRootEntityAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootEntity(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootClassId()) && entity.isProvidingRootClassIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootClassIdProvided(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootId()) && entity.isProvidingRootIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootIdProvided(true);
                }
                if (defaults.getRemote() == null) continue;
                ((EntityOptionsImpl)entity.getOptions()).setRemote(defaults.getRemote());
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getOptions().isRootClassIdProvided()) {
                if (entity.getAttributeByColumnName("rootclassid", true) == null) {
                    ((EntityImpl)entity).getOptions().applyOption("ROOTCLASSID", Boolean.TRUE);
                }
            } else {
                Attribute rootClassAttribute = entity.getAttributeByColumnName("rootclassid", false);
                if (rootClassAttribute != null) {
                    entity.getAttributes().remove(rootClassAttribute);
                }
            }
            if (entity.getOptions().isRootIdProvided()) {
                if (entity.getAttributeByColumnName("rootid", true) != null) continue;
                ((EntityImpl)entity).getOptions().applyOption("ROOTID", Boolean.TRUE);
                continue;
            }
            Attribute rootAttribute = entity.getAttributeByColumnName("rootid", false);
            if (rootAttribute == null) continue;
            entity.getAttributes().remove(rootAttribute);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getOptions().isCached() && !entity.isRootEntityAccordingToModel()) {
                errors.add(new ModelError(entity, "component " + entity + " cannot be cached"));
            }
            for (Relation relation : entity.getRelations()) {
                if (relation.getEntity().getOptions().getTrackType().isTracked()) {
                    ((RelationImpl)relation).setTracked(true);
                }
                if (relation.getForeignEntity() == null) continue;
                if (relation.isComposite()) {
                    if (relation.getRelationType() == RelationType.LIST) {
                        void var11_105;
                        Iterator parentRelations;
                        Relation relation2 = relation.getForeignEntity().getRelation(entity.getName(), true);
                        if (relation2 == null && (parentRelations = relation.getForeignEntity().getRelations(entity, true)).size() == 1) {
                            Relation relation3 = (Relation)parentRelations.get(0);
                        }
                        if (var11_105 != null && var11_105.getRelationType() == RelationType.OBJECT && var11_105.getSelectionType() == SelectionType.LAZY) {
                            if (relation.getLinkMethodName() == null || "set".equals(relation.getLinkMethodName())) {
                                ((RelationImpl)relation).setLinkMethodName("set" + StringHelper.firstToUpper((String)var11_105.getName()));
                            }
                            if (var11_105.getEntity().getOptions().isRemote()) {
                                ((RelationImpl)var11_105).setSerialized(true);
                            }
                        }
                    }
                    if (relation.getLinkMethodName() != null) {
                        ((RelationImpl)relation).setReferenced(true);
                    }
                    if (relation.isTracked() || !entity.getIntegrity().isCompositesCheckedByDatabase()) continue;
                    errors.add(new ModelError(relation, "untracked relation " + relation + " not allowed in conjunction with " + entity.getIntegrity() + "-integrity in " + entity));
                    continue;
                }
                if (relation.getRelationType() != RelationType.OBJECT || !relation.getForeignEntity().getOptions().isCached() || relation.isSerialized() || !((RelationImpl)relation).isSelectionTypeDetermined()) continue;
                ((RelationImpl)relation).setSelectionType(SelectionType.ALWAYS);
                ((RelationImpl)relation).setSelectionCached(true);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            try {
                ((EntityImpl)entity).validateRelated();
            }
            catch (ModelException mex) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                errors.add(new ModelError(entity, mex.getMessage() + " in " + entity));
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntity() != null || entity.getInheritanceType().isMappingToNoTable()) continue;
            HashMap<String, AttributeImpl> columnMap = new HashMap<String, AttributeImpl>();
            HashMap<String, AttributeImpl> hashMap = new HashMap<String, AttributeImpl>();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(entity.getAttributes());
            for (Entity entity7 : entity.getAllSubEntities()) {
                arrayList.addAll(entity7.getAttributes());
            }
            for (Attribute attribute : arrayList) {
                AttributeImpl attribute3 = (AttributeImpl)attribute;
                AttributeImpl oldAttribute = hashMap.put(attribute3.getName().toLowerCase(), attribute3);
                if (oldAttribute != null && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    StringBuilder exMsg = new StringBuilder();
                    exMsg.append("attribute '").append(attribute3.getName()).append("' in ").append(attribute3.getEntity());
                    exMsg.append(" already defined in ").append(oldAttribute.getEntity());
                    if (oldAttribute.getSourceLine() != null) {
                        exMsg.append("(").append(oldAttribute.getSourceLine()).append(")");
                    }
                    errors.add(new ModelError(attribute3, exMsg.toString()));
                }
                AttributeImpl oldColumn = columnMap.put(attribute3.getColumnName().toLowerCase(), attribute3);
                if (oldAttribute != null || oldColumn == null || loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                StringBuilder exMsg = new StringBuilder();
                exMsg.append("column '").append(attribute3.getColumnName()).append("' in ").append(attribute3.getEntity());
                exMsg.append(" already defined in ").append(oldColumn.getEntity());
                if (oldColumn.getSourceLine() != null) {
                    exMsg.append("(").append(oldColumn.getSourceLine()).append(")");
                }
                exMsg.append(" as attribute '").append(attribute3).append("'");
                errors.add(new ModelError(attribute3, exMsg.toString()));
            }
        }
        HashMap<String, Entity> aliasMap = new HashMap<String, Entity>();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            Entity entity2 = modelEntity.getEntity();
            if (entity2.getTableAlias() == null) continue;
            Entity entity8 = (Entity)aliasMap.get(entity2.getTableAlias());
            if (entity8 != null) {
                errors.add(new ModelError(entity8, "table alias '" + entity2.getTableAlias() + "' defined more than once in " + entity2 + " and " + entity8));
                continue;
            }
            aliasMap.put(entity2.getTableAlias(), entity2);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            int n;
            Entity entity3 = modelEntity.getEntity();
            if (entity3.getTableName() == null || entity3.getTableAlias() != null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            char c = '_';
            boolean lastCharAppended = false;
            for (n = 0; n < entity3.getName().length(); ++n) {
                char currentChar = entity3.getName().charAt(n);
                if (Character.isUpperCase(currentChar) || Character.isDigit(currentChar)) {
                    stringBuilder.append(currentChar);
                }
                c = currentChar;
            }
            if (stringBuilder.length() <= 1) {
                stringBuilder.append(c);
                lastCharAppended = true;
            }
            if (this.applyTableAlias(aliasMap, entity3, stringBuilder.toString().toLowerCase())) continue;
            if (!lastCharAppended) {
                stringBuilder.append(c);
                if (this.applyTableAlias(aliasMap, entity3, stringBuilder.toString().toLowerCase())) continue;
            }
            stringBuilder.setLength(1);
            n = 0;
            for (int i = 1; i < entity3.getName().length() && i < 6; ++i) {
                char c2 = Character.toLowerCase(entity3.getName().charAt(i));
                if (c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u') continue;
                stringBuilder.append(c2);
                if (stringBuilder.length() < 3 || !this.applyTableAlias(aliasMap, entity3, stringBuilder.toString().toLowerCase())) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            String aliasPrefix = entity3.getName().substring(0, 1).toLowerCase();
            int count = 1;
            while (!this.applyTableAlias(aliasMap, entity3, aliasPrefix + count)) {
                ++count;
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            void var10_85;
            void var11_110;
            Entity entity4 = modelEntity.getEntity();
            boolean bl = false;
            Entity entity9 = entity4.getSuperEntity();
            while (var11_110 != null) {
                ++var10_85;
                Entity entity10 = var11_110.getSuperEntity();
            }
            ((EntityImpl)entity4).setOrdinal((int)var10_85);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            int n;
            Entity entity5 = modelEntity.getEntity();
            if (entity5.isAbstract()) continue;
            Entity[] entityArray = new Entity[modelEntity.getEntity().getOrdinal() + 1];
            List<Entity> list = entity5.getSuperEntities();
            int superNdx = list.size() - 1;
            for (n = 0; n < entityArray.length; ++n) {
                entityArray[n] = n < list.size() ? list.get(superNdx--) : entity5;
            }
            n = 0;
            int relationOrdinal = 0;
            int indexOrdinal = 0;
            for (Entity nextEntity : entityArray) {
                for (Attribute attribute : nextEntity.getAttributes()) {
                    ((AttributeImpl)attribute).setOrdinal(n++);
                }
                for (Relation relation : nextEntity.getRelations()) {
                    ((RelationImpl)relation).setOrdinal(relationOrdinal++);
                }
                for (Index index : nextEntity.getIndexes()) {
                    ((IndexImpl)index).setOrdinal(indexOrdinal++);
                }
            }
        }
        if (loadedEntity != null) {
            Entity entity11 = loadedEntity.getTopSuperEntity();
            this.validateInheritanceHierarchy(entity11, entity11.getInheritanceType(), entity11.getOptions().getTrackType(), entity11.getIntegrity(), errors);
            this.validateComponents(entity11, entity11.getIntegrity(), errors);
        } else {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity6 = modelEntity.getEntity();
                this.validateInheritanceHierarchy(entity6, entity6.getInheritanceType(), entity6.getOptions().getTrackType(), entity6.getIntegrity(), errors);
                this.validateComponents(entity6, entity6.getIntegrity(), errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new ModelException(errors);
        }
    }

    protected boolean applyTableAlias(Map<String, Entity> aliasMap, Entity entity, String alias) {
        if (aliasMap.get(alias) == null && this.isValidTableAlias(alias)) {
            ((EntityImpl)entity).setTableAlias(alias);
            aliasMap.put(alias, entity);
            return true;
        }
        return false;
    }

    protected boolean isValidTableAlias(String alias) {
        boolean valid = true;
        for (Backend backend : this.getEntityFactory().getBackends()) {
            try {
                backend.assertValidName(SqlNameType.TABLE_ALIAS, alias);
            }
            catch (RuntimeException rex) {
                valid = false;
                break;
            }
        }
        return valid;
    }

    protected void updateCompositePath(List<Relation> compositePath, Entity entity) {
        Relation lastRelation = compositePath.get(compositePath.size() - 1);
        if (lastRelation.getForeignAttribute() != null) {
            entity = lastRelation.getForeignAttribute().getEntity();
        }
        entity.getCompositePaths().add(compositePath);
        for (Relation relation : entity.getAllRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            ArrayList<Relation> newPath = new ArrayList<Relation>(compositePath);
            newPath.add(relation);
            this.updateCompositePath(newPath, foreignEntity);
        }
    }

    @Override
    public synchronized Collection<ForeignKey> getForeignKeys() throws ModelException {
        if (this.foreignKeys == null) {
            TreeMap<ForeignKeyImpl, ForeignKeyImpl> foreignKeyMap = new TreeMap<ForeignKeyImpl, ForeignKeyImpl>();
            LinkedHashSet<ModelError> errors = new LinkedHashSet<ModelError>();
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity = modelEntity.getEntity();
                if (!entity.getInheritanceType().isMappingToOwnTable()) continue;
                for (Relation relation : entity.getTableRelations()) {
                    List<Object> referencingEntities;
                    Relation foreignRelation;
                    Attribute referencingAttribute = null;
                    Entity referencingEntity = null;
                    Attribute referencedAttribute = null;
                    Entity referencedEntity = null;
                    boolean composite = relation.isComposite();
                    if (!composite && (foreignRelation = relation.getForeignRelation()) != null && foreignRelation.getRelationType() == RelationType.LIST && foreignRelation.isComposite()) {
                        composite = true;
                    }
                    if (relation.getAttribute() != null) {
                        if (relation.getForeignEntity() == null) {
                            errors.add(new ModelError(relation, "no foreign entity for " + relation));
                        } else {
                            referencingEntity = relation.getEntity();
                            referencingAttribute = relation.getAttribute();
                            referencedEntity = relation.getForeignEntity();
                            referencedAttribute = referencedEntity.getAttributeByJavaName("id", true);
                        }
                    } else if (relation.getForeignAttribute() != null) {
                        referencingEntity = relation.getForeignEntity();
                        referencingAttribute = relation.getForeignAttribute();
                        referencedEntity = entity;
                        referencedAttribute = entity.getAttributeByJavaName("id", true);
                    } else {
                        if (!relation.getMethodArgs().isEmpty()) continue;
                        errors.add(new ModelError(relation, "broken foreign key relation " + relation + " in " + entity));
                    }
                    if (referencingEntity != null && referencingEntity.getTableProvidingEntity() == null) {
                        referencingEntities = referencingEntity.getLeafEntities();
                    } else {
                        referencingEntities = new ArrayList();
                        if (referencedEntity != null) {
                            referencingEntities.add(referencingEntity);
                        }
                    }
                    for (Entity entity2 : referencingEntities) {
                        if (entity2.getOptions().isProvided() || referencingAttribute == null || referencedAttribute == null || (composite || !referencedAttribute.getEntity().getIntegrity().isRelatedCheckedByDatabase()) && (!composite || !referencedAttribute.getEntity().getIntegrity().isCompositesCheckedByDatabase())) continue;
                        ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity2, referencingAttribute, referencedEntity, referencedAttribute, composite);
                        ForeignKey oppositeForeignKey = (ForeignKey)foreignKeyMap.get(foreignKey);
                        if (oppositeForeignKey != null) {
                            if (!composite || oppositeForeignKey.isComposite()) continue;
                            ((ForeignKeyImpl)oppositeForeignKey).setComposite(true);
                            continue;
                        }
                        foreignKeyMap.put(foreignKey, foreignKey);
                    }
                }
                if (entity.getOptions().isProvided() || entity.getSuperEntity() == null || !entity.getHierarchyInheritanceType().isMappingToOwnTable()) continue;
                Entity topEntity = entity.getTopSuperEntity();
                Attribute idAttribute = topEntity.getAttributeByJavaName("id", false);
                ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity, idAttribute, topEntity, idAttribute, false);
                foreignKeyMap.put(foreignKey, foreignKey);
            }
            if (!errors.isEmpty()) {
                throw new ModelException(errors);
            }
            this.foreignKeys = foreignKeyMap.values();
        }
        return this.foreignKeys;
    }

    protected EntityFactory createEntityFactory() {
        return new EntityFactoryImpl();
    }

    protected ModelDirectory createModelDirectory(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        return new ModelDirectoryImpl(modelDir, defaults, aliases);
    }

    protected ModelEntity createModelEntity(Entity entity, String fileName) throws ModelException {
        return new ModelEntityImpl(entity, fileName);
    }

    protected Reader createReader(String name) throws ModelException {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), Settings.getEncodingCharset()));
        }
        catch (IOException ex) {
            throw new ModelException("cannot open reader for " + name, ex);
        }
    }

    protected void validateInheritanceHierarchy(Entity entity, InheritanceType inheritanceType, TrackType trackType, Integrity integrity, Set<ModelError> errors) {
        if (entity.getOptions().getTrackType() != trackType) {
            errors.add(new ModelError(entity, entity + " has wrong track type " + entity.getOptions().getTrackType() + ", expected " + trackType));
        }
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        if (!entity.getSubEntities().isEmpty()) {
            if (entity.getInheritanceType() != inheritanceType) {
                errors.add(new ModelError(entity, entity + " has wrong inheritance type " + entity.getInheritanceType() + ", expected " + inheritanceType));
            }
            for (Entity child : entity.getSubEntities()) {
                this.validateInheritanceHierarchy(child, inheritanceType, trackType, integrity, errors);
            }
        }
    }

    protected void validateComponents(Entity entity, Integrity integrity, Set<ModelError> errors) {
        if (entity.getIntegrity() != integrity) {
            errors.add(new ModelError(entity, entity + " has wrong integrity type " + entity.getIntegrity() + ", expected " + integrity));
        }
        for (Relation relation : entity.getRelations()) {
            Entity foreignEntity;
            if (!relation.isComposite() || (foreignEntity = relation.getForeignEntity()) == null || foreignEntity.equals(entity)) continue;
            this.validateComponents(foreignEntity, integrity, errors);
        }
    }

    protected String translateAlias(EntityAliases aliases, String name) {
        String mappedName;
        if (aliases != null && (mappedName = (String)aliases.get(name)) != null) {
            name = mappedName;
        }
        return name;
    }
}

