/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.tentackle.common.BMoney;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.common.DMoney;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.SqlType;

public enum DataType {
    STRING("String", false, false, false, false, false, SqlType.VARCHAR),
    DATE("Date", false, true, false, true, false, SqlType.DATE),
    TIME("Time", false, true, false, true, false, SqlType.TIME),
    TIMESTAMP("Timestamp", false, true, false, true, false, SqlType.TIMESTAMP),
    BINARY("Binary", false, true, false, false, false, SqlType.LONGVARBINARY),
    BIGDECIMAL("BigDecimal", false, false, true, false, false, SqlType.DECIMAL),
    BMONEY("BMoney", false, false, true, false, false, SqlType.DOUBLE, SqlType.INTEGER),
    DMONEY("DMoney", false, false, true, false, false, SqlType.DECIMAL, SqlType.INTEGER),
    CHARACTER("Character", false, false, false, false, false, SqlType.CHAR),
    CHARACTER_PRIMITIVE("char", true, false, false, false, false, SqlType.CHAR),
    BOOLEAN("Boolean", false, false, false, false, true, SqlType.BIT),
    BOOLEAN_PRIMITIVE("boolean", true, false, false, false, true, SqlType.BIT),
    BYTE("Byte", false, false, true, false, false, SqlType.TINYINT),
    BYTE_PRIMITIVE("byte", true, false, false, false, false, SqlType.TINYINT),
    SHORT("Short", false, false, true, false, false, SqlType.SMALLINT),
    SHORT_PRIMITIVE("short", true, false, true, false, false, SqlType.SMALLINT),
    INTEGER("Integer", false, false, true, false, false, SqlType.INTEGER),
    INTEGER_PRIMITIVE("int", true, false, true, false, false, SqlType.INTEGER),
    LONG("Long", false, false, true, false, false, SqlType.BIGINT),
    LONG_PRIMITIVE("long", true, false, true, false, false, SqlType.BIGINT),
    FLOAT("Float", false, false, true, false, false, SqlType.FLOAT),
    FLOAT_PRIMITIVE("float", true, false, true, false, false, SqlType.FLOAT),
    DOUBLE("Double", false, false, true, false, false, SqlType.DOUBLE),
    DOUBLE_PRIMITIVE("double", true, false, true, false, false, SqlType.DOUBLE),
    APPLICATION("<application>", false, false, false, false, false, SqlType.JAVA_OBJECT);

    private final String javaType;
    private final boolean primitive;
    private final boolean mutable;
    private final boolean numeric;
    private final boolean dateOrTime;
    private final boolean bool;
    private final SqlType[] sqlTypes;
    private final SqlTypeWithPostfix[] sqlTypesWithPostfix;
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateFormat DATE_FORMAT;
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateFormat TIME_FORMAT;
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat TIMESTAMP_FORMAT;
    private static final String MS_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.000";
    private static final DateFormat MS_TIMESTAMP_FORMAT;

    private DataType(String javaType, boolean primitive, boolean mutable, boolean numeric, boolean dateOrTime, boolean bool, SqlType ... sqlTypes) {
        this.javaType = javaType;
        this.primitive = primitive;
        this.mutable = mutable;
        this.numeric = numeric;
        this.dateOrTime = dateOrTime;
        this.bool = bool;
        this.sqlTypes = sqlTypes;
        this.sqlTypesWithPostfix = new SqlTypeWithPostfix[sqlTypes.length];
        for (int i = 0; i < sqlTypes.length; ++i) {
            this.sqlTypesWithPostfix[i] = new SqlTypeWithPostfix(sqlTypes[i], i == 0 ? "" : "_" + (i + 1));
        }
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isDateOrTime() {
        return this.dateOrTime;
    }

    public boolean isBool() {
        return this.bool;
    }

    public SqlType[] getSqlTypes() {
        return this.sqlTypes;
    }

    public SqlTypeWithPostfix[] getSqlTypesWithPostfix() {
        return this.sqlTypesWithPostfix;
    }

    public boolean isMultiColumn() {
        return this.sqlTypes.length > 1;
    }

    public boolean isScaleInSecondColumn() {
        return this.numeric && this.sqlTypes.length == 2 && this.sqlTypes[0].isFractional() && this.sqlTypes[1].isNumeric() && !this.sqlTypes[1].isFractional();
    }

    public String toString() {
        return this.javaType;
    }

    public DataType toPrimitive() {
        switch (this) {
            case BOOLEAN: {
                return BOOLEAN_PRIMITIVE;
            }
            case CHARACTER: {
                return CHARACTER_PRIMITIVE;
            }
            case BYTE: {
                return BYTE_PRIMITIVE;
            }
            case SHORT: {
                return SHORT_PRIMITIVE;
            }
            case INTEGER: {
                return INTEGER_PRIMITIVE;
            }
            case LONG: {
                return LONG_PRIMITIVE;
            }
            case FLOAT: {
                return FLOAT_PRIMITIVE;
            }
            case DOUBLE: {
                return DOUBLE_PRIMITIVE;
            }
        }
        return null;
    }

    public DataType toNonPrimitive() {
        switch (this) {
            case BOOLEAN_PRIMITIVE: {
                return BOOLEAN;
            }
            case CHARACTER_PRIMITIVE: {
                return CHARACTER;
            }
            case BYTE_PRIMITIVE: {
                return BYTE;
            }
            case SHORT_PRIMITIVE: {
                return SHORT;
            }
            case INTEGER_PRIMITIVE: {
                return INTEGER;
            }
            case LONG_PRIMITIVE: {
                return LONG;
            }
            case FLOAT_PRIMITIVE: {
                return FLOAT;
            }
            case DOUBLE_PRIMITIVE: {
                return DOUBLE;
            }
        }
        return null;
    }

    public Object parse(String str) {
        DataType type = this;
        if (type.isPrimitive()) {
            type = this.toNonPrimitive();
        }
        try {
            switch (type) {
                case STRING: {
                    return BasicStringHelper.parseString((String)str);
                }
                case DATE: {
                    return DataType.parseDate(str);
                }
                case TIME: {
                    return DataType.parseTime(str);
                }
                case TIMESTAMP: {
                    return DataType.parseTimestamp(str);
                }
                case BIGDECIMAL: {
                    return new BigDecimal(BasicStringHelper.parseString((String)str));
                }
                case BMONEY: {
                    return new BMoney(new BigDecimal(BasicStringHelper.parseString((String)str)));
                }
                case DMONEY: {
                    return new DMoney(new BigDecimal(BasicStringHelper.parseString((String)str)));
                }
                case CHARACTER: {
                    String cstr = BasicStringHelper.parseString((String)str);
                    if (cstr.length() != 1) {
                        throw new TentackleRuntimeException("character must be of length 1: " + cstr);
                    }
                    return Character.valueOf(cstr.charAt(0));
                }
                case BOOLEAN: {
                    String bstr = BasicStringHelper.parseString((String)str);
                    switch (bstr.toLowerCase()) {
                        case "true": 
                        case "t": 
                        case "1": {
                            return Boolean.TRUE;
                        }
                        case "false": 
                        case "f": 
                        case "0": {
                            return Boolean.FALSE;
                        }
                    }
                    throw new TentackleRuntimeException("invalid boolean value: " + bstr);
                }
                case BYTE: {
                    return Byte.valueOf(BasicStringHelper.parseString((String)str));
                }
                case SHORT: {
                    return Short.valueOf(BasicStringHelper.parseString((String)str));
                }
                case INTEGER: {
                    return Integer.valueOf(BasicStringHelper.parseString((String)str));
                }
                case LONG: {
                    return Long.valueOf(BasicStringHelper.parseString((String)str));
                }
                case FLOAT: {
                    return Float.valueOf(BasicStringHelper.parseString((String)str));
                }
                case DOUBLE: {
                    return Double.valueOf(BasicStringHelper.parseString((String)str));
                }
            }
        }
        catch (ParseException ex) {
            throw new TentackleRuntimeException("parsing failed: " + str, (Throwable)ex);
        }
        throw new TentackleRuntimeException("cannot parse type " + (Object)((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseDate(String str) throws ParseException {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return new Date(DATE_FORMAT.parse(BasicStringHelper.parseString((String)str)).getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Time parseTime(String str) throws ParseException {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return new Time(TIME_FORMAT.parse(BasicStringHelper.parseString((String)str)).getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timestamp parseTimestamp(String str) throws ParseException {
        if ((str = BasicStringHelper.parseString((String)str)).length() > 3 && str.charAt(str.length() - 4) == '.') {
            DateFormat dateFormat = MS_TIMESTAMP_FORMAT;
            synchronized (dateFormat) {
                return new Timestamp(MS_TIMESTAMP_FORMAT.parse(str).getTime());
            }
        }
        DateFormat dateFormat = TIMESTAMP_FORMAT;
        synchronized (dateFormat) {
            return new Timestamp(TIMESTAMP_FORMAT.parse(str).getTime());
        }
    }

    public static DataType createFromJavaType(String javaType) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.javaType.equals(javaType)) continue;
            return dataType;
        }
        return null;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat(DATE_PATTERN);
        TIME_FORMAT = new SimpleDateFormat(TIME_PATTERN);
        TIMESTAMP_FORMAT = new SimpleDateFormat(TIMESTAMP_PATTERN);
        MS_TIMESTAMP_FORMAT = new SimpleDateFormat(MS_TIMESTAMP_PATTERN);
    }

    public static class SqlTypeWithPostfix {
        private final SqlType sqlType;
        private final String postfix;

        public SqlTypeWithPostfix(SqlType sqlType, String postfix) {
            this.sqlType = sqlType;
            this.postfix = postfix;
        }

        public SqlType getSqlType() {
            return this.sqlType;
        }

        public String getPostfix() {
            return this.postfix;
        }
    }
}

