/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.StringTokenizer;
import org.tentackle.model.TrackType;

public class ModelDefaults {
    private TrackType trackType;
    private Boolean deletionCascaded;
    private Boolean root;
    private Boolean rootId;
    private Boolean rootClassId;
    private Boolean bind;
    private Boolean size;
    private Boolean autoSelect;
    private Boolean remote;

    public ModelDefaults() {
    }

    public ModelDefaults(String str) {
        this.parse(str);
    }

    public void parse(String str) {
        this.clear();
        StringTokenizer stok = new StringTokenizer(str, " ,\t\n\r");
        while (stok.hasMoreTokens()) {
            String token;
            switch (token = stok.nextToken().toLowerCase()) {
                case "tracked": {
                    this.trackType = TrackType.TRACKED;
                    break;
                }
                case "attracked": {
                    this.trackType = TrackType.ATTRACKED;
                    break;
                }
                case "fulltracked": {
                    this.trackType = TrackType.FULLTRACKED;
                    break;
                }
                case "deletioncascaded": 
                case "cascadeddelete": 
                case "cascaded": 
                case "cascade": {
                    this.deletionCascaded = true;
                    break;
                }
                case "root": {
                    this.root = true;
                    break;
                }
                case "rootid": {
                    this.rootId = true;
                    break;
                }
                case "rootclassid": {
                    this.rootClassId = true;
                    break;
                }
                case "bind": {
                    this.bind = true;
                    break;
                }
                case "size": {
                    this.size = true;
                    break;
                }
                case "autoselect": {
                    this.autoSelect = true;
                    break;
                }
                case "remote": {
                    this.remote = true;
                }
            }
        }
    }

    public void clear() {
        this.trackType = null;
        this.deletionCascaded = null;
        this.root = null;
        this.rootId = null;
        this.rootClassId = null;
        this.bind = null;
        this.size = null;
        this.autoSelect = null;
        this.remote = null;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public Boolean getDeletionCascaded() {
        return this.deletionCascaded;
    }

    public Boolean getRoot() {
        return this.root;
    }

    public Boolean getRootId() {
        return this.rootId;
    }

    public Boolean getRootClassId() {
        return this.rootClassId;
    }

    public Boolean getBind() {
        return this.bind;
    }

    public Boolean getSize() {
        return this.size;
    }

    public Boolean getAutoSelect() {
        return this.autoSelect;
    }

    public Boolean getRemote() {
        return this.remote;
    }
}

