/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.Index;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.SortType;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.AttributeOptionsImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.IndexAttributeImpl;
import org.tentackle.model.impl.IndexImpl;
import org.tentackle.model.impl.RelationImpl;
import org.tentackle.model.parser.AttributeLine;
import org.tentackle.model.parser.CommentLine;
import org.tentackle.model.parser.ConfigurationLine;
import org.tentackle.model.parser.Document;
import org.tentackle.model.parser.GlobalOptionLine;
import org.tentackle.model.parser.Line;
import org.tentackle.model.parser.OptionLine;
import org.tentackle.model.parser.RelationLine;
import org.tentackle.sql.Backend;

public class EntityFactoryImpl
implements EntityFactory {
    private String pendingComment;
    private Collection<Backend> backends;

    @Override
    public Collection<Backend> getBackends() {
        if (this.backends == null) {
            this.backends = new ArrayList<Backend>();
        }
        return this.backends;
    }

    @Override
    public void setBackends(Collection<Backend> backends) {
        this.backends = backends;
    }

    @Override
    public EntityImpl createEntity(SourceInfo sourceInfo) {
        return new EntityImpl(this, sourceInfo);
    }

    @Override
    public AttributeImpl createAttribute(Entity entity, SourceInfo sourceInfo, boolean implicit) {
        return new AttributeImpl(this, entity, sourceInfo, implicit);
    }

    @Override
    public AttributeOptionsImpl createAttributeOptions(Attribute attribute, SourceInfo sourceInfo) {
        return new AttributeOptionsImpl(attribute, sourceInfo);
    }

    @Override
    public EntityOptionsImpl createEntityOptions(Entity entity, SourceInfo sourceInfo) {
        return new EntityOptionsImpl(this, entity, sourceInfo);
    }

    @Override
    public IndexImpl createIndex(Entity entity, SourceInfo sourceInfo) {
        return new IndexImpl(this, entity, sourceInfo);
    }

    @Override
    public IndexAttributeImpl createIndexAttribute(Index index, SourceInfo sourceInfo) {
        return new IndexAttributeImpl(index, sourceInfo);
    }

    @Override
    public RelationImpl createRelation(Entity entity, SourceInfo sourceInfo) {
        return new RelationImpl(entity, sourceInfo);
    }

    @Override
    public Entity createEntity(String model, ModelDefaults modelDefaults) throws ModelException {
        List<String> sortOpts;
        Document document = new Document(model);
        List<Line> lines = document.getLines();
        EntityImpl entity = this.createEntity(document.getSourceInfo());
        if (modelDefaults != null) {
            if (modelDefaults.getBind() != null) {
                entity.getOptions().applyOption("BIND", true);
            }
            if (modelDefaults.getSize() != null) {
                entity.getOptions().applyOption("SIZE", true);
            }
            if (modelDefaults.getAutoSelect() != null) {
                entity.getOptions().applyOption("AUTOSELECT", true);
            }
        }
        AttributeImpl idAttribute = this.createAttribute(entity, document.getSourceInfo(), true);
        idAttribute.setDataType(DataType.LONG_PRIMITIVE);
        idAttribute.setColumnName("id");
        idAttribute.setJavaName("id");
        idAttribute.getOptions().setComment("object id");
        idAttribute.getOptions().setFromSuper(true);
        idAttribute.getOptions().setSetGet(true);
        entity.getAttributes().add(idAttribute);
        AttributeImpl serialAttribute = this.createAttribute(entity, document.getSourceInfo(), true);
        serialAttribute.setDataType(DataType.LONG_PRIMITIVE);
        serialAttribute.setColumnName("serial");
        serialAttribute.setJavaName("serial");
        serialAttribute.getOptions().setComment("object serial");
        serialAttribute.getOptions().setFromSuper(true);
        serialAttribute.getOptions().setSetGet(true);
        entity.getAttributes().add(serialAttribute);
        block10: for (Line line : lines) {
            switch (line.getLineType()) {
                case EMPTY: {
                    continue block10;
                }
                case COMMENT: {
                    String comment = ((CommentLine)line).getComment();
                    if (comment != null && !comment.isEmpty() && comment.charAt(0) == '#') continue block10;
                    this.setPendingComment(comment);
                    if (entity.getName() != null) continue block10;
                    entity.getOptions().setComment(this.pendingComment);
                    continue block10;
                }
                case CONFIGURATION: {
                    this.processConfiguration(entity, (ConfigurationLine)line);
                    continue block10;
                }
                case GLOBAL_OPTION: {
                    this.processGlobalOption(entity, (GlobalOptionLine)line);
                    continue block10;
                }
                case ATTRIBUTE_OPTION: {
                    this.processAttributeOption(entity, (OptionLine)line);
                    continue block10;
                }
                case ATTRIBUTE: {
                    this.processAttribute(entity, (AttributeLine)line);
                    continue block10;
                }
                case RELATION: {
                    this.processRelation(entity, (RelationLine)line);
                    continue block10;
                }
                case RELATION_OPTION: {
                    this.processRelationOption(entity, (OptionLine)line);
                    continue block10;
                }
            }
            throw new ModelException("unknown linetype " + (Object)((Object)line.getLineType()), document.getSourceInfo().add(line.getLineNumber() - 1, 0));
        }
        for (Attribute attribute : entity.getAttributes()) {
            if ("tableSerial".equals(attribute.getJavaName()) || "tableserial".equals(attribute.getColumnName())) {
                if (!attribute.isImplicit()) {
                    throw new ModelException("use [TABLESERIAL] option instead of explicit attribute", entity);
                }
                if (entity.getSuperEntityName() != null) {
                    throw new ModelException("[TABLESERIAL] option not allowed in subclasses", entity);
                }
            }
            if ("normText".equals(attribute.getJavaName()) || "normtext".equals(attribute.getColumnName())) {
                if (!attribute.isImplicit()) {
                    throw new ModelException("use [NORMTEXT] option instead of explicit attribute", entity);
                }
                if (entity.getSuperEntityName() != null) {
                    throw new ModelException("[NORMTEXT] option not allowed in subclasses", entity);
                }
            }
            if (!"editedBy".equals(attribute.getJavaName()) && !"editedby".equals(attribute.getColumnName()) && !"editedSince".equals(attribute.getJavaName()) && !"editedsince".equals(attribute.getColumnName()) && !"editedExpiry".equals(attribute.getJavaName()) && !"editedexpiry".equals(attribute.getColumnName())) continue;
            if (!attribute.isImplicit()) {
                throw new ModelException("use [EDITEDBY] option instead of explicit attribute", entity);
            }
            if (entity.getSuperEntityName() == null) continue;
            throw new ModelException("[EDITEDBY] option not allowed in subclasses", entity);
        }
        for (Attribute attribute : entity.getAttributes()) {
            if (!attribute.getOptions().isContextId()) continue;
            if (entity.getContextIdAttribute() != null) {
                throw new ModelException("context id attribute set more than once", entity);
            }
            entity.setContextIdAttribute(attribute);
        }
        for (Relation relation : entity.getRelations()) {
            String firstArg = relation.getMethodArgs().get(0);
            Attribute attribute = entity.getAttributeByJavaName(firstArg, false);
            if (attribute == null) continue;
            ((RelationImpl)relation).setAttribute(attribute);
            ((AttributeImpl)attribute).setRelation(relation);
        }
        if (entity.isRootOfInheritanceHierarchy() && !entity.getInheritanceType().isMappingToNoTable()) {
            AttributeImpl classIdAttribute = this.createAttribute(entity, document.getSourceInfo(), true);
            classIdAttribute.setDataType(DataType.INTEGER_PRIMITIVE);
            classIdAttribute.setColumnName("classid");
            classIdAttribute.setJavaName("classId");
            classIdAttribute.getOptions().setComment("class id");
            classIdAttribute.getOptions().setFromSuper(true);
            classIdAttribute.getOptions().setSetGet(true);
            entity.getAttributes().add(0, classIdAttribute);
        }
        entity.getAttributes().remove(idAttribute);
        entity.getAttributes().remove(serialAttribute);
        if (entity.getSuperEntityName() == null || entity.isAbstract() && entity.getInheritanceType().isMappingToOwnTable()) {
            entity.getAttributes().add(idAttribute);
            entity.getAttributes().add(serialAttribute);
        }
        if ((sortOpts = entity.getOptions().getSorting()) != null) {
            ArrayList<AttributeSorting> sorting = new ArrayList<AttributeSorting>();
            for (String sortOpt : sortOpts) {
                String name = sortOpt.substring(1);
                SortType sortType = sortOpt.charAt(0) == '+' ? SortType.ASC : SortType.DESC;
                Attribute attribute = entity.getAttributeByJavaName(name, false);
                if (attribute == null) {
                    attribute = entity.getAttributeByColumnName(name, false);
                }
                if (attribute == null) {
                    throw new ModelException("no such attribute '" + name + "' to sort", entity.getOptions().getSourceInfo());
                }
                sorting.add(new AttributeSorting(attribute, sortType));
            }
            entity.setSorting(sorting);
        }
        entity.validate();
        return entity;
    }

    protected void processConfiguration(EntityImpl entity, ConfigurationLine line) throws ModelException {
        if (!entity.parseConfiguration(line)) {
            this.processIndexConfiguration(entity, line);
        }
        this.consumePendingComment();
    }

    protected void processIndexConfiguration(EntityImpl entity, ConfigurationLine line) throws ModelException {
        IndexImpl index = this.createIndex(entity, line.getSourceInfo());
        index.parse(entity, line);
        String comment = this.consumePendingComment();
        if (BasicStringHelper.isAllWhitespace((String)index.getComment())) {
            index.setComment(comment);
        }
        entity.getIndexes().add(index);
    }

    protected void processGlobalOption(EntityImpl entity, GlobalOptionLine line) throws ModelException {
        if (!entity.getAttributes().isEmpty()) {
            line.createModelException("global options must appear before attributes declaration section");
        }
        EntityOptionsImpl options = entity.getOptions();
        for (String option : line.getOptions()) {
            if (options.processOption(option)) continue;
            throw line.createModelException("illegal global option: " + option);
        }
        this.consumePendingComment();
    }

    protected void processAttributeOption(EntityImpl entity, OptionLine line) throws ModelException {
        Attribute attribute = entity.getAttributeByJavaName(line.getName(), false);
        if (attribute == null) {
            throw line.createModelException("no such attribute: " + line.getName());
        }
        AttributeOptionsImpl attributeOptions = (AttributeOptionsImpl)attribute.getOptions();
        for (String option : line.getOptions()) {
            if (option.startsWith("@")) {
                attributeOptions.getAnnotations().add(option);
                continue;
            }
            if (attributeOptions.processOption(option.toUpperCase())) continue;
            throw line.createModelException("illegal option '" + option + "' for attribute " + attribute);
        }
        this.consumePendingComment();
    }

    protected void processRelationOption(EntityImpl entity, OptionLine line) throws ModelException {
        Relation relation = entity.getRelation(line.getName(), false);
        if (relation == null) {
            throw line.createModelException("no such relation: " + line.getName());
        }
        for (String option : line.getOptions()) {
            if (option.startsWith("@")) {
                relation.getAnnotations().add(option);
                continue;
            }
            throw line.createModelException("illegal option '" + option + "' for relation " + relation);
        }
        this.consumePendingComment();
    }

    protected void processAttribute(EntityImpl entity, AttributeLine line) throws ModelException {
        AttributeImpl attribute = this.createAttribute(entity, line.getSourceInfo(), false);
        attribute.parse(entity, line);
        String comment = this.consumePendingComment();
        if (BasicStringHelper.isAllWhitespace((String)attribute.getOptions().getComment())) {
            attribute.getOptions().setComment(comment);
        }
        entity.getAttributes().add(attribute);
    }

    protected void processRelation(EntityImpl entity, RelationLine line) throws ModelException {
        RelationImpl relation = this.createRelation(entity, line.getSourceInfo());
        relation.parse(entity, line);
        String comment = this.consumePendingComment();
        if (BasicStringHelper.isAllWhitespace((String)relation.getComment())) {
            relation.setComment(comment);
        }
        if (BasicStringHelper.isAllWhitespace((String)relation.getComment())) {
            relation.setComment(relation.getName());
        }
        entity.getRelations().add(relation);
    }

    protected void setPendingComment(String commentLine) {
        this.pendingComment = commentLine;
    }

    protected String consumePendingComment() {
        String str = this.pendingComment;
        this.pendingComment = null;
        return str;
    }
}

