/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;

public class ModelDirectory {
    private final File dir;
    private final ModelDefaults modelDefaults;
    private long lastModified;

    public ModelDirectory(String modelDir, ModelDefaults defaults) throws ModelException {
        this.dir = new File(modelDir);
        if (!this.dir.exists()) {
            throw new ModelException(modelDir + " does not exist");
        }
        if (!this.dir.isDirectory()) {
            throw new ModelException(modelDir + " is not a directory");
        }
        this.lastModified = this.dir.lastModified();
        this.modelDefaults = defaults;
    }

    public File getFile() {
        return this.dir;
    }

    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    public boolean hasChanged() {
        return this.dir.lastModified() > this.lastModified;
    }

    public void markDirty() {
        this.lastModified = 0L;
    }
}

