/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelException;

public class ModelEntity {
    private final Entity entity;
    private final File file;
    private final long lastModified;

    public ModelEntity(Entity entity, String fileName) throws ModelException {
        this.entity = entity;
        this.file = new File(fileName);
        if (!this.file.exists()) {
            throw new ModelException(fileName + " does not exist");
        }
        if (!this.file.isFile()) {
            throw new ModelException(fileName + " is not a regular file");
        }
        this.lastModified = this.file.lastModified();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasChanged() {
        return this.file.lastModified() > this.lastModified;
    }
}

