/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityFactory;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.TrackType;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.ForeignKeyImpl;
import org.tentackle.model.impl.ModelDirectory;
import org.tentackle.model.impl.ModelEntity;
import org.tentackle.model.impl.RelationImpl;
import org.tentackle.sql.Backend;

@Service(value=Model.class)
public class ModelImpl
implements Model {
    private final Map<String, ModelEntity> mapByFileName;
    private final Map<String, ModelEntity> mapByEntityName;
    private final Map<Integer, ModelEntity> mapByClassId;
    private final Map<String, ModelDirectory> modelDirs;
    private final EntityFactory entityFactory = this.createEntityFactory();
    private Collection<ForeignKey> foreignKeys;
    private boolean mapSchemas;

    public ModelImpl() {
        this.mapByEntityName = new TreeMap<String, ModelEntity>();
        this.mapByClassId = new HashMap<Integer, ModelEntity>();
        this.mapByFileName = new HashMap<String, ModelEntity>();
        this.modelDirs = new HashMap<String, ModelDirectory>();
    }

    @Override
    public void setSchemaNameMapped(boolean mapSchemas) {
        this.mapSchemas = mapSchemas;
    }

    @Override
    public boolean isSchemaNameMapped() {
        return this.mapSchemas;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public synchronized void loadModel(String modelDir, ModelDefaults defaults) throws ModelException {
        ModelDirectory dir = this.modelDirs.get(modelDir);
        if (dir == null || dir.hasChanged()) {
            dir = new ModelDirectory(modelDir, defaults);
            this.modelDirs.put(modelDir, dir);
            for (File file : dir.getFile().listFiles()) {
                if (file.isHidden()) continue;
                this.loadByFileName(defaults, file.getPath(), false);
            }
            this.updateRelations(defaults);
        }
        if (defaults != null) {
            Entity entity;
            boolean updateRelations = false;
            if (defaults.getTrackType() != null) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults() || defaults.getTrackType().ordinal() <= entity.getOptions().getTrackType().ordinal()) continue;
                    ((EntityImpl)entity).getOptions().setTrackType(defaults.getTrackType());
                    updateRelations = true;
                }
            }
            if (defaults.getDeletionCascaded() != null && defaults.getDeletionCascaded().booleanValue()) {
                for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                    entity = modelEntity.getEntity();
                    if (entity.getOptions().noModelDefaults()) continue;
                    for (Relation relation : entity.getRelations()) {
                        if (!relation.isComposite() || relation.isDeletionCascaded()) continue;
                        ((RelationImpl)relation).setDeletionCascaded(defaults.getDeletionCascaded());
                        updateRelations = true;
                    }
                }
            }
            if (updateRelations) {
                this.updateRelations(defaults);
            }
        }
    }

    @Override
    public synchronized void clearModel() {
        this.mapByEntityName.clear();
        this.mapByClassId.clear();
        this.mapByFileName.clear();
        this.modelDirs.clear();
    }

    @Override
    public void refreshModel() throws ModelException {
        for (ModelDirectory modelDir : this.modelDirs.values()) {
            modelDir.markDirty();
            this.loadModel(modelDir.getFile().getAbsolutePath(), modelDir.getModelDefaults());
        }
    }

    @Override
    public synchronized Collection<Entity> getAllEntitites() throws ModelException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        boolean refreshed = false;
        block0: do {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                if (modelEntity.hasChanged()) {
                    this.refreshModel();
                    list.clear();
                    refreshed = true;
                    continue block0;
                }
                list.add(modelEntity.getEntity());
            }
        } while (refreshed);
        return list;
    }

    @Override
    public synchronized Entity getByFileName(String fileName) throws ModelException {
        ModelEntity modelEntity = this.mapByFileName.get(fileName);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByFileName.get(fileName);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByEntityName(String entityName) throws ModelException {
        String name = entityName.toLowerCase();
        ModelEntity modelEntity = this.mapByEntityName.get(name);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByEntityName.get(name);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public synchronized Entity getByClassId(int classId) throws ModelException {
        ModelEntity modelEntity = this.mapByClassId.get(classId);
        if (modelEntity != null && modelEntity.hasChanged()) {
            this.refreshModel();
            modelEntity = this.mapByClassId.get(classId);
        }
        return modelEntity == null ? null : modelEntity.getEntity();
    }

    @Override
    public Entity loadByFileName(ModelDefaults defaults, String fileName) throws ModelException {
        return this.loadByFileName(defaults, fileName, true);
    }

    protected synchronized Entity loadByFileName(ModelDefaults defaults, String fileName, boolean updateRelations) throws ModelException {
        ModelEntity modelEntity = this.mapByFileName.get(fileName);
        if (modelEntity != null && modelEntity.hasChanged()) {
            modelEntity = null;
        }
        if (modelEntity == null) {
            String tableName;
            BufferedReader reader = null;
            StringBuilder modelSource = new StringBuilder();
            try {
                int len;
                reader = new BufferedReader(this.createFileReader(fileName));
                char[] buf = new char[1024];
                while ((len = reader.read(buf)) != -1) {
                    modelSource.append(buf, 0, len);
                }
            }
            catch (IOException ex) {
                throw new ModelException("reading model '" + fileName + "' failed", ex);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                Entity entity = this.getEntityFactory().createEntity(modelSource.toString(), defaults);
                modelEntity = new ModelEntity(entity, fileName);
            }
            catch (ModelException mex) {
                String msg = "parsing '" + fileName + "' failed:\n    " + ExceptionHelper.concatenateMessages((Throwable)mex);
                throw new ModelException(msg, mex);
            }
            if (this.mapSchemas && (tableName = modelEntity.getEntity().getTableName()) != null) {
                ((EntityImpl)modelEntity.getEntity()).setTableName(tableName.replace('.', '_'));
            }
            this.mapByFileName.put(fileName, modelEntity);
            ModelEntity oldModelEntity = this.mapByEntityName.put(modelEntity.getEntity().getName().toLowerCase(), modelEntity);
            if (modelEntity.getEntity().getClassId() != 0) {
                if (oldModelEntity != null && oldModelEntity.getEntity().getClassId() != modelEntity.getEntity().getClassId()) {
                    throw new ModelException("duplicate entity " + modelEntity.getEntity().getName() + " in file " + fileName, modelEntity.getEntity());
                }
                oldModelEntity = this.mapByClassId.put(modelEntity.getEntity().getClassId(), modelEntity);
                if (oldModelEntity != null && !oldModelEntity.getEntity().getName().equals(modelEntity.getEntity().getName())) {
                    throw new ModelException("duplicate entity id " + modelEntity.getEntity().getClassId() + " for " + modelEntity.getEntity().getName() + ", already assigned to " + oldModelEntity.getEntity().getName(), modelEntity.getEntity());
                }
            }
            this.foreignKeys = null;
            if (updateRelations) {
                this.updateRelations(defaults, modelEntity);
            }
        }
        return modelEntity.getEntity();
    }

    protected void updateRelations(ModelDefaults defaults) throws ModelException {
        this.updateRelations(defaults, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateRelations(ModelDefaults defaults, ModelEntity loadedModelEntity) throws ModelException {
        Entity entity;
        StringBuilder exMsg = new StringBuilder();
        HashSet<Entity> exEntities = new HashSet<Entity>();
        Entity loadedEntity = loadedModelEntity == null ? null : loadedModelEntity.getEntity();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            modelEntity.getEntity().getSubEntities().clear();
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntityName() == null) continue;
            Entity superEntity = this.getByEntityName(entity.getSuperEntityName());
            if (superEntity == null) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append("no such super entity '");
                exMsg.append(entity.getSuperEntityName());
                exMsg.append("' to be extended by '");
                exMsg.append(entity);
                exMsg.append("'");
                exEntities.add(entity);
                continue;
            }
            ((EntityImpl)entity).setSuperEntity(superEntity);
            if (superEntity.getInheritanceType() == InheritanceType.NONE && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append("super entity '");
                exMsg.append(superEntity);
                exMsg.append("' extended by '");
                exMsg.append(entity);
                exMsg.append("' is not extensible (missing inheritance := ... ?)");
                exEntities.add(entity);
                exEntities.add(superEntity);
            }
            superEntity.getSubEntities().add(entity);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            entity.getReferencingRelations().clear();
            entity.getCompositePaths().clear();
            entity.getDeepReferences().clear();
            entity.getDeepReferencesToComponents().clear();
            ((EntityImpl)entity).setDeeplyReferenced(false);
            for (Relation relation : entity.getRelations()) {
                ((RelationImpl)relation).setForeignRelation(null);
                Entity entity2 = this.getByEntityName(relation.getClassName());
                if (entity2 == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    if (exMsg.length() > 0) {
                        exMsg.append('\n');
                    }
                    exMsg.append("no such entity: ");
                    exMsg.append(relation.getClassName());
                    exEntities.add(entity);
                    continue;
                }
                ((RelationImpl)relation).setForeignEntity(entity2);
                if (relation.getRelationType() != RelationType.LIST) continue;
                Object attributeName = relation.getMethodName() != null ? relation.getMethodName() : relation.getEntity().getName() + "Id";
                Attribute attribute = entity2.getAttributeByJavaName((String)(attributeName = BasicStringHelper.firstToLower((String)attributeName)), true);
                if (attribute == null) {
                    if (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity)) {
                        if (exMsg.length() > 0) {
                            exMsg.append('\n');
                        }
                        exMsg.append("no such attribute: ");
                        exMsg.append((String)attributeName);
                        exMsg.append(" in ");
                        exMsg.append(entity2);
                        exEntities.add(entity);
                        exEntities.add(entity2);
                    }
                } else {
                    ((RelationImpl)relation).setForeignAttribute(attribute);
                }
                if (relation.getNmName() == null) continue;
                Relation nmRelation = entity2.getRelation(relation.getNmName(), false);
                if (nmRelation == null) {
                    if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                    if (exMsg.length() > 0) {
                        exMsg.append('\n');
                    }
                    exMsg.append("no such nm-relation: ");
                    exMsg.append(relation.getNmName());
                    exMsg.append(" in ");
                    exMsg.append(entity2);
                    exEntities.add(entity);
                    exEntities.add(entity2);
                    continue;
                }
                if ((nmRelation.isComposite() || nmRelation.getRelationType() == RelationType.LIST) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    if (exMsg.length() > 0) {
                        exMsg.append('\n');
                    }
                    exMsg.append("nm-relation ");
                    exMsg.append(nmRelation.getName());
                    exMsg.append(" in ");
                    exMsg.append(entity2);
                    exMsg.append(" must be non-composite object");
                    exEntities.add(entity);
                    exEntities.add(entity2);
                }
                if (nmRelation.getClassName().equals(entity.getName()) && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    if (exMsg.length() > 0) {
                        exMsg.append('\n');
                    }
                    exMsg.append("nm-relation ");
                    exMsg.append(nmRelation.getName());
                    exMsg.append(" in ");
                    exMsg.append(entity2);
                    exMsg.append(" points back to ");
                    exMsg.append(entity);
                    exEntities.add(entity);
                    exEntities.add(entity2);
                }
                if (nmRelation.getSelectionType() == SelectionType.LAZY && !nmRelation.isSerialized()) {
                    ((RelationImpl)nmRelation).setSerialized(true);
                    ((RelationImpl)nmRelation).setClearOnRemoteSave(true);
                }
                ((RelationImpl)relation).setNmRelation(nmRelation);
                ((RelationImpl)nmRelation).setDefiningNmRelation(relation);
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            for (ModelEntity modelEntity2 : this.mapByEntityName.values()) {
                Entity entity3 = modelEntity2.getEntity();
                for (Relation relation : entity3.getRelations()) {
                    Entity foreignEntity = relation.getForeignEntity();
                    if (foreignEntity == null || !foreignEntity.equals(entity)) continue;
                    entity.getReferencingRelations().add(relation);
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            block12: for (Relation relation : entity.getReferencingRelations()) {
                if (relation.getForeignRelation() != null) continue;
                for (Relation otherRelation : relation.getForeignEntity().getTableRelations()) {
                    if (!Objects.equals(relation.getEntity(), otherRelation.getForeignEntity()) || !Objects.equals(relation.getAttribute(), otherRelation.getForeignAttribute())) continue;
                    ((RelationImpl)relation).setForeignRelation(otherRelation);
                    ((RelationImpl)otherRelation).setForeignRelation(relation);
                    continue block12;
                }
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            boolean isRootEntity = true;
            for (Relation relation : entity.getAllReferencingRelations()) {
                if (!relation.isComposite()) continue;
                isRootEntity = false;
                break;
            }
            ((EntityImpl)entity).setRootEntityAccordingToModel(isRootEntity);
            if (!isRootEntity) continue;
            for (Relation relation : entity.getAllRelations()) {
                if (!relation.isComposite()) continue;
                Iterator<Entity> compositePath = new ArrayList<Relation>();
                compositePath.add((Entity)((Object)relation));
                this.updateCompositePath((List<Relation>)((Object)compositePath), relation.getForeignEntity());
            }
        }
        block17: for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            Set<Entity> rootEntities = entity.getRootEntities();
            if (rootEntities.size() > 1 && entity.getRootAttribute() != null) {
                ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
            }
            if (!rootEntities.isEmpty()) {
                for (Relation relation : entity.getReferencingRelationsIncludingSubEntities()) {
                    if (relation.isComposite() || relation.getForeignRelation() != null && relation.getForeignRelation().isComposite() || rootEntities.containsAll(relation.getEntity().getRootEntities())) continue;
                    ((RelationImpl)relation).setDeepReference(true);
                    ((EntityImpl)entity).setDeeplyReferenced(true);
                    ((EntityImpl)entity).getDeepReferences().add(relation);
                    for (List list : entity.getCompositePaths()) {
                        for (Relation compositeRelation : list) {
                            ((EntityImpl)compositeRelation.getEntity()).setDeeplyReferenced(true);
                        }
                    }
                    for (Entity entity4 : rootEntities) {
                        entity4.getDeepReferencesToComponents().add(relation);
                    }
                    if (entity.getRootEntity() != null) continue;
                    ((EntityImpl)entity).setProvidingRootClassIdAccordingToModel(true);
                }
            }
            for (List<Relation> list : entity.getCompositePaths()) {
                if (list.size() <= 1 && list.get(list.size() - 1).getRelationType() != RelationType.OBJECT) continue;
                ((EntityImpl)entity).setProvidingRootIdAccordingToModel(true);
                continue block17;
            }
        }
        if (defaults != null) {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                entity = modelEntity.getEntity();
                if (entity.getOptions().noModelDefaults()) continue;
                if (defaults.getTrackType() != null && defaults.getTrackType().ordinal() > entity.getOptions().getTrackType().ordinal()) {
                    ((EntityOptionsImpl)entity.getOptions()).setTrackType(defaults.getTrackType());
                }
                if (Boolean.TRUE.equals(defaults.getRoot()) && entity.isRootEntityAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootEntity(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootClassId()) && entity.isProvidingRootClassIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootClassIdProvided(true);
                }
                if (Boolean.TRUE.equals(defaults.getRootId()) && entity.isProvidingRootIdAccordingToModel()) {
                    ((EntityImpl)entity.getTopSuperEntity()).getOptions().setRootIdProvided(true);
                }
                if (defaults.getRemote() == null) continue;
                ((EntityOptionsImpl)entity.getOptions()).setRemote(defaults.getRemote());
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getOptions().isRootClassIdProvided()) {
                if (entity.getAttributeByColumnName("rootclassid", true) == null) {
                    ((EntityImpl)entity).getOptions().applyOption("ROOTCLASSID", Boolean.TRUE);
                }
            } else {
                Attribute rootClassAttribute = entity.getAttributeByColumnName("rootclassid", false);
                if (rootClassAttribute != null) {
                    entity.getAttributes().remove(rootClassAttribute);
                }
            }
            if (entity.getOptions().isRootIdProvided()) {
                if (entity.getAttributeByColumnName("rootid", true) != null) continue;
                ((EntityImpl)entity).getOptions().applyOption("ROOTID", Boolean.TRUE);
                continue;
            }
            Attribute rootAttribute = entity.getAttributeByColumnName("rootid", false);
            if (rootAttribute == null) continue;
            entity.getAttributes().remove(rootAttribute);
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            for (Relation relation : entity.getRelations()) {
                Relation relation2;
                if (relation.getEntity().getOptions().getTrackType().isTracked()) {
                    ((RelationImpl)relation).setTracked(true);
                }
                if (!relation.isComposite()) continue;
                if (relation.getRelationType() == RelationType.LIST && relation.getLinkMethodName() == null && (relation2 = relation.getForeignEntity().getRelation(entity.getName(), true)) != null && relation2.getRelationType() == RelationType.OBJECT && relation2.getSelectionType() == SelectionType.LAZY) {
                    ((RelationImpl)relation).setLinkMethodName("set" + entity.getName());
                }
                if (relation.getLinkMethodName() != null) {
                    ((RelationImpl)relation).setReferenced(true);
                }
                if (relation.isTracked() || !entity.getIntegrity().isCompositesCheckedByDatabase()) continue;
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append("untracked relation ").append(relation).append(" not allowed in conjunction with ").append((Object)entity.getIntegrity()).append("-integrity in ");
                exMsg.append(entity);
                exEntities.add(entity);
                exEntities.add(relation.getForeignEntity());
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            try {
                ((EntityImpl)entity).validateRelated();
            }
            catch (ModelException mex) {
                if (loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append(mex.getMessage());
                exMsg.append(" in ");
                exMsg.append(entity);
                exEntities.add(entity);
                exEntities.addAll(mex.getEntities());
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            entity = modelEntity.getEntity();
            if (entity.getSuperEntity() != null || entity.getInheritanceType().isMappingToNoTable()) continue;
            HashMap<String, Attribute> columnMap = new HashMap<String, Attribute>();
            HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            arrayList.addAll(entity.getAttributes());
            for (Entity entity5 : entity.getAllSubEntities()) {
                arrayList.addAll(entity5.getAttributes());
            }
            for (Attribute attribute : arrayList) {
                Attribute oldAttribute = hashMap.put(attribute.getJavaName().toLowerCase(), attribute);
                if (oldAttribute != null && (loadedEntity == null || loadedEntity.getAssociatedEntities().contains(entity))) {
                    if (exMsg.length() > 0) {
                        exMsg.append('\n');
                    }
                    exMsg.append("attribute '").append(attribute.getJavaName()).append("' in ").append(attribute.getEntity());
                    if (attribute.getSourceLine() != null) {
                        exMsg.append("(").append(attribute.getSourceLine()).append(")");
                    }
                    exMsg.append(" already defined in ").append(oldAttribute.getEntity());
                    if (oldAttribute.getSourceLine() != null) {
                        exMsg.append("(").append(oldAttribute.getSourceLine()).append(")");
                    }
                    exEntities.add(entity);
                    exEntities.add(attribute.getEntity());
                    exEntities.add(oldAttribute.getEntity());
                }
                Attribute oldColumn = columnMap.put(attribute.getColumnName().toLowerCase(), attribute);
                if (oldAttribute != null || oldColumn == null || loadedEntity != null && !loadedEntity.getAssociatedEntities().contains(entity)) continue;
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append("column '").append(attribute.getColumnName()).append("' in ").append(attribute.getEntity());
                if (attribute.getSourceLine() != null) {
                    exMsg.append("(").append(attribute.getSourceLine()).append(")");
                }
                exMsg.append(" already defined in ").append(oldColumn.getEntity());
                if (oldColumn.getSourceLine() != null) {
                    exMsg.append("(").append(oldColumn.getSourceLine()).append(")");
                }
                exMsg.append(" as attribute '").append(attribute).append("'");
                exEntities.add(entity);
                exEntities.add(attribute.getEntity());
                exEntities.add(oldColumn.getEntity());
            }
        }
        HashMap<String, Entity> aliasMap = new HashMap<String, Entity>();
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            Entity entity2 = modelEntity.getEntity();
            if (entity2.getTableAlias() == null) continue;
            Entity entity6 = (Entity)aliasMap.get(entity2.getTableAlias());
            if (entity6 != null) {
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append("table alias '").append(entity2.getTableAlias()).append("' defined more than once in ");
                exMsg.append(entity2).append(" and ").append(entity6);
                exEntities.add(entity2);
                exEntities.add(entity6);
                continue;
            }
            aliasMap.put(entity2.getTableAlias(), entity2);
        }
        block32: for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            String alias;
            char c;
            char c2;
            Entity entity3 = modelEntity.getEntity();
            if (entity3.getTableName() == null || entity3.getTableAlias() != null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 95;
            for (int i = 0; i < entity3.getName().length(); ++i) {
                c2 = entity3.getName().charAt(i);
                if (Character.isUpperCase(c2)) {
                    stringBuilder.append(c2);
                }
                c = c2;
            }
            if (stringBuilder.length() <= 1) {
                stringBuilder.append(c);
            }
            if (aliasMap.get(alias = stringBuilder.toString().toLowerCase()) == null) {
                c2 = '\u0001';
                for (Backend backend : this.getEntityFactory().getBackends()) {
                    try {
                        backend.assertValidName("table alias", alias);
                    }
                    catch (RuntimeException rex) {
                        c2 = '\u0000';
                        break;
                    }
                }
                if (c2 != '\u0000') {
                    ((EntityImpl)entity3).setTableAlias(alias);
                    aliasMap.put(alias, entity3);
                    continue;
                }
            }
            c2 = '\u0001';
            while (true) {
                void var13_104;
                String numberedAlias;
                if (aliasMap.get(numberedAlias = alias.substring(0, 1) + (int)var13_104) == null) {
                    ((EntityImpl)entity3).setTableAlias(numberedAlias);
                    aliasMap.put(numberedAlias, entity3);
                    continue block32;
                }
                ++var13_104;
            }
        }
        for (ModelEntity modelEntity : this.mapByEntityName.values()) {
            void var10_71;
            void var11_90;
            Entity entity4 = modelEntity.getEntity();
            boolean bl = false;
            Entity entity7 = entity4.getSuperEntity();
            while (var11_90 != null) {
                ++var10_71;
                Entity entity8 = var11_90.getSuperEntity();
            }
            ((EntityImpl)entity4).setInheritanceLevel((int)var10_71);
        }
        if (loadedEntity != null) {
            Entity entity9 = loadedEntity.getTopSuperEntity();
            this.validateInheritanceHierarchy(entity9, entity9.getInheritanceType(), entity9.getOptions().getTrackType(), entity9.getIntegrity(), exMsg, exEntities);
            this.validateComponents(entity9, entity9.getIntegrity(), exMsg, exEntities);
        } else {
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity5 = modelEntity.getEntity();
                this.validateInheritanceHierarchy(entity5, entity5.getInheritanceType(), entity5.getOptions().getTrackType(), entity5.getIntegrity(), exMsg, exEntities);
                this.validateComponents(entity5, entity5.getIntegrity(), exMsg, exEntities);
            }
        }
        if (exMsg.length() > 0) {
            ModelException modelException = new ModelException(exMsg.toString());
            modelException.getEntities().addAll(exEntities);
            throw modelException;
        }
    }

    protected void updateCompositePath(List<Relation> compositePath, Entity entity) {
        Relation lastRelation = compositePath.get(compositePath.size() - 1);
        if (lastRelation.getForeignAttribute() != null) {
            entity = lastRelation.getForeignAttribute().getEntity();
        }
        entity.getCompositePaths().add(compositePath);
        for (Relation relation : entity.getAllRelations()) {
            if (!relation.isComposite()) continue;
            ArrayList<Relation> newPath = new ArrayList<Relation>(compositePath);
            newPath.add(relation);
            this.updateCompositePath(newPath, relation.getForeignEntity());
        }
    }

    @Override
    public synchronized Collection<ForeignKey> getForeignKeys() throws ModelException {
        if (this.foreignKeys == null) {
            TreeMap<ForeignKeyImpl, ForeignKeyImpl> foreignKeyMap = new TreeMap<ForeignKeyImpl, ForeignKeyImpl>();
            StringBuilder exMsg = new StringBuilder();
            HashSet<Entity> exEntities = new HashSet<Entity>();
            for (ModelEntity modelEntity : this.mapByEntityName.values()) {
                Entity entity = modelEntity.getEntity();
                if (!entity.getInheritanceType().isMappingToOwnTable()) continue;
                for (Relation relation : entity.getTableRelations()) {
                    List<Entity> referencingEntities;
                    Relation foreignRelation;
                    Attribute referencingAttribute = null;
                    Entity referencingEntity = null;
                    Attribute referencedAttribute = null;
                    Entity referencedEntity = null;
                    boolean composite = relation.isComposite();
                    if (!composite && (foreignRelation = relation.getForeignRelation()) != null && foreignRelation.getRelationType() == RelationType.LIST && foreignRelation.isComposite()) {
                        composite = true;
                    }
                    if (relation.getAttribute() != null) {
                        if (relation.getForeignEntity() == null) {
                            if (exMsg.length() > 0) {
                                exMsg.append('\n');
                            }
                            exMsg.append("no foreign entity for ");
                            exMsg.append(relation);
                            exEntities.add(entity);
                        } else {
                            referencingEntity = relation.getEntity();
                            referencingAttribute = relation.getAttribute();
                            referencedEntity = relation.getForeignEntity();
                            referencedAttribute = referencedEntity.getAttributeByJavaName("id", true);
                        }
                    } else if (relation.getForeignAttribute() != null) {
                        referencingEntity = relation.getForeignEntity();
                        referencingAttribute = relation.getForeignAttribute();
                        referencedEntity = entity;
                        referencedAttribute = entity.getAttributeByJavaName("id", true);
                    } else {
                        if (exMsg.length() > 0) {
                            exMsg.append('\n');
                        }
                        exMsg.append("broken relation ");
                        exMsg.append(relation);
                        exMsg.append(" in ");
                        exMsg.append(entity);
                        exEntities.add(entity);
                    }
                    if (referencingEntity.getTableProvidingEntity() == null) {
                        referencingEntities = referencingEntity.getLeafEntities();
                    } else {
                        referencingEntities = new ArrayList<Entity>();
                        referencingEntities.add(referencingEntity);
                    }
                    for (Entity refingEnt : referencingEntities) {
                        if (referencingAttribute == null || referencedAttribute == null || (composite || !referencedAttribute.getEntity().getIntegrity().isRelatedCheckedByDatabase()) && (!composite || !referencedAttribute.getEntity().getIntegrity().isCompositesCheckedByDatabase())) continue;
                        ForeignKeyImpl foreignKey = new ForeignKeyImpl(refingEnt, referencingAttribute, referencedEntity, referencedAttribute, composite);
                        ForeignKey oppositeForeignKey = (ForeignKey)foreignKeyMap.get(foreignKey);
                        if (oppositeForeignKey != null) {
                            if (!composite || oppositeForeignKey.isComposite()) continue;
                            ((ForeignKeyImpl)oppositeForeignKey).setComposite(true);
                            continue;
                        }
                        foreignKeyMap.put(foreignKey, foreignKey);
                    }
                }
                if (entity.getSuperEntity() == null || !entity.getHierarchyInheritanceType().isMappingToOwnTable()) continue;
                Entity topEntity = entity.getTopSuperEntity();
                Attribute idAttribute = topEntity.getAttributeByJavaName("id", false);
                ForeignKeyImpl foreignKey = new ForeignKeyImpl(entity, idAttribute, topEntity, idAttribute, false);
                foreignKeyMap.put(foreignKey, foreignKey);
            }
            if (exMsg.length() > 0) {
                ModelException ex = new ModelException(exMsg.toString());
                ex.getEntities().addAll(exEntities);
                throw ex;
            }
            this.foreignKeys = foreignKeyMap.values();
        }
        return this.foreignKeys;
    }

    protected EntityFactory createEntityFactory() {
        return new EntityFactoryImpl();
    }

    protected Reader createFileReader(String fileName) throws ModelException {
        try {
            return new FileReader(fileName);
        }
        catch (FileNotFoundException ex) {
            throw new ModelException("cannot open reader for " + fileName, ex);
        }
    }

    protected String validateInheritanceHierarchy(Entity entity, InheritanceType inheritanceType, TrackType trackType, Integrity integrity, StringBuilder exMsg, Set<Entity> exEntities) {
        if (entity.getOptions().getTrackType() != trackType) {
            if (exMsg.length() > 0) {
                exMsg.append('\n');
            }
            exMsg.append(entity);
            exMsg.append(" has wrong track type ");
            exMsg.append((Object)entity.getOptions().getTrackType());
            exMsg.append(", expected ");
            exMsg.append((Object)trackType);
            exEntities.add(entity);
        }
        if (entity.getIntegrity() != integrity) {
            if (exMsg.length() > 0) {
                exMsg.append('\n');
            }
            exMsg.append(entity);
            exMsg.append(" has wrong integrity type ");
            exMsg.append((Object)entity.getIntegrity());
            exMsg.append(", expected ");
            exMsg.append((Object)integrity);
            exEntities.add(entity);
        }
        if (entity.getSubEntities().isEmpty()) {
            if (entity.getInheritanceType() != InheritanceType.NONE) {
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append(entity);
                exMsg.append(" without child entities must have an inheritance type of NONE");
                exEntities.add(entity);
            }
        } else {
            if (entity.getInheritanceType() != inheritanceType) {
                if (exMsg.length() > 0) {
                    exMsg.append('\n');
                }
                exMsg.append(entity);
                exMsg.append(" has wrong inheritance type ");
                exMsg.append((Object)entity.getInheritanceType());
                exMsg.append(", expected ");
                exMsg.append((Object)inheritanceType);
                exEntities.add(entity);
            }
            for (Entity child : entity.getSubEntities()) {
                this.validateInheritanceHierarchy(child, inheritanceType, trackType, integrity, exMsg, exEntities);
            }
        }
        return exMsg.toString();
    }

    protected String validateComponents(Entity entity, Integrity integrity, StringBuilder exMsg, Set<Entity> exEntities) {
        if (entity.getIntegrity() != integrity) {
            if (exMsg.length() > 0) {
                exMsg.append('\n');
            }
            exMsg.append(entity);
            exMsg.append(" has wrong integrity type ");
            exMsg.append((Object)entity.getIntegrity());
            exMsg.append(", expected ");
            exMsg.append((Object)integrity);
            exEntities.add(entity);
        }
        for (Relation relation : entity.getRelations()) {
            if (!relation.isComposite()) continue;
            this.validateComponents(relation.getForeignEntity(), integrity, exMsg, exEntities);
        }
        return exMsg.toString();
    }
}

