/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parser;

import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.parser.Document;
import org.tentackle.model.parser.LineType;

public abstract class Line {
    private final Document document;
    private final int offset;
    private final LineType lineType;
    private final int lineNumber;
    private int length = -1;

    public Line(Document document, int offset, LineType lineType) {
        this.document = document;
        this.offset = offset;
        this.lineType = lineType;
        this.lineNumber = document.getLineNumber(offset);
    }

    public Document getDocument() {
        return this.document;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    protected void assertParsed() throws ModelException {
        if (this.length < 0) {
            throw this.createModelException("line not parsed yet");
        }
    }

    public int getLength() throws ModelException {
        this.assertParsed();
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length < 0 ? this.getDocument().getText().length() - this.offset : length;
    }

    public String getText() throws ModelException {
        return this.document.getText().substring(this.offset, this.offset + this.getLength());
    }

    public SourceInfo getSourceInfo() {
        SourceInfo sourceInfo = this.getDocument().getSourceInfo();
        if (sourceInfo != null) {
            return sourceInfo.add(this.lineNumber - 1, 0);
        }
        return null;
    }

    public String toString() {
        SourceInfo info = this.getSourceInfo();
        return info == null ? "?" : info.toString();
    }

    public abstract void parse() throws ModelException;

    public ModelException createModelException(String message, Throwable cause) {
        return new ModelException(message, this.getSourceInfo(), cause);
    }

    public ModelException createModelException(String message) {
        return new ModelException(message, this.getSourceInfo());
    }
}

