/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parser;

public class OptionParser {
    private String text;
    private int max;
    private int pos;
    private int optionLevel;
    private int braceLevel;

    public OptionParser(String text, boolean checkBrackets) {
        this.text = text;
        this.max = text.length();
        this.optionLevel = checkBrackets ? 0 : 1;
    }

    public String nextOption() {
        String opt;
        StringBuilder option = new StringBuilder();
        while (this.pos < this.max) {
            char c;
            if ((c = this.text.charAt(this.pos++)) == '\\' && this.pos < this.max - 1) {
                c = this.text.charAt(this.pos++);
                if (this.optionLevel <= 0) continue;
                option.append(c);
                continue;
            }
            if (this.optionLevel > 0) {
                if (c == ']' && this.braceLevel == 0) {
                    --this.optionLevel;
                    if (this.optionLevel == 0) break;
                    option.append(c);
                    continue;
                }
                if (c == '[' && this.braceLevel == 0) {
                    ++this.optionLevel;
                    option.append(c);
                    continue;
                }
                if (c == ',' && this.braceLevel == 0) break;
                option.append(c);
                if (c == ')') {
                    if (this.braceLevel <= 0) continue;
                    --this.braceLevel;
                    continue;
                }
                if (c != '(') continue;
                ++this.braceLevel;
                continue;
            }
            if (c != '[' || this.braceLevel != 0) continue;
            ++this.optionLevel;
        }
        if ((opt = option.toString().trim()).length() > 0) {
            return opt;
        }
        return this.pos >= this.max ? null : opt;
    }
}

