/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.HashSet;
import java.util.Set;
import org.tentackle.model.Entity;
import org.tentackle.model.SourceInfo;

public class ModelException
extends Exception {
    private static final long serialVersionUID = 3405985077474898397L;
    private SourceInfo sourceInfo;
    private Set<Entity> entities;

    public ModelException(String message, SourceInfo sourceInfo, Throwable cause) {
        super(message, cause);
        this.sourceInfo = sourceInfo;
    }

    public ModelException(String message, Entity entity, Throwable cause) {
        super(message, cause);
        if (entity != null) {
            this.getEntities().add(entity);
        }
    }

    public ModelException(String message, Throwable cause) {
        super(message, cause);
    }

    public ModelException(String message, SourceInfo sourceInfo) {
        super(message);
        this.sourceInfo = sourceInfo;
    }

    public ModelException(String message, Entity entity) {
        super(message);
        if (entity != null) {
            this.getEntities().add(entity);
        }
    }

    public ModelException(String message) {
        super(message);
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public Entity getEntity() {
        return this.getEntities().isEmpty() ? null : this.getEntities().iterator().next();
    }

    public Set<Entity> getEntities() {
        if (this.entities == null) {
            this.entities = new HashSet<Entity>();
        }
        return this.entities;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder(super.getMessage());
        if (this.sourceInfo != null) {
            msg.append(" (").append(this.sourceInfo).append(")");
        }
        if (!this.getEntities().isEmpty()) {
            msg.append("\naffected Entities: ");
            boolean first = true;
            for (Entity entity : this.getEntities()) {
                if (first) {
                    first = false;
                } else {
                    msg.append(", ");
                }
                msg.append(entity);
            }
        }
        return msg.toString();
    }
}

