/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.io.File;

public class SourceInfo {
    private final String fileName;
    private final int lineNumber;
    private final int position;

    public SourceInfo(String fileName, int lineNumber, int position) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.position = position;
    }

    public SourceInfo(String fileName, int lineNumber) {
        this(fileName, lineNumber, 0);
    }

    public SourceInfo(String fileName) {
        this(fileName, 0);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getShortFileName() {
        String shortName = this.getFileName();
        int ndx = shortName.lastIndexOf(47);
        if (ndx == -1) {
            ndx = shortName.lastIndexOf(File.separatorChar);
        }
        if (ndx >= 0) {
            shortName = shortName.substring(ndx + 1);
        }
        return shortName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getPosition() {
        return this.position;
    }

    public SourceInfo add(int lineOffset, int positionOffset) {
        return new SourceInfo(this.fileName, this.lineNumber + lineOffset, this.position + positionOffset);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getShortFileName());
        if (this.getLineNumber() != 0) {
            buf.append(":[");
            buf.append(this.getLineNumber());
            if (this.getPosition() != 0) {
                buf.append(',');
                buf.append(this.getPosition());
            }
            buf.append(']');
        }
        return buf.toString();
    }
}

