/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.Objects;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.common.Compare;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeOptionsImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.parser.AttributeLine;
import org.tentackle.sql.Backend;

public class AttributeImpl
implements Attribute,
Comparable<AttributeImpl> {
    private final EntityFactoryImpl factory;
    private final Entity entity;
    private final SourceInfo sourceInfo;
    private final AttributeOptionsImpl options;
    private final boolean implicit;
    private AttributeLine sourceLine;
    private String javaName;
    private String columnName;
    private DataType dataType;
    private String applicationType;
    private String innerName;
    private Integer size;
    private Integer scale;
    private Boolean nullable;
    private Relation relation;

    public AttributeImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo, boolean implicit) {
        this.factory = factory;
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.implicit = implicit;
        this.options = factory.createAttributeOptions(this, sourceInfo);
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + Objects.hashCode(this.entity);
        hash = 73 * hash + Objects.hashCode(this.javaName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (!Objects.equals(this.entity, other.entity)) {
            return false;
        }
        return Objects.equals(this.javaName, other.javaName);
    }

    @Override
    public int compareTo(AttributeImpl o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int rv = Compare.compare((Comparable)((EntityImpl)this.entity), (Comparable)((EntityImpl)o.entity));
        if (rv == 0) {
            rv = Compare.compare((Comparable)((Object)this.javaName), (Comparable)((Object)o.javaName));
        }
        return rv;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public void parse(Entity entity, AttributeLine line) throws ModelException {
        this.setSourceLine(line);
        this.setColumnName(line.getColumnName());
        this.setJavaName(line.getJavaName());
        this.setScale(line.getScale());
        this.setSize(line.getSize());
        this.setDataType(DataType.createFromJavaType(line.getJavaType()));
        if (this.getDataType() == null) {
            this.setDataType(DataType.APPLICATION);
        }
        this.setInnerName(line.getInnerName());
        if (this.getDataType() == DataType.APPLICATION) {
            this.setApplicationType(line.getJavaType());
            this.getInnerType();
        }
        this.getOptions().applyEntityOptions(entity.getOptions(), this.getDataType());
        this.getOptions().setComment(line.getComment());
        for (String option : line.getOptions()) {
            if (this.getOptions().processOption(option)) continue;
            throw line.createModelException("illegal attribute option: " + option);
        }
        if (this.getOptions().getBindOptions().contains("SIZE")) {
            this.getOptions().removeBindOption("SIZE");
            if (this.getSize() != null && !this.getOptions().getBindOptions().contains("MAXCOL")) {
                this.getOptions().addBindOption("MAXCOL=" + this.getSize());
            }
            if (this.getScale() != null && !this.getOptions().getBindOptions().contains("SCALE")) {
                this.getOptions().addBindOption("SCALE=" + this.getScale());
            }
        }
    }

    public void setApplicationType(String applicationType) throws ModelException {
        if (applicationType != null && this.dataType != DataType.APPLICATION) {
            throw this.createModelException("setting the application specific type is not allowed for " + this);
        }
        this.applicationType = applicationType;
    }

    @Override
    public String getApplicationType() throws ModelException {
        if (this.dataType == DataType.APPLICATION) {
            if (this.applicationType == null || this.applicationType.trim().length() == 0) {
                throw this.createModelException("application specific type not set");
            }
        } else {
            throw this.createModelException("application specific type not supported for " + this);
        }
        return this.applicationType;
    }

    public void setInnerName(String innerType) throws ModelException {
        if (innerType != null && this.dataType != DataType.APPLICATION && this.dataType != DataType.BINARY) {
            throw this.createModelException("setting the inner type is not allowed for " + this);
        }
        this.innerName = innerType;
    }

    @Override
    public String getInnerName() throws ModelException {
        if (this.dataType == DataType.APPLICATION && this.innerName == null) {
            throw this.createModelException("inner type not set for application-specific type '" + this.getApplicationType() + "'");
        }
        if (this.dataType != DataType.APPLICATION && this.dataType != DataType.BINARY) {
            throw this.createModelException("inner type not supported for " + this);
        }
        return this.innerName;
    }

    @Override
    public DataType getInnerType() throws ModelException {
        DataType innerType = DataType.createFromJavaType(this.getInnerName());
        if (innerType == null) {
            throw this.createModelException("illegal inner type: " + this.getInnerName());
        }
        return innerType;
    }

    @Override
    public String getJavaType() throws ModelException {
        StringBuilder buf = new StringBuilder();
        if (this.dataType == DataType.APPLICATION) {
            buf.append(this.getApplicationType());
        } else {
            String genType;
            buf.append(this.dataType.toString());
            if (this.dataType == DataType.BINARY && (genType = this.getInnerName()) != null) {
                buf.append('<');
                buf.append(genType);
                buf.append('>');
            }
        }
        return buf.toString();
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public int getSizeWithDefault() {
        return this.size == null ? 0 : this.size;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public int getScaleWithDefault() {
        return this.scale == null ? 0 : this.scale;
    }

    @Override
    public AttributeOptionsImpl getOptions() {
        return this.options;
    }

    public void setColumnName(String columnName) {
        this.columnName = BasicStringHelper.toLower((String)columnName);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public boolean isNullable() throws ModelException {
        if (this.nullable != null) {
            return this.nullable;
        }
        DataType type = this.getDataType();
        if (type == DataType.APPLICATION) {
            type = this.getInnerType();
        }
        return !type.isPrimitive() && !this.getOptions().isMapNull();
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.getJavaName();
    }

    @Override
    public void validate() throws ModelException {
        if (BasicStringHelper.isAllWhitespace((String)this.getJavaName())) {
            throw this.createModelException("missing Java name");
        }
        if (BasicStringHelper.isReservedWord((String)this.getJavaName())) {
            throw this.createModelException("'" + this.getJavaName() + "' is a reserved Java keyword");
        }
        if (BasicStringHelper.isAllWhitespace((String)this.getColumnName())) {
            throw this.createModelException("missing column name");
        }
        if (this.getColumnName().startsWith("_")) {
            throw this.createModelException("column name '" + this.getColumnName() + "' must not start with an underscore");
        }
        for (Backend backend : this.factory.getBackends()) {
            try {
                backend.assertValidName("column name", this.getColumnName());
            }
            catch (RuntimeException rex) {
                throw new ModelException(rex.getMessage(), this.sourceInfo, (Throwable)rex);
            }
        }
        if (this.dataType == null) {
            throw this.createModelException("missing data type");
        }
        if (this.dataType == DataType.APPLICATION) {
            this.getInnerType();
        }
        if (this.getScale() != null && !this.dataType.isNumeric()) {
            throw this.createModelException("non-numeric type does not support scale");
        }
        this.getOptions().validate();
    }

    @Override
    public AttributeLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(AttributeLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this.sourceInfo);
        return ex;
    }

    @Override
    public String getMethodNameSuffix() {
        return BasicStringHelper.firstToUpper((String)this.javaName);
    }

    @Override
    public String getGetterName() {
        StringBuilder buf = new StringBuilder();
        if (this.getDataType().isBool()) {
            buf.append("is");
        } else {
            buf.append("get");
        }
        buf.append(this.getMethodNameSuffix());
        return buf.toString();
    }

    @Override
    public String getSetterName() {
        return "set" + this.getMethodNameSuffix();
    }

    @Override
    public String getBindableAnnotation() {
        if (this.getOptions().isBind()) {
            String bindOptions = this.getOptions().getBindOptions();
            if (BasicStringHelper.isAllWhitespace((String)bindOptions)) {
                return "@Bindable";
            }
            return "@Bindable(options=\"" + bindOptions + "\")";
        }
        return null;
    }
}

