/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import org.tentackle.model.AccessScope;
import org.tentackle.model.CommonOptions;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;

public abstract class CommonOptionsImpl
implements CommonOptions {
    static final String OPTION_NODECLARE = "NODECLARE";
    static final String OPTION_NOMETHOD = "NOMETHOD";
    static final String OPTION_NOCONSTANT = "NOCONSTANT";
    static final String OPTION_DERIVED = "DERIVED";
    static final String OPTION_SUPER = "SUPER";
    static final String OPTION_READONLY = "READONLY";
    static final String OPTION_WRITEONLY = "WRITEONLY";
    static final String OPTION_TRIM_READ = "TRIMREAD";
    static final String OPTION_TRIM_WRITE = "TRIMWRITE";
    static final String OPTION_TRIM = "TRIM";
    static final String OPTION_MAPNULL = "MAPNULL";
    static final String OPTION_SETGET = "SETGET";
    static final String OPTION_BIND = "BIND";
    static final String BIND_SIZE = "SIZE";
    private final SourceInfo sourceInfo;
    private String comment;
    private StringBuilder bindOptions;
    private boolean noDeclare;
    private boolean noMethod;
    private boolean noConstant;
    private boolean derived;
    private boolean fromSuper;
    private boolean readOnly;
    private boolean writeOnly;
    private AccessScope accessScope;
    private boolean trimRead;
    private boolean trimWrite;
    private boolean mapNull;
    private boolean setGet;
    private boolean bind;
    private boolean upperCase;
    private boolean lowerCase;
    private boolean autoSelect;
    private boolean maxCol;

    public CommonOptionsImpl(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.bindOptions = new StringBuilder();
        this.accessScope = AccessScope.PUBLIC;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean applyOption(String option, Boolean ctrl) {
        String uco;
        String fullopt = uco = option.toUpperCase();
        int ndx = uco.indexOf(61);
        if (ndx > 0) {
            uco = uco.substring(0, ndx);
        }
        boolean on = ctrl == null || ctrl != false;
        boolean applied = true;
        switch (uco) {
            case "NODECLARE": {
                this.setNoDeclare(on);
                break;
            }
            case "NOMETHOD": {
                this.setNoMethod(on);
                break;
            }
            case "NOCONSTANT": {
                this.setNoConstant(on);
                break;
            }
            case "DERIVED": {
                this.setDerived(on);
                break;
            }
            case "SUPER": {
                this.setFromSuper(on);
                break;
            }
            case "READONLY": {
                this.setReadOnly(on);
                break;
            }
            case "WRITEONLY": {
                this.setWriteOnly(on);
                break;
            }
            case "TRIMREAD": {
                this.setTrimRead(on);
                break;
            }
            case "TRIMWRITE": {
                this.setTrimWrite(on);
                break;
            }
            case "TRIM": {
                this.setTrimRead(on);
                this.setTrimWrite(on);
                break;
            }
            case "MAPNULL": {
                this.setMapNull(on);
                break;
            }
            case "SETGET": {
                this.setSetGet(on);
                break;
            }
            case "BIND": {
                this.setBind(on);
                break;
            }
            case "UC": {
                this.setUpperCase(on);
                this.processBindOption(uco, on);
                break;
            }
            case "LC": {
                this.setLowerCase(on);
                this.processBindOption(uco, on);
                break;
            }
            case "AUTOSELECT": {
                this.setAutoSelect(on);
                this.processBindOption(uco, on);
                break;
            }
            case "COL": 
            case "MAXCOL": 
            case "SCALE": {
                this.processBindOption(fullopt, on);
                break;
            }
            case "SIZE": {
                this.setMaxCol(on);
                this.processBindOption(uco, on);
                break;
            }
            default: {
                try {
                    AccessScope scope = AccessScope.valueOf(uco);
                    this.accessScope = on ? scope : AccessScope.PUBLIC;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    applied = false;
                }
            }
        }
        return applied;
    }

    public boolean processOption(String option) {
        boolean applied;
        switch (option.charAt(0)) {
            case '-': {
                applied = this.applyOption(option.substring(1), Boolean.FALSE);
                break;
            }
            case '+': {
                applied = this.applyOption(option.substring(1), Boolean.TRUE);
                break;
            }
            default: {
                applied = this.applyOption(option, null);
            }
        }
        return applied;
    }

    public void processBindOption(String option, boolean on) {
        if (on) {
            this.setBind(true);
            this.addBindOption(option);
        } else {
            this.removeBindOption(option);
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getBindOptions() {
        return this.bindOptions.toString();
    }

    public void setBindOptions(String bindOptions) {
        this.bindOptions = new StringBuilder(bindOptions == null ? "" : bindOptions);
    }

    public void addBindOption(String option) {
        if (this.bindOptions.length() > 0 && this.bindOptions.charAt(this.bindOptions.length() - 1) != ',') {
            this.bindOptions.append(',');
        }
        this.bindOptions.append(option);
    }

    public void removeBindOption(String option) {
        int ndx = this.bindOptions.indexOf(option);
        if (ndx >= 0) {
            int commaIndex;
            this.bindOptions.delete(ndx, ndx + option.length());
            int n = commaIndex = ndx > 0 ? ndx - 1 : 0;
            if (commaIndex < this.bindOptions.length() && this.bindOptions.charAt(commaIndex) == ',') {
                this.bindOptions.deleteCharAt(commaIndex);
            }
        }
    }

    @Override
    public boolean isNoDeclare() {
        return this.noDeclare;
    }

    @Override
    public boolean isNoMethod() {
        return this.noMethod;
    }

    @Override
    public boolean isNoConstant() {
        return this.noConstant;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public boolean isFromSuper() {
        return this.fromSuper;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    @Override
    public AccessScope getAccessScope() {
        return this.accessScope;
    }

    @Override
    public boolean isTrimRead() {
        return this.trimRead;
    }

    @Override
    public boolean isTrimWrite() {
        return this.trimWrite;
    }

    @Override
    public boolean isMapNull() {
        return this.mapNull;
    }

    @Override
    public boolean isSetGet() {
        return this.setGet;
    }

    @Override
    public boolean isBind() {
        return this.bind;
    }

    public void setAccessScope(AccessScope accessScope) {
        this.accessScope = accessScope;
    }

    public void setBind(boolean bind) {
        this.bind = bind;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public void setFromSuper(boolean fromSuper) {
        this.fromSuper = fromSuper;
        if (fromSuper) {
            this.setNoDeclare(true);
            this.setNoMethod(true);
        }
    }

    public void setMapNull(boolean mapNull) {
        this.mapNull = mapNull;
    }

    public void setNoConstant(boolean noConstant) {
        this.noConstant = noConstant;
    }

    public void setNoDeclare(boolean noDeclare) {
        this.noDeclare = noDeclare;
    }

    public void setNoMethod(boolean noMethod) {
        this.noMethod = noMethod;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setSetGet(boolean setGet) {
        this.setGet = setGet;
    }

    public void setTrimRead(boolean trimRead) {
        this.trimRead = trimRead;
    }

    public void setTrimWrite(boolean trimWrite) {
        this.trimWrite = trimWrite;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @Override
    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    @Override
    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    @Override
    public boolean isMaxCol() {
        return this.maxCol;
    }

    public void setMaxCol(boolean maxCol) {
        this.maxCol = maxCol;
    }

    @Override
    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    @Override
    public void validate() throws ModelException {
        if (this.accessScope == null) {
            throw this.createModelException("missing access scope");
        }
        if (this.lowerCase && this.upperCase) {
            throw this.createModelException("only one of LC or UC may be set");
        }
    }

    public ModelException createModelException(String message) {
        return new ModelException(message);
    }
}

