/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.IndexAttributeImpl;
import org.tentackle.model.parser.ConfigurationLine;
import org.tentackle.sql.Backend;

public class IndexImpl
implements Index {
    private final Entity entity;
    private final EntityFactoryImpl factory;
    private final SourceInfo sourceInfo;
    private final List<IndexAttribute> attributes;
    private ConfigurationLine sourceLine;
    private String name;
    private String comment;
    private boolean unique;
    private String filterCondition;

    public IndexImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo) {
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.factory = factory;
        this.attributes = new ArrayList<IndexAttribute>();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public void parse(Entity entity, ConfigurationLine line) throws ModelException {
        StringTokenizer stok = new StringTokenizer(line.getKey());
        boolean indexFound = false;
        boolean uniqueFound = false;
        block8: while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            switch (token.toLowerCase()) {
                case "index": {
                    this.setSourceLine(line);
                    this.setUnique(uniqueFound);
                    indexFound = true;
                    uniqueFound = false;
                    continue block8;
                }
                case "unique": {
                    if (indexFound) {
                        throw line.createModelException("keyword 'unique' not allowed after 'index'");
                    }
                    uniqueFound = true;
                    continue block8;
                }
            }
            if (!indexFound) {
                throw line.createModelException("unknown configuration keyword: " + token);
            }
            int ndx = token.indexOf(46);
            if (ndx > 0) {
                token = token.substring(ndx + 1);
            }
            this.setName(token);
        }
        if (!indexFound) {
            throw line.createModelException("illegal configuration: " + line.getKey());
        }
        if (entity.getAttributes().isEmpty()) {
            throw line.createModelException("index configuration line not allowed before attribute section");
        }
        String text = line.getValue();
        int ndx = text.indexOf(124);
        if (ndx > 0) {
            this.setFilterCondition(text.substring(ndx + 1));
            text = text.substring(0, ndx);
        } else {
            ndx = text.toUpperCase().indexOf("WHERE");
            if (ndx > 0) {
                this.setFilterCondition(text.substring(ndx + 5));
                text = text.substring(0, ndx);
            }
        }
        stok = new StringTokenizer(text, " \t,");
        IndexAttributeImpl indexAttribute = null;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (token.toLowerCase().equals("desc")) {
                if (indexAttribute == null) {
                    throw line.createModelException("keyword 'desc' must follow column name");
                }
                indexAttribute.setDescending(true);
                continue;
            }
            if (token.toLowerCase().equals("asc")) {
                if (indexAttribute == null) {
                    throw line.createModelException("keyword 'asc' must follow column name");
                }
                indexAttribute.setDescending(false);
                continue;
            }
            if (indexAttribute != null) {
                this.getAttributes().add(indexAttribute);
                indexAttribute = null;
            }
            Boolean descending = null;
            if (token.startsWith("+")) {
                descending = Boolean.FALSE;
                token = token.substring(1);
            }
            if (token.startsWith("-")) {
                descending = Boolean.TRUE;
                token = token.substring(1);
            }
            for (Attribute attribute : entity.getAttributes()) {
                if (!attribute.getColumnName().equals(token)) continue;
                indexAttribute = this.factory.createIndexAttribute(this, this.sourceInfo);
                indexAttribute.setAttribute(attribute);
                if (descending == null) break;
                indexAttribute.setDescending(descending);
                break;
            }
            if (indexAttribute != null) continue;
            throw line.createModelException("undefined column name: " + token);
        }
        if (indexAttribute != null) {
            this.getAttributes().add(indexAttribute);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(Entity entity) {
        return entity.getTableNameWithoutSchema() + "_" + this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @Override
    public List<IndexAttribute> getAttributes() {
        return this.attributes;
    }

    public void setName(String name) {
        this.name = BasicStringHelper.toLower((String)name);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = BasicStringHelper.isAllWhitespace((String)filterCondition) ? null : filterCondition.trim();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void validate() throws ModelException {
        if (BasicStringHelper.isAllWhitespace((String)this.getName())) {
            throw this.createModelException("missing index name");
        }
        for (Backend backend : this.factory.getBackends()) {
            try {
                backend.assertValidName("index name", this.getName(this.entity));
            }
            catch (RuntimeException rex) {
                throw new ModelException(rex.getMessage(), this.sourceInfo, (Throwable)rex);
            }
        }
        if (this.getAttributes().isEmpty()) {
            throw this.createModelException("index " + this + " does not contain any attributes");
        }
    }

    @Override
    public ConfigurationLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(ConfigurationLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this.entity);
        return ex;
    }

    @Override
    public String sqlCreateIndex(Backend backend, Entity entity) {
        StringBuilder buf = new StringBuilder();
        if (this.getComment() != null) {
            buf.append("-- ");
            buf.append(this.getComment());
            buf.append('\n');
        }
        String[] columnNames = new String[this.getAttributes().size()];
        int attributeCount = 0;
        for (IndexAttribute indexAttribute : this.getAttributes()) {
            columnNames[attributeCount] = indexAttribute.isDescending() ? "-" + indexAttribute.getAttribute().getColumnName() : indexAttribute.getAttribute().getColumnName();
            ++attributeCount;
        }
        buf.append(backend.sqlCreateIndex(entity.getTableName(), this.getName(entity), this.isUnique(), this.getFilterCondition(), columnNames));
        return buf.toString();
    }
}

