/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.common.Compare;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.EntityImpl;
import org.tentackle.model.parser.RelationLine;

public class RelationImpl
implements Relation,
Comparable<RelationImpl> {
    static final String DEFAULT = "DEFAULT";
    static final String RELATION = "RELATION";
    static final String SELECT = "SELECT";
    static final String DELETE = "DELETE";
    static final String LINK = "LINK";
    static final String ARGS = "ARGS";
    static final String NM = "NM";
    static final String METHOD = "METHOD";
    static final String NAME = "NAME";
    static final String SCOPE = "SCOPE";
    static final String COMMENT = "COMMENT";
    static final String COMPOSITE = "COMPOSITE";
    static final String TRACKED = "TRACKED";
    static final String REFERENCED = "REFERENCED";
    static final String PROCESSED = "PROCESSED";
    static final String READONLY = "READONLY";
    static final String WRITEONLY = "WRITEONLY";
    static final String NOMETHOD = "NOMETHOD";
    static final String SERIALIED = "SERIALIZED";
    static final String REMOTECLEAR = "REMOTECLEAR";
    static final String REVERSED = "REVERSED";
    static final String CACHED = "CACHED";
    static final String MAIN = "MAIN";
    static final String CASCADE = "CASCADE";
    static final String INDEXED = "INDEXED";
    private final Entity entity;
    private final SourceInfo sourceInfo;
    private List<String> annotations;
    private RelationLine sourceLine;
    private String name;
    private String comment;
    private String className;
    private RelationType relationType;
    private AccessScope accessScope;
    private boolean composite;
    private boolean tracked;
    private boolean referenced;
    private boolean processed;
    private boolean readOnly;
    private boolean writeOnly;
    private boolean serialized;
    private boolean clearOnRemoteSave;
    private boolean reversed;
    private SelectionType selectionType;
    private boolean selectionCached;
    private boolean selectionFromMainClass;
    private String selectionWurbletArguments;
    private String methodName;
    private List<String> methodArgs;
    private String nmName;
    private String nmMethodName;
    private String linkMethodName;
    private String linkMethodIndex;
    private boolean deletionFromMainClass;
    private boolean deletionCascaded;
    private Entity foreignEntity;
    private Attribute attribute;
    private Attribute foreignAttribute;
    private Relation foreignRelation;
    private Relation nmRelation;
    private Relation definingNmRelation;
    private boolean deepReference;

    public RelationImpl(Entity entity, SourceInfo sourceInfo) {
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.annotations = new ArrayList<String>();
        this.methodArgs = new ArrayList<String>();
        this.accessScope = AccessScope.PUBLIC;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.entity);
        hash = 31 * hash + Objects.hashCode(this.name);
        hash = 31 * hash + Objects.hashCode(this.foreignEntity);
        hash = 31 * hash + Objects.hashCode(this.attribute);
        hash = 31 * hash + Objects.hashCode(this.foreignAttribute);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationImpl other = (RelationImpl)obj;
        if (!Objects.equals(this.entity, other.entity)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.foreignEntity, other.foreignEntity)) {
            return false;
        }
        if (!Objects.equals(this.attribute, other.attribute)) {
            return false;
        }
        return Objects.equals(this.foreignAttribute, other.foreignAttribute);
    }

    @Override
    public int compareTo(RelationImpl o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int rv = Compare.compare((Comparable)((EntityImpl)this.entity), (Comparable)((EntityImpl)o.entity));
        if (rv == 0 && (rv = Compare.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name))) == 0 && (rv = Compare.compare((Comparable)((EntityImpl)this.foreignEntity), (Comparable)((EntityImpl)o.foreignEntity))) == 0 && (rv = Compare.compare((Comparable)((AttributeImpl)this.attribute), (Comparable)((AttributeImpl)o.attribute))) == 0) {
            rv = Compare.compare((Comparable)((AttributeImpl)this.foreignAttribute), (Comparable)((AttributeImpl)o.foreignAttribute));
        }
        return rv;
    }

    public void parse(Entity entity, RelationLine line) throws ModelException {
        this.setSourceLine(line);
        this.setClassName(line.getClassName());
        block72: for (Map.Entry<String, String> entry : line.getProperties().entrySet()) {
            String prop = entry.getKey();
            if (prop.startsWith("@")) {
                this.getAnnotations().add(prop);
                continue;
            }
            StringTokenizer stok = new StringTokenizer(entry.getValue());
            switch (prop.toUpperCase()) {
                case "DEFAULT": {
                    continue block72;
                }
                case "RELATION": {
                    String token;
                    block73: while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        switch (token.toUpperCase()) {
                            case "COMPOSITE": {
                                this.setComposite(true);
                                continue block73;
                            }
                            case "TRACKED": {
                                this.setTracked(true);
                                continue block73;
                            }
                            case "REFERENCED": {
                                this.setReferenced(true);
                                continue block73;
                            }
                            case "PROCESSED": {
                                this.setProcessed(true);
                                continue block73;
                            }
                            case "READONLY": {
                                this.setReadOnly(true);
                                continue block73;
                            }
                            case "WRITEONLY": {
                                this.setWriteOnly(true);
                                continue block73;
                            }
                            case "NOMETHOD": {
                                this.setReadOnly(true);
                                this.setWriteOnly(true);
                                continue block73;
                            }
                            case "SERIALIZED": {
                                this.setSerialized(true);
                                continue block73;
                            }
                            case "REMOTECLEAR": {
                                this.setClearOnRemoteSave(true);
                                continue block73;
                            }
                            case "REVERSED": {
                                this.setReversed(true);
                                continue block73;
                            }
                        }
                        try {
                            this.setRelationType(RelationType.valueOf(token.toUpperCase()));
                        }
                        catch (IllegalArgumentException ex) {
                            throw this.createModelException("illegal keyword in relation property: " + token);
                        }
                    }
                    continue block72;
                }
                case "SELECT": {
                    String token;
                    block74: while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        switch (token.toUpperCase()) {
                            case "MAIN": {
                                this.setSelectionFromMainClass(true);
                                continue block74;
                            }
                            case "CACHED": {
                                this.setSelectionCached(true);
                                continue block74;
                            }
                        }
                        try {
                            this.setSelectionType(SelectionType.valueOf(token.toUpperCase()));
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.selectionWurbletArguments == null) {
                                this.selectionWurbletArguments = token;
                                continue;
                            }
                            this.selectionWurbletArguments = this.selectionWurbletArguments + " " + token;
                        }
                    }
                    continue block72;
                }
                case "DELETE": {
                    String token;
                    block75: while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        switch (token.toUpperCase()) {
                            case "MAIN": {
                                this.setDeletionFromMainClass(true);
                                continue block75;
                            }
                            case "CASCADE": {
                                this.setDeletionCascaded(true);
                                continue block75;
                            }
                        }
                        throw this.createModelException("illegal keyword in delete property: " + token);
                    }
                    continue block72;
                }
                case "LINK": {
                    String token;
                    while (stok.hasMoreTokens()) {
                        token = stok.nextToken();
                        if (this.linkMethodName == null) {
                            this.setLinkMethodName(token);
                            continue;
                        }
                        if (this.linkMethodIndex == null) {
                            this.setLinkMethodIndex(token);
                            continue;
                        }
                        throw this.createModelException("illegal keyword in link property: " + token);
                    }
                    continue block72;
                }
                case "ARGS": {
                    while (stok.hasMoreTokens()) {
                        this.getMethodArgs().add(stok.nextToken());
                    }
                    continue block72;
                }
                case "METHOD": {
                    this.setMethodName(entry.getValue());
                    continue block72;
                }
                case "NM": {
                    this.setNmName(stok.nextToken());
                    if (!stok.hasMoreTokens()) continue block72;
                    this.setNmMethodName(stok.nextToken());
                    continue block72;
                }
                case "NAME": {
                    this.setName(entry.getValue());
                    continue block72;
                }
                case "SCOPE": {
                    try {
                        this.setAccessScope(AccessScope.valueOf(entry.getValue().toUpperCase()));
                        continue block72;
                    }
                    catch (IllegalArgumentException ex) {
                        throw this.createModelException("illegal keyword in scope property: " + entry.getValue());
                    }
                }
                case "COMMENT": {
                    this.setComment(entry.getValue());
                    continue block72;
                }
            }
            throw this.createModelException("unknown property: " + prop);
        }
        if (this.methodArgs.isEmpty()) {
            if (this.getRelationType() == RelationType.LIST) {
                this.methodArgs.add("getId()");
            } else {
                this.methodArgs.add(this.buildName(true) + "Id");
            }
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    @Override
    public String getGetterSetterComment() {
        StringBuilder buf = new StringBuilder();
        if (this.reversed) {
            buf.append("reversed as 1:1 from ").append(this.entity);
        } else {
            buf.append(this.getVariableName());
        }
        if (this.deepReference) {
            buf.append(" deeply");
        }
        buf.append(" via ");
        if (this.attribute != null || this.foreignAttribute != null) {
            if (this.attribute != null) {
                buf.append(this.attribute);
            } else {
                buf.append(this.foreignEntity).append('#');
                if (this.foreignAttribute != null) {
                    buf.append(this.foreignAttribute);
                } else {
                    buf.append('?');
                }
            }
        } else {
            buf.append('?');
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.reversed) {
            buf.append(this.entity).append(": ");
        }
        if (this.composite) {
            buf.append("composite ");
        }
        if (this.getRelationType() == RelationType.LIST && !this.reversed) {
            buf.append("list of ");
        }
        if (this.foreignEntity != null) {
            buf.append(this.foreignEntity).append(" ");
            buf.append(this.getGetterSetterComment());
        } else {
            buf.append('?').append(this.getName()).append('?');
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            buf.append(" (").append(this.comment).append(')');
        }
        return buf.toString();
    }

    @Override
    public void validate() throws ModelException {
        this.getRelationType();
        if (this.className == null) {
            throw this.createModelException("missing classname");
        }
        if (this.accessScope == null) {
            throw this.createModelException("missing access scope");
        }
        if (this.selectionType == null) {
            SelectionType selectionType = this.selectionType = this.selectionCached ? SelectionType.ALWAYS : SelectionType.LAZY;
        }
        if (this.composite && this.selectionType != SelectionType.LAZY && this.selectionType != SelectionType.EAGER) {
            throw this.createModelException("composite relations must be eager or lazy");
        }
        if (this.reversed && (this.composite || this.relationType != RelationType.LIST)) {
            throw this.createModelException("reversed 1:1 mapping only allowed for non-composite list relations");
        }
        if (this.relationType == RelationType.LIST) {
            if (this.selectionCached) {
                throw this.createModelException("cached select is not allowed for list relations");
            }
            if (this.deletionCascaded && !this.composite) {
                throw this.createModelException("cascaded delete is not allowed for non-composite list relations");
            }
        } else {
            if (this.linkMethodIndex != null) {
                throw this.createModelException("indexed link method is not allowed for object relations");
            }
            if (this.deletionCascaded) {
                throw this.createModelException("object relations are always deleted cascaded");
            }
            if (this.linkMethodName != null && !this.referenced) {
                throw this.createModelException("object relations with link= option must be referenced");
            }
        }
        if (this.composite && this.selectionCached) {
            throw this.createModelException("cached select is not allowed for composite relations");
        }
        if (this.processed && !this.composite) {
            throw this.createModelException("processed only allowed for composite relations");
        }
        if (this.serialized && (this.isComposite() || this.selectionType != SelectionType.LAZY && this.selectionType != SelectionType.EAGER)) {
            throw this.createModelException("serialized is only allowed for lazy or eager non-composite relations");
        }
        if (!(this.nmName == null || this.composite && this.relationType != RelationType.OBJECT)) {
            throw this.createModelException("nm-relations must be composite lists");
        }
        if (this.selectionWurbletArguments != null && this.relationType != RelationType.LIST) {
            throw this.createModelException("extra wurblet arguments are only allowed for list relations (in select property): " + this.selectionWurbletArguments);
        }
    }

    @Override
    public String getName() {
        return this.name == null ? BasicStringHelper.firstToLower((String)this.className) : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RelationLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(RelationLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this.entity);
        return ex;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public RelationType getRelationType() {
        if (this.relationType == null) {
            this.relationType = this.reversed ? RelationType.LIST : RelationType.OBJECT;
        }
        return this.relationType;
    }

    @Override
    public AccessScope getAccessScope() {
        return this.accessScope;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Entity getForeignEntity() {
        return this.foreignEntity;
    }

    @Override
    public Attribute getForeignAttribute() {
        return this.foreignAttribute;
    }

    @Override
    public Relation getForeignRelation() {
        return this.foreignRelation;
    }

    @Override
    public Relation getNmRelation() {
        return this.nmRelation;
    }

    @Override
    public Relation getDefiningNmRelation() {
        return this.definingNmRelation;
    }

    @Override
    public boolean isComposite() {
        return this.composite;
    }

    @Override
    public boolean isTracked() {
        return this.tracked;
    }

    @Override
    public boolean isReferenced() {
        return this.referenced;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    @Override
    public boolean isSerialized() {
        return this.serialized;
    }

    @Override
    public boolean isClearOnRemoteSave() {
        return this.clearOnRemoteSave;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<String> getMethodArgs() {
        return this.methodArgs;
    }

    @Override
    public String getNmName() {
        return this.nmName;
    }

    @Override
    public String getNmMethodName() {
        return this.nmMethodName;
    }

    @Override
    public String getLinkMethodName() {
        return this.linkMethodName;
    }

    @Override
    public String getLinkMethodIndex() {
        return this.linkMethodIndex;
    }

    @Override
    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    @Override
    public boolean isSelectionFromMainClass() {
        return this.selectionFromMainClass;
    }

    @Override
    public boolean isSelectionCached() {
        return this.selectionCached;
    }

    @Override
    public String getSelectionWurbletArguments() {
        return this.selectionWurbletArguments;
    }

    @Override
    public boolean isDeletionFromMainClass() {
        return this.deletionFromMainClass;
    }

    @Override
    public boolean isDeletionCascaded() {
        return this.deletionCascaded;
    }

    public void setNmRelation(Relation nmRelation) {
        this.nmRelation = nmRelation;
    }

    public void setDefiningNmRelation(Relation definingNmRelation) {
        this.definingNmRelation = definingNmRelation;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public void setForeignEntity(Entity foreignEntity) {
        this.foreignEntity = foreignEntity;
    }

    public void setForeignAttribute(Attribute foreignAttribute) {
        this.foreignAttribute = foreignAttribute;
    }

    public void setForeignRelation(Relation foreignRelation) {
        this.foreignRelation = foreignRelation;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public void setLinkMethodName(String linkMethodName) {
        this.linkMethodName = linkMethodName;
    }

    public void setMethodArgs(List<String> methodArgs) {
        this.methodArgs = methodArgs;
    }

    public void setNmName(String nmName) {
        this.nmName = nmName;
    }

    public void setNmMethodName(String nmMethodName) {
        this.nmMethodName = nmMethodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setReferenced(boolean referenced) {
        this.referenced = referenced;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setRelationType(RelationType relationType) {
        this.relationType = relationType;
    }

    public void setSerialized(boolean serialized) {
        this.serialized = serialized;
    }

    public void setClearOnRemoteSave(boolean clearOnRemoteSave) {
        this.clearOnRemoteSave = clearOnRemoteSave;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void setTracked(boolean tracked) {
        this.tracked = tracked;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public void setSelectionCached(boolean selectionCached) {
        this.selectionCached = selectionCached;
    }

    public void setSelectionFromMainClass(boolean selectionFromMainClass) {
        this.selectionFromMainClass = selectionFromMainClass;
    }

    public void setSelectionWurbletArguments(String selectionWurbletArguments) {
        this.selectionWurbletArguments = selectionWurbletArguments;
    }

    public void setAccessScope(AccessScope accessScope) {
        this.accessScope = accessScope;
    }

    public void setDeletionCascaded(boolean deletionCascaded) {
        this.deletionCascaded = deletionCascaded;
    }

    public void setDeletionFromMainClass(boolean deletionFromMainClass) {
        this.deletionFromMainClass = deletionFromMainClass;
    }

    public void setLinkMethodIndex(String linkMethodIndex) {
        this.linkMethodIndex = linkMethodIndex;
    }

    private String buildName(boolean tolower) {
        String str = this.name == null ? this.className : this.name;
        str = tolower ? BasicStringHelper.firstToLower((String)str) : BasicStringHelper.firstToUpper((String)str);
        if (this.getRelationType() == RelationType.LIST && !this.reversed && this.name == null) {
            str = str + "List";
        }
        return str;
    }

    @Override
    public String getVariableName() {
        return this.buildName(true);
    }

    @Override
    public String getMethodNameSuffix() {
        return this.buildName(false);
    }

    @Override
    public String getGetterName() {
        return "get" + this.getMethodNameSuffix();
    }

    @Override
    public String getSetterName() {
        return "set" + this.getMethodNameSuffix();
    }

    @Override
    public String getDeclaredJavaType() {
        String type = this.getClassName();
        if (this.getForeignEntity().isAbstract()) {
            type = type + "<?>";
        }
        if (this.getRelationType() == RelationType.LIST && !this.reversed) {
            return (this.isTracked() ? "TrackedList" : "List") + "<" + type + ">";
        }
        return type;
    }

    @Override
    public String getJavaType() {
        if (this.getRelationType() == RelationType.LIST && !this.reversed) {
            return (this.isTracked() ? "TrackedArrayList" : "ArrayList") + "<>";
        }
        return this.getClassName();
    }

    @Override
    public boolean isDeepReference() {
        return this.deepReference;
    }

    public void setDeepReference(boolean deepReference) {
        this.deepReference = deepReference;
    }
}

