/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parser;

import org.tentackle.model.ModelException;
import org.tentackle.model.parser.Document;
import org.tentackle.model.parser.LineType;
import org.tentackle.model.parser.SingleLine;

public class ConfigurationLine
extends SingleLine {
    private String key;
    private String value;

    public ConfigurationLine(Document document, int offset, LineType lineType) {
        super(document, offset, lineType);
    }

    @Override
    public void parse() throws ModelException {
        super.parse();
        String[] tokens = this.getText().split(":=", 2);
        if (tokens.length != 2) {
            throw this.createModelException("misconfigured configuration line");
        }
        this.key = tokens[0].trim();
        this.value = tokens[1].trim();
    }

    public String getKey() throws ModelException {
        this.assertParsed();
        return this.key;
    }

    public String getValue() throws ModelException {
        this.assertParsed();
        return this.value;
    }
}

