/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.model.ModelException;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.parser.Line;
import org.tentackle.model.parser.LineType;

public class Document {
    private final String text;
    private final SourceInfo sourceInfo;
    private int offset;
    private List<Line> parsedLines;

    public Document(String text) {
        if (text == null) {
            throw new NullPointerException("document text cannot be null");
        }
        if (text.startsWith("#@")) {
            int ndx = text.indexOf(10);
            if (ndx > 0) {
                String firstLine = text.substring(2, ndx);
                text = text.substring(ndx + 1);
                ndx = firstLine.lastIndexOf(58);
                this.sourceInfo = ndx > 0 ? new SourceInfo(firstLine.substring(0, ndx), Integer.parseInt(firstLine.substring(ndx + 1)) + 1) : new SourceInfo(firstLine);
            } else {
                this.sourceInfo = null;
            }
        } else {
            this.sourceInfo = null;
        }
        this.text = this.processContinuationLines(text);
    }

    public String getText() {
        return this.text;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public List<Line> getLines() throws ModelException {
        if (this.parsedLines == null) {
            this.parsedLines = this.parse();
        }
        return this.parsedLines;
    }

    public int getLineNumber(int offsetInDocument) {
        int lineNumber = 1;
        for (int ndx = 0; ndx < offsetInDocument && (ndx = this.text.indexOf(10, ndx)) >= 0; ++ndx) {
            ++lineNumber;
        }
        return lineNumber;
    }

    protected List<Line> parse() throws ModelException {
        ArrayList<Line> lines = new ArrayList<Line>();
        Line line = null;
        while ((line = this.nextLine(line)) != null) {
            line.parse();
            lines.add(line);
        }
        return lines;
    }

    protected Line nextLine(Line currentLine) throws ModelException {
        this.offset = currentLine == null ? 0 : (this.offset += currentLine.getLength() + 1);
        if (this.offset < this.text.length()) {
            String lineText;
            String trimmedLine;
            int lineEnd = this.text.indexOf(10, this.offset);
            if (lineEnd == -1) {
                lineEnd = this.text.length();
            }
            if ((trimmedLine = (lineText = this.text.substring(this.offset, lineEnd)).trim()).length() == 0) {
                return LineType.EMPTY.createLine(this, this.offset);
            }
            char firstChar = trimmedLine.charAt(0);
            if (firstChar == '#') {
                return LineType.COMMENT.createLine(this, this.offset);
            }
            if (firstChar == '[') {
                return LineType.GLOBAL_OPTION.createLine(this, this.offset);
            }
            int colonIndex = lineText.indexOf(58);
            int equalsIndex = lineText.indexOf(61);
            if (colonIndex > 0 && colonIndex == equalsIndex - 1) {
                return LineType.CONFIGURATION.createLine(this, this.offset);
            }
            StringTokenizer stok = new StringTokenizer(lineText, " \t\r\f:=");
            if (stok.hasMoreTokens()) {
                String firstWord = stok.nextToken();
                int secondWordIndex = -1;
                String secondWord = null;
                if (stok.hasMoreTokens()) {
                    secondWord = stok.nextToken();
                    secondWordIndex = lineText.indexOf(secondWord);
                }
                if (colonIndex == -1 || secondWordIndex > 0 && colonIndex > secondWordIndex) {
                    return LineType.ATTRIBUTE.createLine(this, this.offset);
                }
                if (Character.isUpperCase(firstWord.charAt(0))) {
                    if (secondWord != null && secondWord.charAt(0) == '@') {
                        return LineType.RELATION_OPTION.createLine(this, this.offset);
                    }
                    return LineType.RELATION.createLine(this, this.offset);
                }
                if (secondWord != null) {
                    return LineType.ATTRIBUTE_OPTION.createLine(this, this.offset);
                }
            }
            throw new ModelException("cannot determine line type", this.getSourceInfo().add(this.getLineNumber(this.offset) - 1, 0));
        }
        return null;
    }

    private String processContinuationLines(String text) {
        StringBuilder buf = new StringBuilder(text.length());
        int lastBackslashIndex = -1;
        for (int pos = 0; pos < text.length(); ++pos) {
            char c = text.charAt(pos);
            if (c == '\n' && lastBackslashIndex >= 0) {
                buf.delete(lastBackslashIndex, buf.length());
                continue;
            }
            if (c == '\\') {
                lastBackslashIndex = buf.length();
            } else if (c != ' ') {
                lastBackslashIndex = -1;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

