/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.parser;

import org.tentackle.model.parser.AttributeLine;
import org.tentackle.model.parser.CommentLine;
import org.tentackle.model.parser.ConfigurationLine;
import org.tentackle.model.parser.Document;
import org.tentackle.model.parser.EmptyLine;
import org.tentackle.model.parser.GlobalOptionLine;
import org.tentackle.model.parser.Line;
import org.tentackle.model.parser.OptionLine;
import org.tentackle.model.parser.RelationLine;

public enum LineType {
    EMPTY,
    COMMENT,
    CONFIGURATION,
    GLOBAL_OPTION,
    ATTRIBUTE,
    ATTRIBUTE_OPTION,
    RELATION,
    RELATION_OPTION;


    public Line createLine(Document document, int offset) {
        switch (this) {
            case EMPTY: {
                return new EmptyLine(document, offset, this);
            }
            case COMMENT: {
                return new CommentLine(document, offset, this);
            }
            case CONFIGURATION: {
                return new ConfigurationLine(document, offset, this);
            }
            case GLOBAL_OPTION: {
                return new GlobalOptionLine(document, offset, this);
            }
            case ATTRIBUTE_OPTION: 
            case RELATION_OPTION: {
                return new OptionLine(document, offset, this);
            }
            case ATTRIBUTE: {
                return new AttributeLine(document, offset, this);
            }
            case RELATION: {
                return new RelationLine(document, offset, this);
            }
        }
        throw new IllegalArgumentException("unimplemented line type");
    }
}

