/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;

public class IndexMigrator {
    private final Backend backend;
    private final Entity entity;
    private final Index index;
    private final IndexMetaData indexMetaData;

    public IndexMigrator(Entity entity, Index index, Backend backend, IndexMetaData indexMetaData) {
        this.backend = backend;
        this.entity = entity;
        this.index = index;
        this.indexMetaData = indexMetaData;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Index getIndex() {
        return this.index;
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public Result migrate() {
        StringBuilder dropSql = new StringBuilder();
        StringBuilder createSql = new StringBuilder();
        if (this.indexMetaData == null) {
            createSql.append(this.createIndex());
        } else if (this.index == null) {
            dropSql.append(this.dropIndex());
        } else {
            boolean changed;
            boolean bl = changed = this.index.isUnique() != this.indexMetaData.isUnique();
            if (!changed) {
                String modelFilter = this.index.getFilterCondition();
                if (StringHelper.isAllWhitespace((String)modelFilter)) {
                    modelFilter = "";
                } else {
                    if (!(modelFilter = modelFilter.trim().toUpperCase()).startsWith("(")) {
                        modelFilter = "(" + modelFilter + ")";
                    }
                    modelFilter = modelFilter.replace(" ", "");
                }
                String currentFilter = this.indexMetaData.getFilterCondition();
                if (StringHelper.isAllWhitespace((String)currentFilter)) {
                    currentFilter = "";
                } else {
                    if (!(currentFilter = currentFilter.trim().toUpperCase()).startsWith("(")) {
                        currentFilter = "(" + currentFilter + ")";
                    }
                    currentFilter = currentFilter.replace(" ", "");
                }
                boolean bl2 = changed = !modelFilter.equals(currentFilter);
            }
            if (!changed) {
                if (this.index.getAttributes().size() == this.indexMetaData.getColumns().size()) {
                    for (int position = 0; position < this.index.getAttributes().size(); ++position) {
                        IndexAttribute indexAttribute = this.index.getAttributes().get(position);
                        IndexColumnMetaData indexColumn = (IndexColumnMetaData)this.indexMetaData.getColumns().get(position);
                        if (indexAttribute.isDescending() == indexColumn.isDescending() && indexAttribute.getAttribute().getColumnName().equals(indexColumn.getColumnName())) continue;
                        changed = true;
                        break;
                    }
                } else {
                    changed = true;
                }
            }
            if (changed) {
                dropSql.append(this.dropIndex());
                createSql.append(this.createIndex());
            }
        }
        return new Result(dropSql.toString(), createSql.toString());
    }

    private String createIndex() {
        return this.index.sqlCreateIndex(this.backend, this.entity);
    }

    private String dropIndex() {
        return this.backend.sqlDropIndex(this.indexMetaData.getTableMetaData().getSchemaName(), this.indexMetaData.getTableMetaData().getTableName(), this.indexMetaData.getIndexName());
    }

    public static class Result {
        private final String dropSql;
        private final String createSql;

        public Result(String dropSql, String createSql) {
            this.dropSql = dropSql;
            this.createSql = createSql;
        }

        public String getDropSql() {
            return this.dropSql;
        }

        public String getCreateSql() {
            return this.createSql;
        }

        public Result sum(Result result) {
            return new Result(this.dropSql + result.dropSql, this.createSql + result.createSql);
        }
    }
}

