/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.ModelException;
import org.tentackle.model.print.AttributeOptionsPrinter;
import org.tentackle.model.print.PrintConfiguration;

public class AttributePrinter {
    private final Attribute attribute;
    private final PrintConfiguration configuration;
    private String printedType;
    private String printedComment;

    public AttributePrinter(Attribute attribute, PrintConfiguration configuration) {
        this.attribute = attribute;
        this.configuration = configuration;
    }

    public String printType() {
        if (this.printedType == null) {
            StringBuilder buf = new StringBuilder();
            try {
                buf.append(this.attribute.getJavaType());
                if (this.attribute.getDataType() == DataType.APPLICATION) {
                    buf.append('<').append(this.attribute.getInnerName()).append('>');
                }
                if (this.attribute.getSize() != null || this.attribute.getScale() != null) {
                    buf.append('(');
                    if (this.attribute.getSize() != null) {
                        buf.append(this.attribute.getSize());
                    }
                    if (this.attribute.getScale() != null) {
                        buf.append(',').append(this.attribute.getScale());
                    }
                    buf.append(')');
                }
            }
            catch (ModelException mx) {
                buf.append('<').append(mx.getMessage()).append('>');
            }
            this.printedType = buf.toString();
        }
        return this.printedType;
    }

    public String printJavaName() {
        return this.attribute.getName();
    }

    public String printColumnName() {
        return this.attribute.getColumnName();
    }

    public String printComment() {
        if (this.printedComment == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.attribute.getOptions().getComment());
            String options = new AttributeOptionsPrinter(this.attribute, this.configuration).print();
            if (!options.isEmpty()) {
                buf.append(" [").append(options).append(']');
            }
            this.printedComment = buf.toString();
        }
        return this.printedComment;
    }
}

