/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.tentackle.common.Compare;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Integrity;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.NameVerifier;
import org.tentackle.model.Relation;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.AttributeImpl;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.EntityOptionsImpl;
import org.tentackle.model.impl.IndexImpl;
import org.tentackle.model.parse.ConfigurationLine;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlNameType;

public class EntityImpl
implements Entity,
Comparable<EntityImpl> {
    static final String NAME = "NAME";
    static final String ID = "ID";
    static final String TABLE = "TABLE";
    static final String ALIAS = "ALIAS";
    static final String INTEGRITY = "INTEGRITY";
    static final String INHERITANCE = "INHERITANCE";
    static final String EXTENDS = "EXTENDS";
    static final String COMMENT = "COMMENT";
    private final EntityFactoryImpl factory;
    private final SourceInfo sourceInfo;
    private String name;
    private int ordinal;
    private int classId;
    private String tableName;
    private String schemaName;
    private String tableNameWithoutSchema;
    private String tableAlias;
    private String definedTableAlias;
    private Integrity integrity;
    private InheritanceType inheritanceType;
    private String superEntityName;
    private Entity superEntity;
    private final List<Entity> subEntities;
    private final EntityOptionsImpl options;
    private final List<Attribute> attributes;
    private Attribute contextIdAttribute;
    private List<Attribute> uniqueDomainKey;
    private List<AttributeSorting> sorting;
    private final List<Relation> relations;
    private final List<Relation> referencingRelations;
    private final List<Index> indexes;
    private final Set<List<Relation>> compositePaths;
    private Set<List<Relation>> allCompositePaths;
    private final List<Relation> deepReferencesToComponents;
    private final List<Relation> deepReferences;
    private boolean deeplyReferenced;
    private Boolean rootEntity;
    private boolean modelRoot;
    private boolean modelRootId;
    private boolean modelRootClassId;

    public EntityImpl(EntityFactoryImpl factory, SourceInfo sourceInfo) {
        this.factory = factory;
        this.sourceInfo = sourceInfo;
        this.integrity = Integrity.NONE;
        this.inheritanceType = InheritanceType.NONE;
        this.options = factory.createEntityOptions(this, sourceInfo);
        this.attributes = new ArrayList<Attribute>();
        this.relations = new ArrayList<Relation>();
        this.referencingRelations = new ArrayList<Relation>();
        this.subEntities = new ArrayList<Entity>();
        this.compositePaths = new LinkedHashSet<List<Relation>>();
        this.deepReferences = new ArrayList<Relation>();
        this.deepReferencesToComponents = new ArrayList<Relation>();
        this.indexes = new ArrayList<Index>();
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public ModelElement getParent() {
        return this.getSuperEntity();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityImpl other = (EntityImpl)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(EntityImpl o) {
        return Compare.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name));
    }

    public boolean parseConfiguration(ConfigurationLine line) throws ModelException {
        boolean parsed = true;
        switch (line.getKey().toUpperCase(Locale.ROOT)) {
            case "NAME": {
                String str = line.getValue();
                if (str.indexOf(46) >= 0) {
                    throw line.createModelException("entity name must not contain package name");
                }
                this.setName(str);
                break;
            }
            case "ID": {
                String idStr = line.getValue();
                this.setClassId(Integer.parseInt(idStr));
                break;
            }
            case "TABLE": {
                this.setTableName(line.getValue());
                break;
            }
            case "ALIAS": {
                this.setDefinedTableAlias(line.getValue());
                this.setTableAlias(line.getValue());
                break;
            }
            case "INTEGRITY": {
                try {
                    this.setIntegrity(Integrity.valueOf(line.getValue().toUpperCase(Locale.ROOT)));
                    break;
                }
                catch (IllegalArgumentException ex) {
                    throw line.createModelException("illegal integrity level: " + line.getValue());
                }
            }
            case "INHERITANCE": {
                try {
                    this.setInheritanceType(InheritanceType.valueOf(line.getValue().toUpperCase(Locale.ROOT)));
                    break;
                }
                catch (IllegalArgumentException ex) {
                    throw line.createModelException("illegal inheritance type: " + line.getValue());
                }
            }
            case "EXTENDS": {
                this.setSuperEntityName(line.getValue());
                break;
            }
            case "COMMENT": {
                this.getOptions().setComment(line.getValue());
                break;
            }
            default: {
                parsed = false;
            }
        }
        return parsed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public int getClassId() {
        return this.classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableNameWithoutSchema() {
        return this.tableNameWithoutSchema;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public String getDefinedTableAlias() {
        return this.definedTableAlias;
    }

    public void setTableName(String tableName) {
        if (tableName == null) {
            this.tableName = null;
            this.schemaName = null;
            this.tableNameWithoutSchema = null;
        } else {
            this.tableName = tableName.toLowerCase(Locale.ROOT);
            int ndx = this.tableName.indexOf(46);
            if (ndx > 0) {
                this.schemaName = this.tableName.substring(0, ndx);
                this.tableNameWithoutSchema = this.tableName.substring(ndx + 1);
            } else {
                this.tableNameWithoutSchema = this.tableName;
            }
        }
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias != null ? tableAlias.toLowerCase(Locale.ROOT) : null;
    }

    public void setDefinedTableAlias(String definedTableAlias) {
        this.definedTableAlias = definedTableAlias;
    }

    @Override
    public Integrity getIntegrity() {
        return this.integrity;
    }

    @Override
    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public InheritanceType getHierarchyInheritanceType() {
        return this.superEntity == null ? this.inheritanceType : this.superEntity.getInheritanceType();
    }

    @Override
    public String getSuperEntityName() {
        return this.superEntityName;
    }

    @Override
    public Entity getSuperEntity() {
        return this.superEntity;
    }

    @Override
    public List<Entity> getSuperEntities() {
        ArrayList<Entity> superEntities = new ArrayList<Entity>();
        Entity entity = this;
        while (entity.getSuperEntity() != null) {
            superEntities.add(entity.getSuperEntity());
            entity = entity.getSuperEntity();
        }
        return superEntities;
    }

    @Override
    public Entity getTopSuperEntity() {
        Entity entity = this;
        while (entity.getSuperEntity() != null) {
            entity = entity.getSuperEntity();
        }
        return entity;
    }

    @Override
    public List<Entity> getInheritanceChain(Entity childEntity) throws ModelException {
        ArrayList<Entity> chain = new ArrayList<Entity>();
        for (Entity entity = childEntity; entity != null; entity = entity.getSuperEntity()) {
            chain.add(0, entity);
            if (entity == this) break;
        }
        if (chain.isEmpty() || chain.get(0) != this) {
            throw new ModelException(String.valueOf(this) + " is not a superclass of " + String.valueOf(childEntity));
        }
        return chain;
    }

    @Override
    public List<Entity> getSubEntities() {
        return this.subEntities;
    }

    @Override
    public List<Entity> getAllSubEntities() {
        ArrayList<Entity> children = new ArrayList<Entity>();
        this.collectSubEntities(children, this);
        return children;
    }

    @Override
    public List<Entity> getLeafEntities() {
        ArrayList<Entity> leafs = new ArrayList<Entity>();
        this.collectLeafEntities(leafs, this);
        return leafs;
    }

    protected void collectLeafEntities(List<Entity> leafs, Entity entity) {
        if (entity.isAbstract()) {
            for (Entity child : entity.getSubEntities()) {
                this.collectLeafEntities(leafs, child);
            }
        } else {
            leafs.add(entity);
        }
    }

    protected void collectSubEntities(List<Entity> subEntities, Entity entity) {
        for (Entity sub : entity.getSubEntities()) {
            subEntities.add(sub);
            this.collectSubEntities(subEntities, sub);
        }
    }

    @Override
    public Set<Entity> getAssociatedEntities() {
        LinkedHashSet<Entity> associates = new LinkedHashSet<Entity>();
        this.collectAssociatedEntities(associates, this, new HashSet<Entity>());
        return associates;
    }

    protected void collectAssociatedEntities(Set<Entity> associates, Entity entity, Set<Entity> processedEntities) {
        if (!processedEntities.contains(entity)) {
            processedEntities.add(entity);
            associates.add(entity);
            if (this.superEntity != null) {
                associates.add(this.superEntity);
                this.collectAssociatedEntities(associates, this.superEntity, processedEntities);
            }
            associates.addAll(this.getSubEntities());
            for (Entity child : this.getSubEntities()) {
                this.collectAssociatedEntities(associates, child, processedEntities);
            }
            for (Relation relation : this.getRelations()) {
                Entity relatedEntity = relation.getEntity();
                if (relatedEntity == null) continue;
                associates.add(relatedEntity);
                this.collectAssociatedEntities(associates, relatedEntity, processedEntities);
            }
            for (Relation relation : this.getReferencingRelations()) {
                Entity foreignEntity = relation.getForeignEntity();
                if (foreignEntity == null) continue;
                associates.add(foreignEntity);
                this.collectAssociatedEntities(associates, foreignEntity, processedEntities);
            }
        }
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = Objects.requireNonNull(integrity, "integrity");
    }

    public void setInheritanceType(InheritanceType inheritanceType) {
        this.inheritanceType = Objects.requireNonNull(inheritanceType, "inheritanceType");
    }

    public void setSuperEntityName(String superEntityName) {
        this.superEntityName = superEntityName;
    }

    public void setSuperEntity(Entity superEntity) {
        this.superEntity = superEntity;
    }

    public void setContextIdAttribute(Attribute contextIdAttribute) {
        this.contextIdAttribute = contextIdAttribute;
    }

    public void setSorting(List<AttributeSorting> sorting) {
        this.sorting = sorting;
    }

    @Override
    public EntityOptionsImpl getOptions() {
        return this.options;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isRootEntityAccordingToModel() {
        return this.modelRoot;
    }

    public void setRootEntityAccordingToModel(boolean modelRoot) {
        this.modelRoot = modelRoot;
    }

    @Override
    public boolean isProvidingRootClassIdAccordingToModel() {
        return this.modelRootClassId;
    }

    public void setProvidingRootClassIdAccordingToModel(boolean modelRootClassId) {
        this.modelRootClassId = modelRootClassId;
    }

    @Override
    public boolean isProvidingRootIdAccordingToModel() {
        return this.modelRootId;
    }

    public void setProvidingRootIdAccordingToModel(boolean modelRootId) {
        this.modelRootId = modelRootId;
    }

    @Override
    public List<Attribute> getInheritedAttributes() throws ModelException {
        return this.getInheritedAttributes(false);
    }

    private List<Attribute> getInheritedAttributes(boolean includeEmbedded) throws ModelException {
        ArrayList<Attribute> inheritedAttributes = new ArrayList<Attribute>();
        for (Entity se = this.getSuperEntity(); se != null; se = se.getSuperEntity()) {
            inheritedAttributes.addAll(0, se.getAttributes());
            if (!includeEmbedded) continue;
            inheritedAttributes.addAll(0, se.getEmbeddedAttributes());
        }
        return inheritedAttributes;
    }

    @Override
    public List<Attribute> getEmbeddedAttributes() throws ModelException {
        ArrayList<Attribute> embeddedAttributes = new ArrayList<Attribute>();
        HashSet<String> recursionSet = new HashSet<String>();
        this.collectEmbeddedAttributes(this, recursionSet, embeddedAttributes, "", "");
        return embeddedAttributes;
    }

    private void collectEmbeddedAttributes(Entity embeddingEntity, Set<String> recursionSet, List<Attribute> embeddedAttributes, String pathPrefix, String columnPrefix) throws ModelException {
        for (Relation relation : this.getRelations()) {
            EntityImpl embeddedEntity;
            if (!relation.isEmbedding() || (embeddedEntity = (EntityImpl)relation.getForeignEntity()) == null) continue;
            if (recursionSet.add(embeddedEntity.getName() + "." + relation.getName())) {
                String pPrefix = pathPrefix + StringHelper.firstToLower((String)relation.getName()) + ".";
                String cPrefix = columnPrefix + relation.getColumnPrefix();
                for (Attribute attribute : embeddedEntity.getAttributes()) {
                    embeddedAttributes.add(attribute.createEmbedded(embeddingEntity, pPrefix + attribute.getPathName(), cPrefix + attribute.getColumnName()));
                }
                embeddedEntity.collectEmbeddedAttributes(embeddingEntity, new HashSet<String>(recursionSet), embeddedAttributes, pPrefix, cPrefix);
                continue;
            }
            throw new ModelException(String.valueOf(embeddedEntity) + " embedded recursively via '" + pathPrefix + "..'", relation);
        }
    }

    @Override
    public List<Relation> getEmbeddedRelations(Entity embeddingEntity) throws ModelException {
        ArrayList<Relation> embeddedRelations = new ArrayList<Relation>();
        HashSet<String> recursionSet = new HashSet<String>();
        this.collectEmbeddedRelations(embeddingEntity, recursionSet, embeddedRelations, "", "");
        return embeddedRelations;
    }

    private void collectEmbeddedRelations(Entity embeddingEntity, Set<String> recursionSet, List<Relation> embeddedRelations, String pathPrefix, String columnPathPrefix) throws ModelException {
        for (Relation relation : this.getRelations()) {
            EntityImpl embeddedEntity;
            if (!relation.isEmbedding() || (embeddedEntity = (EntityImpl)relation.getForeignEntity()) == null) continue;
            if (recursionSet.add(embeddedEntity.getName() + "." + relation.getName())) {
                String pPrefix = pathPrefix + StringHelper.firstToLower((String)relation.getName()) + ".";
                String cPrefix = columnPathPrefix + relation.getColumnPrefix();
                for (Relation embeddedEntityRelation : embeddedEntity.getRelations()) {
                    if (embeddedEntityRelation.isEmbedding() || !embeddedEntityRelation.isEmbedded()) continue;
                    embeddedRelations.add(embeddedEntityRelation.createEmbedded(embeddingEntity, pPrefix, cPrefix));
                }
                embeddedEntity.collectEmbeddedRelations(embeddingEntity, new HashSet<String>(recursionSet), embeddedRelations, pPrefix, cPrefix);
                continue;
            }
            throw new ModelException(String.valueOf(embeddedEntity) + " embedded recursively via '" + pathPrefix + "..'", relation);
        }
    }

    @Override
    public List<Attribute> getSubEntityAttributes() {
        ArrayList<Attribute> subAttributes = new ArrayList<Attribute>();
        for (Entity sub : this.getAllSubEntities()) {
            for (Attribute attribute : sub.getAttributes()) {
                if (attribute.getName().equals("id") || attribute.getName().equals("serial")) continue;
                subAttributes.add(attribute);
            }
        }
        return subAttributes;
    }

    @Override
    public List<Attribute> getAttributesIncludingInherited() throws ModelException {
        return this.getAttributesIncludingInherited(false);
    }

    private List<Attribute> getAttributesIncludingInherited(boolean includeEmbedded) throws ModelException {
        List<Attribute> allAttributes = new ArrayList<Attribute>(this.getInheritedAttributes(includeEmbedded));
        allAttributes.addAll(this.attributes);
        allAttributes = this.moveIdSerialToEnd(allAttributes);
        return allAttributes;
    }

    @Override
    public List<Attribute> getAttributesIncludingSubEntities() {
        List<Attribute> allAttributes = new ArrayList<Attribute>(this.attributes);
        allAttributes.addAll(this.getSubEntityAttributes());
        allAttributes = this.moveIdSerialToEnd(allAttributes);
        return allAttributes;
    }

    @Override
    public List<Attribute> getAllAttributes() throws ModelException {
        List<Attribute> allAttributes = new ArrayList<Attribute>(this.getInheritedAttributes());
        allAttributes.addAll(this.attributes);
        allAttributes.addAll(this.getSubEntityAttributes());
        allAttributes = this.moveIdSerialToEnd(allAttributes);
        return allAttributes;
    }

    @Override
    public List<Attribute> getTableAttributes() throws ModelException {
        InheritanceType ihType = this.getHierarchyInheritanceType();
        List<Attribute> tableAttributes = new ArrayList<Attribute>(this.getEmbeddedAttributes());
        if (ihType.isMappingToOwnTable()) {
            tableAttributes.addAll(this.attributes);
            if (this.getSuperEntity() != null) {
                tableAttributes.add(this.getAttributeByJavaName("id", true));
            }
        } else if (ihType.isMappingToSuperTable()) {
            tableAttributes = new ArrayList();
            if (this.isRootOfInheritanceHierarchy()) {
                tableAttributes.addAll(this.attributes);
                for (Entity child : this.getAllSubEntities()) {
                    tableAttributes.addAll(child.getEmbeddedAttributes());
                    tableAttributes.addAll(child.getAttributes());
                }
                tableAttributes = this.moveIdSerialToEnd(tableAttributes);
            }
        } else {
            tableAttributes.addAll(this.getAttributesIncludingInherited(true));
        }
        return tableAttributes;
    }

    @Override
    public List<Attribute> getMappedAttributes() throws ModelException {
        List<Attribute> mappedAttributes;
        if (this.isAbstract()) {
            mappedAttributes = this.inheritanceType.isMappingToOwnTable() ? this.attributes : (this.inheritanceType.isMappingToSuperTable() ? this.removeIdSerial(this.attributes) : new ArrayList<Attribute>());
        } else {
            InheritanceType ihType = this.getHierarchyInheritanceType();
            if (ihType.isMappingToOwnTable()) {
                mappedAttributes = this.attributes;
            } else if (ihType.isMappingToSuperTable()) {
                Entity top = this.getTopSuperEntity();
                mappedAttributes = this.appendIdSerial(top, this.attributes);
            } else {
                mappedAttributes = ihType.isMappingToNoTable() ? this.getAttributesIncludingInherited() : this.attributes;
            }
        }
        return mappedAttributes;
    }

    protected List<Attribute> moveIdSerialToEnd(List<Attribute> attributes) {
        Attribute idAttribute = null;
        Attribute serialAttribute = null;
        ArrayList<Attribute> filteredList = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            if ("id".equals(attribute.getName())) {
                idAttribute = attribute;
                continue;
            }
            if ("serial".equals(attribute.getName())) {
                serialAttribute = attribute;
                continue;
            }
            filteredList.add(attribute);
        }
        if (idAttribute != null) {
            filteredList.add(idAttribute);
        }
        if (serialAttribute != null) {
            filteredList.add(serialAttribute);
        }
        return filteredList;
    }

    protected List<Attribute> removeIdSerial(List<Attribute> attributes) {
        ArrayList<Attribute> filteredList = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            if ("id".equals(attribute.getName()) || "serial".equals(attribute.getName())) continue;
            filteredList.add(attribute);
        }
        return filteredList;
    }

    protected List<Attribute> appendIdSerial(Entity entity, List<Attribute> attributes) {
        Attribute idAttribute = null;
        Attribute serialAttribute = null;
        for (Attribute attribute : entity.getAttributes()) {
            if ("id".equals(attribute.getName())) {
                idAttribute = attribute;
                continue;
            }
            if (!"serial".equals(attribute.getName())) continue;
            serialAttribute = attribute;
        }
        ArrayList<Attribute> filteredList = new ArrayList<Attribute>(attributes);
        if (idAttribute != null) {
            filteredList.add(idAttribute);
        }
        if (serialAttribute != null) {
            filteredList.add(serialAttribute);
        }
        return filteredList;
    }

    @Override
    public List<Index> getInheritedIndexes() {
        ArrayList<Index> inheritedIndexes = new ArrayList<Index>();
        for (Entity se = this.getSuperEntity(); se != null; se = se.getSuperEntity()) {
            inheritedIndexes.addAll(0, se.getIndexes());
        }
        return inheritedIndexes;
    }

    @Override
    public List<Index> getIndexesIncludingInherited() {
        ArrayList<Index> allIndexes = new ArrayList<Index>(this.getInheritedIndexes());
        allIndexes.addAll(this.indexes);
        return allIndexes;
    }

    @Override
    public List<Index> getSubEntityIndexes() {
        ArrayList<Index> subIndexes = new ArrayList<Index>();
        for (Entity sub : this.getSubEntities()) {
            subIndexes.addAll(sub.getIndexes());
        }
        return subIndexes;
    }

    @Override
    public List<Index> getIndexesIncludingSubEntities() {
        ArrayList<Index> allIndexes = new ArrayList<Index>(this.indexes);
        allIndexes.addAll(this.getSubEntityIndexes());
        return allIndexes;
    }

    @Override
    public List<Index> getAllIndexes() {
        ArrayList<Index> allIndexes = new ArrayList<Index>(this.getInheritedIndexes());
        allIndexes.addAll(this.indexes);
        allIndexes.addAll(this.getSubEntityIndexes());
        return allIndexes;
    }

    @Override
    public List<Index> getTableIndexes() {
        List<Index> tableIndexes;
        InheritanceType ihType = this.getHierarchyInheritanceType();
        if (ihType.isMappingToOwnTable()) {
            tableIndexes = this.indexes;
        } else if (ihType.isMappingToSuperTable()) {
            tableIndexes = new ArrayList<Index>();
            if (this.isRootOfInheritanceHierarchy()) {
                tableIndexes.addAll(this.indexes);
                for (Entity child : this.getAllSubEntities()) {
                    tableIndexes.addAll(child.getIndexes());
                }
            }
        } else {
            tableIndexes = this.getIndexesIncludingInherited();
        }
        return tableIndexes;
    }

    @Override
    public List<Relation> getInheritedRelations() throws ModelException {
        return this.getInheritedRelations(null);
    }

    private List<Relation> getInheritedRelations(Entity parentEntity) throws ModelException {
        ArrayList<Relation> allRelations = new ArrayList<Relation>();
        for (Entity se = this.getSuperEntity(); se != null; se = se.getSuperEntity()) {
            if (parentEntity != null) {
                allRelations.addAll(0, se.getEmbeddedRelations(parentEntity));
            }
            allRelations.addAll(0, se.getRelations());
        }
        return allRelations;
    }

    @Override
    public List<Relation> getSubEntityRelations() {
        ArrayList<Relation> allRelations = new ArrayList<Relation>();
        for (Entity sub : this.getAllSubEntities()) {
            allRelations.addAll(sub.getRelations());
        }
        return allRelations;
    }

    @Override
    public List<Relation> getRelationsIncludingInherited() throws ModelException {
        return this.getRelationsIncludingInherited(null);
    }

    private List<Relation> getRelationsIncludingInherited(Entity parentEntity) throws ModelException {
        ArrayList<Relation> allRelations = new ArrayList<Relation>(this.getInheritedRelations(parentEntity));
        allRelations.addAll(this.relations);
        return allRelations;
    }

    @Override
    public List<Relation> getRelationsIncludingSubEntities() {
        ArrayList<Relation> allRelations = new ArrayList<Relation>(this.relations);
        allRelations.addAll(this.getSubEntityRelations());
        return allRelations;
    }

    @Override
    public List<Relation> getAllRelations() throws ModelException {
        List<Relation> allRelations = this.getRelationsIncludingInherited();
        allRelations.addAll(this.getSubEntityRelations());
        return allRelations;
    }

    @Override
    public List<Relation> getTableRelations() throws ModelException {
        InheritanceType ihType = this.getHierarchyInheritanceType();
        ArrayList<Relation> tableRelations = new ArrayList<Relation>();
        if (ihType.isMappingToOwnTable()) {
            tableRelations.addAll(this.relations);
        } else if (ihType.isMappingToSuperTable()) {
            tableRelations = new ArrayList();
            if (this.isRootOfInheritanceHierarchy()) {
                tableRelations.addAll(this.relations);
                for (Entity sub : this.getAllSubEntities()) {
                    tableRelations.addAll(sub.getRelations());
                    tableRelations.addAll(sub.getEmbeddedRelations(this));
                }
            }
        } else {
            tableRelations.addAll(this.getRelationsIncludingInherited());
        }
        tableRelations.addAll(this.getEmbeddedRelations(this));
        return tableRelations;
    }

    @Override
    public Set<List<Relation>> getCompositePaths() {
        return this.compositePaths;
    }

    @Override
    public Set<List<Relation>> getAllCompositePaths() {
        if (this.allCompositePaths == null) {
            this.allCompositePaths = new LinkedHashSet<List<Relation>>();
            for (Entity currentEntity = this; currentEntity != null; currentEntity = currentEntity.getSuperEntity()) {
                this.allCompositePaths.addAll(currentEntity.getCompositePaths());
            }
        }
        return this.allCompositePaths;
    }

    @Override
    public Set<List<Relation>> getEmbeddingPaths() {
        LinkedHashSet<List<Relation>> embeddingPaths = new LinkedHashSet<List<Relation>>();
        for (List<Relation> compositePath : this.getCompositePaths()) {
            ArrayList<Relation> embeddingPath = new ArrayList<Relation>();
            for (Relation relation : compositePath) {
                if (!relation.isEmbedding()) continue;
                embeddingPath.add(relation);
            }
            embeddingPaths.add(embeddingPath);
        }
        return embeddingPaths;
    }

    @Override
    public Set<Entity> getEmbeddingEntities() {
        LinkedHashSet<Entity> embeddingEntities = new LinkedHashSet<Entity>();
        for (List<Relation> embeddingPath : this.getEmbeddingPaths()) {
            embeddingEntities.add(embeddingPath.get(0).getEntity());
        }
        return embeddingEntities;
    }

    @Override
    public Set<Entity> getComponents() {
        TreeSet<Entity> components = new TreeSet<Entity>();
        for (Relation relation : this.getRelations()) {
            if (!relation.isComposite()) continue;
            components.add(relation.getForeignEntity());
        }
        return components;
    }

    @Override
    public Set<Entity> getComponentsIncludingInherited() throws ModelException {
        TreeSet<Entity> components = new TreeSet<Entity>();
        for (Relation relation : this.getRelationsIncludingInherited()) {
            if (!relation.isComposite()) continue;
            components.add(relation.getForeignEntity());
        }
        return components;
    }

    @Override
    public Set<Entity> getAllComponents() throws ModelException {
        TreeSet<Entity> components = new TreeSet<Entity>();
        for (Relation relation : this.getRelationsIncludingInherited()) {
            if (!relation.isComposite()) continue;
            Entity component = relation.getForeignEntity();
            components.add(component);
            components.addAll(component.getComponentsIncludingInherited());
        }
        return components;
    }

    @Override
    public boolean isDeeplyReferenced() {
        return this.deeplyReferenced;
    }

    public void setDeeplyReferenced(boolean deeplyReferenced) {
        this.deeplyReferenced = deeplyReferenced;
    }

    @Override
    public List<Relation> getDeepReferences() {
        return this.deepReferences;
    }

    @Override
    public List<Relation> getDeepReferencesToComponents() {
        return this.deepReferencesToComponents;
    }

    @Override
    public List<Relation> getDeeplyReferencedComponents() {
        ArrayList<Relation> deepRelations = new ArrayList<Relation>();
        for (Relation relation : this.relations) {
            Entity component;
            if (!relation.isComposite() || !(component = relation.getForeignEntity()).isDeeplyReferenced()) continue;
            deepRelations.add(relation);
        }
        return deepRelations;
    }

    @Override
    public Attribute getAttributeByJavaName(String javaName, boolean all) {
        if (javaName != null) {
            for (Entity entity = this; entity != null; entity = entity.getSuperEntity()) {
                for (Attribute attribute : entity.getAttributes()) {
                    if (!javaName.equalsIgnoreCase(attribute.getName())) continue;
                    return attribute;
                }
                if (!all) break;
            }
        }
        return null;
    }

    @Override
    public Attribute getAttributeByColumnName(String columnName, boolean all) {
        if (columnName != null) {
            for (Entity entity = this; entity != null; entity = entity.getSuperEntity()) {
                for (Attribute attribute : entity.getAttributes()) {
                    if (!columnName.equalsIgnoreCase(attribute.getColumnName())) continue;
                    return attribute;
                }
                if (!all) break;
            }
        }
        return null;
    }

    @Override
    public Attribute getContextIdAttribute() {
        return this.contextIdAttribute;
    }

    @Override
    public List<Attribute> getUniqueDomainKey() throws ModelException {
        if (this.uniqueDomainKey == null) {
            this.uniqueDomainKey = new ArrayList<Attribute>();
            if (this.isRootEntity()) {
                this.getUniqueDomainKeyImpl(this.uniqueDomainKey, this);
            }
        }
        return this.uniqueDomainKey;
    }

    protected void getUniqueDomainKeyImpl(List<Attribute> uniqueDomainKeys, Entity entity) throws ModelException {
        for (Attribute attribute : entity.getAttributesIncludingInherited()) {
            if (!attribute.getOptions().isDomainKey()) continue;
            uniqueDomainKeys.add(attribute);
        }
        for (Entity component : entity.getComponentsIncludingInherited()) {
            if (component.isRootEntity() || component.isEmbedded()) continue;
            this.getUniqueDomainKeyImpl(uniqueDomainKeys, component);
        }
    }

    @Override
    public List<AttributeSorting> getSorting() {
        return this.sorting;
    }

    @Override
    public List<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index getIndex(String name, boolean all) {
        if (name != null) {
            for (Entity entity = this; entity != null; entity = entity.getSuperEntity()) {
                for (Index index : entity.getIndexes()) {
                    if (!name.equalsIgnoreCase(index.getName())) continue;
                    return index;
                }
                if (!all) break;
            }
        }
        return null;
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public List<Relation> getReferencingRelations() {
        return this.referencingRelations;
    }

    @Override
    public List<Relation> getInheritedReferencingRelations() {
        ArrayList<Relation> inheritedReferencingRelations = new ArrayList<Relation>();
        for (Entity se = this.getSuperEntity(); se != null; se = se.getSuperEntity()) {
            inheritedReferencingRelations.addAll(0, se.getReferencingRelations());
        }
        return inheritedReferencingRelations;
    }

    @Override
    public List<Relation> getReferencingRelationsIncludingInherited() {
        ArrayList<Relation> allRelations = new ArrayList<Relation>(this.getInheritedReferencingRelations());
        allRelations.addAll(this.getReferencingRelations());
        return allRelations;
    }

    @Override
    public List<Relation> getSubEntityReferencingRelations() {
        ArrayList<Relation> subReferencingRelations = new ArrayList<Relation>();
        for (Entity sub : this.getAllSubEntities()) {
            subReferencingRelations.addAll(sub.getReferencingRelations());
        }
        return subReferencingRelations;
    }

    @Override
    public List<Relation> getReferencingRelationsIncludingSubEntities() {
        ArrayList<Relation> allRelations = new ArrayList<Relation>(this.getReferencingRelations());
        allRelations.addAll(this.getSubEntityReferencingRelations());
        return allRelations;
    }

    @Override
    public List<Relation> getAllReferencingRelations() {
        ArrayList<Relation> allRelations = new ArrayList<Relation>(this.getReferencingRelationsIncludingInherited());
        allRelations.addAll(this.getSubEntityReferencingRelations());
        return allRelations;
    }

    @Override
    public Relation getRelation(String name, boolean all) {
        if (name != null) {
            for (Entity entity = this; entity != null; entity = entity.getSuperEntity()) {
                for (Relation relation : entity.getRelations()) {
                    if (!name.equalsIgnoreCase(relation.getName()) && !name.equalsIgnoreCase(relation.getVariableName())) continue;
                    return relation;
                }
                if (!all) break;
            }
        }
        return null;
    }

    @Override
    public List<Relation> getRelations(Entity entity, boolean all) {
        ArrayList<Relation> rels = new ArrayList<Relation>();
        if (entity != null) {
            for (Entity e = this; e != null; e = e.getSuperEntity()) {
                for (Relation relation : e.getRelations()) {
                    if (!entity.equals(relation.getForeignEntity())) continue;
                    rels.add(relation);
                }
                if (!all) break;
            }
        }
        return rels;
    }

    public void validate() throws ModelException {
        if (StringHelper.isAllWhitespace((String)this.getName())) {
            throw new ModelException("configuration 'name = ...' missing", this);
        }
        String diag = NameVerifier.getInstance().verifyEntityName(this);
        if (diag != null) {
            throw new ModelException(diag, this);
        }
        diag = NameVerifier.getInstance().verifyTableName(this);
        if (diag != null) {
            throw new ModelException(diag, this);
        }
        diag = NameVerifier.getInstance().verifyTableAlias(this);
        if (diag != null) {
            throw new ModelException(diag, this);
        }
        if (!this.isAbstract() && !this.isEmbedded()) {
            if (this.getClassId() == 0) {
                throw new ModelException("configuration 'id = ...' missing", this);
            }
        } else if (this.getClassId() != 0) {
            throw new ModelException("configuration 'id = ...' not allowed", this);
        }
        if (this.isEmbedded()) {
            if (this.getSorting() != null) {
                throw new ModelException("sorting not applicable to embedded entities");
            }
            if (this.getSuperEntityName() != null) {
                throw new ModelException("embedded entities cannot extend other entities");
            }
            if (this.getOptions().isRoot()) {
                throw new ModelException("embedded entities cannot be root entities");
            }
            if (this.getOptions().isCached()) {
                throw new ModelException("embedded entities cannot be cached");
            }
            if (this.getOptions().isProvided()) {
                throw new ModelException("embedded entities cannot be provided by foreign applications");
            }
            if (this.getOptions().isNoPrimaryKey()) {
                throw new ModelException("[NOPKEY] option is not applicable to embedded entities");
            }
            if (this.getOptions().isRootIdProvided()) {
                throw new ModelException("embedded entities cannot provide a rootid column");
            }
            if (this.getOptions().isRootClassIdProvided()) {
                throw new ModelException("embedded entities cannot provide a rootclassid column");
            }
            if (this.getOptions().isNormTextProvided()) {
                throw new ModelException("embedded entities cannot provide a normtext");
            }
            if (this.getOptions().isTableSerialProvided()) {
                throw new ModelException("embedded entities cannot provide a table serial");
            }
            if (this.getOptions().isTokenLockProvided()) {
                throw new ModelException("embedded entities cannot provide a token lock");
            }
        }
        this.getOptions().validate();
        if (this.getOptions().isRoot()) {
            if (this.getSuperEntityName() != null) {
                throw new ModelException("[ROOT] option cannot be applied to subclasses", this);
            }
            if (this.getOptions().isRootIdProvided()) {
                throw new ModelException("root entities cannot provide a rootid column", this);
            }
            if (this.getOptions().isRootClassIdProvided()) {
                throw new ModelException("root entities cannot provide a rootclassid column", this);
            }
        }
        HashMap<String, Attribute> javaNames = new HashMap<String, Attribute>();
        for (Attribute attribute : this.getAttributes()) {
            attribute.validate();
            Attribute attribute2 = javaNames.put(this.normalizeName(attribute.getName()), attribute);
            if (attribute2 == null) continue;
            if (attribute2.getName().equals(attribute.getName())) {
                throw new ModelException("duplicate Java name '" + attribute.getName() + "'", this);
            }
            throw new ModelException("Java name '" + attribute.getName() + "' too close to '" + attribute2.getName() + "' -> danger of confusion", this);
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (Attribute attribute : this.getAttributes()) {
            String normalizedColumnName = this.normalizeName(attribute.getColumnName());
            if (!columnNames.add(normalizedColumnName)) {
                throw new ModelException("duplicate column name '" + attribute.getColumnName() + "'", this);
            }
            Attribute other = (Attribute)javaNames.get(normalizedColumnName);
            if (other == null || other.equals(attribute)) continue;
            throw new ModelException("misleading column name '" + attribute.getColumnName() + "' for Java name '" + attribute.getName() + "' -> danger of confusion with '" + other.getName() + " / " + other.getColumnName() + "'", this);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Index index : this.getIndexes()) {
            if (!((IndexImpl)index).isParsed()) continue;
            index.validate();
            if (hashSet.add(this.normalizeName(index.getName()))) continue;
            throw new ModelException("duplicate index name '" + index.getName() + "'", this);
        }
        for (Index index : this.getIndexes()) {
            IndexImpl indexImpl = (IndexImpl)index;
            if (!indexImpl.isParsed()) continue;
            for (Index otherIndex : this.getIndexes()) {
                IndexImpl otherIndexImpl = (IndexImpl)otherIndex;
                if (otherIndex == index || !otherIndexImpl.isParsed() || !indexImpl.isLogicallyEqualTo(otherIndexImpl)) continue;
                throw new ModelException("index '" + index.getName() + "' is logically identical to '" + otherIndex.getName() + "'", this);
            }
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Relation relation : this.getRelations()) {
            relation.validate();
            if (hashSet2.add(this.normalizeName(relation.getName()))) continue;
            throw new ModelException("duplicate relation name '" + relation.getName() + "'", this);
        }
    }

    public void validateRelated() throws ModelException {
        if (this.getTableProvidingEntity() == this) {
            if (StringHelper.isAllWhitespace((String)this.getTableName())) {
                throw new ModelException("configuration 'table = ...' missing", this);
            }
            for (Backend backend : this.factory.getBackends()) {
                try {
                    backend.assertValidName(SqlNameType.TABLE_NAME, this.getTableName());
                    backend.assertValidName(SqlNameType.TABLE_ALIAS, this.getTableAlias());
                }
                catch (RuntimeException rex) {
                    throw new ModelException(rex.getMessage(), this, rex);
                }
            }
        } else {
            if (!StringHelper.isAllWhitespace((String)this.getTableName())) {
                throw new ModelException("configuration 'table = ...' not allowed", this);
            }
            if (!StringHelper.isAllWhitespace((String)this.getTableAlias())) {
                throw new ModelException("configuration 'alias = ...' not allowed", this);
            }
        }
        if (this.isRootOfInheritanceHierarchy() && this.inheritanceType.isMappingToSuperTable()) {
            for (Entity sub : this.getAllSubEntities()) {
                for (Attribute attribute : sub.getAttributes()) {
                    ((AttributeImpl)attribute).setNullable(true);
                }
            }
        }
        if (this.getIntegrity().isCompositesCheckedByDatabase() && this.isDeletionCascaded() == null) {
            throw new ModelException(String.valueOf((Object)this.getIntegrity()) + " integrity requires all composite relations to be either cascaded or non-cascaded", this);
        }
    }

    @Override
    public String sqlCreateTable(Backend backend) throws ModelException {
        return CodeFactory.getInstance().createSqlTable(this, backend);
    }

    @Override
    public boolean isComposite() {
        for (Relation relation : this.getRelationsIncludingSubEntities()) {
            if (!relation.isComposite()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEffectivelyComposite() {
        for (Relation relation : this.getRelationsIncludingSubEntities()) {
            if (!relation.isComposite() || relation.isEmbedding()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.inheritanceType.isAbstractClass();
    }

    @Override
    public boolean isEmbedded() {
        return InheritanceType.EMBEDDED == this.inheritanceType;
    }

    @Override
    public boolean isTracked() {
        return this.getOptions().getTrackType().isTracked();
    }

    @Override
    public Boolean isDeletionCascaded() {
        Boolean cascaded = null;
        for (Relation relation : this.getRelations()) {
            if (!relation.isComposite()) continue;
            if (cascaded == null) {
                cascaded = relation.isDeletionCascaded();
                continue;
            }
            if (cascaded.booleanValue() == relation.isDeletionCascaded()) continue;
            return null;
        }
        if (cascaded == null) {
            cascaded = false;
        }
        return cascaded;
    }

    @Override
    public boolean isRootOfInheritanceHierarchy() {
        return this.superEntityName == null && this.inheritanceType != InheritanceType.NONE;
    }

    @Override
    public Set<Attribute> getRootAttributes() {
        LinkedHashSet<Attribute> rootAttributes = new LinkedHashSet<Attribute>();
        for (List<Relation> compositePath : this.compositePaths) {
            Relation lastRelation = compositePath.get(compositePath.size() - 1);
            if (lastRelation.getForeignAttribute() == null) continue;
            rootAttributes.add(lastRelation.getForeignAttribute());
        }
        return rootAttributes;
    }

    @Override
    public Attribute getRootAttribute() {
        Set<Attribute> rootAttributes = this.getRootAttributes();
        return rootAttributes.size() == 1 ? rootAttributes.iterator().next() : null;
    }

    @Override
    public Set<Entity> getRootEntities() {
        LinkedHashSet<Entity> rootEntities = new LinkedHashSet<Entity>();
        for (List<Relation> compositePath : this.compositePaths) {
            Relation firstRelation = compositePath.get(0);
            rootEntities.add(firstRelation.getEntity());
        }
        return rootEntities;
    }

    @Override
    public Entity getRootEntity() {
        Entity root;
        Set<Entity> rootEntities = this.getRootEntities();
        if (rootEntities.size() == 1 && !(root = rootEntities.iterator().next()).isAbstract()) {
            return root;
        }
        return null;
    }

    @Override
    public boolean isRootEntity() {
        if (this.rootEntity == null) {
            this.rootEntity = false;
            for (Entity entity = this; entity != null; entity = entity.getSuperEntity()) {
                if (!entity.getOptions().isRoot()) continue;
                this.rootEntity = true;
                break;
            }
        }
        return this.rootEntity;
    }

    @Override
    public Entity getTableProvidingEntity() {
        InheritanceType ihType = this.getHierarchyInheritanceType();
        if (ihType.isMappingToOwnTable()) {
            return this;
        }
        if (ihType.isMappingToSuperTable()) {
            return this.getTopSuperEntity();
        }
        if (this.inheritanceType.isMappingToOwnTable()) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private String normalizeName(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            buf.append(Character.toUpperCase(c));
        }
        return buf.toString();
    }
}

