/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelDirectory;
import org.tentackle.model.ModelException;

public class ModelDirectoryImpl
implements ModelDirectory {
    private final File dir;
    private final String path;
    private final ModelDefaults modelDefaults;
    private final EntityAliases entityAliases;
    private long lastModified;

    public ModelDirectoryImpl(String modelDir, ModelDefaults defaults, EntityAliases aliases) throws ModelException {
        this.dir = new File(modelDir);
        if (!this.dir.exists()) {
            throw new ModelException(modelDir + " does not exist");
        }
        if (!this.dir.isDirectory()) {
            throw new ModelException(modelDir + " is not a directory");
        }
        try {
            this.path = this.dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ModelException("cannot determine path of model directory " + String.valueOf(this.dir), e);
        }
        this.lastModified = this.dir.lastModified();
        this.modelDefaults = defaults;
        this.entityAliases = aliases;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<URL> getURLs() throws ModelException {
        ArrayList<URL> paths = new ArrayList<URL>();
        File[] files = this.dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || file.isHidden()) continue;
                try {
                    paths.add(new File(this.path, file.getName()).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new ModelException("cannot convert file '" + String.valueOf(file) + " to URL", e);
                }
            }
        }
        return paths;
    }

    @Override
    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    @Override
    public EntityAliases getEntityAliases() {
        return this.entityAliases;
    }

    @Override
    public boolean hasChanged() {
        return this.dir.lastModified() > this.lastModified;
    }

    @Override
    public void markDirty() {
        this.lastModified = 0L;
    }
}

