/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.Locale;
import java.util.Set;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.NameVerifier;
import org.tentackle.model.Relation;

@Service(value=NameVerifier.class)
public class NameVerifierImpl
implements NameVerifier {
    private static final String TABLE_NAME = "table name '";
    private static final String TABLE_ALIAS = "table alias '";
    private static final String COLUMN_NAME = "column name '";
    private static final String MIXED_UC_LC = "' contains mixed upper- and lowercase characters";
    private static final String QUOTED = "' is quoted, which is only allowed for [PROVIDED] entities";
    private static final Set<String> ILLEGAL_NAMES = Set.of("abstract", "backend", "baseContext", "cache", "cacheAccessCount", "cacheAccessTime", "cacheable", "cached", "class", "classBaseName", "classId", "classVariables", "columnCount", "columnName", "columnNames", "columnPrefix", "composite", "contextId", "contextUserId", "copy", "countingModification", "defaultScopes", "deleted", "domainContext", "domainContextImmutable", "domainDelegate", "eagerJoinedSelect", "eagerJoins", "editAllowed", "editedBy", "editedExpiry", "editedSince", "effectiveClass", "effectiveSuperClasses", "embedded", "embeddedFields", "embeddingParent", "embeddingPersistentObject", "entity", "expirationBacklog", "expired", "expiredTableSerials", "explicitIdAliasRequiredInJoins", "fields", "finallyImmutable", "forcedModified", "fromThisJVM", "id", "idSource", "idValid", "immutable", "immutableLoggingLevel", "loggingModification", "modificationCount", "modificationLog", "modified", "new", "normText", "normTextProvided", "overloadable", "pdo", "pdoClass", "pdoMethodCache", "permissionAccepted", "persistable", "persistenceClass", "preparedStatement", "readAllowed", "referenced", "remoteDelegate", "removable", "renewTokenLockRequested", "replayedLeniently", "rootClassId", "rootClassIdProvided", "rootEntity", "rootEntityOf", "rootId", "rootIdProvided", "securityResult", "serial", "session", "sessionHolder", "sessionImmutable", "snapshot", "snapshots", "sqlClassIdCondition", "sqlContextCondition", "statementAlwaysPrepared", "tableAlias", "tableName", "tableSerial", "tableSerialProvided", "tokenLockProvided", "tokenLockTimeout", "tokenLockableByMe", "tokenLocked", "tokenLockedBy", "tokenLockedByMe", "topSuperTableAlias", "topSuperTableName", "tracked", "transientData", "updatingSerialEvenIfNotModified", "validClassIds", "validated", "viewAllowed", "virgin", "writeAllowed");
    private static final Set<String> CONFUSING_NAMES = Set.of("ABSTRACT", "ACCEPTPERSISTENCEVISITOR", "ADDCOMPONENTS", "ADDPROPERTYLISTENER", "ADDREFERENCINGCLASS", "APPLYTOKENLOCKINFO", "ASSERTNOTABSTRACT", "ASSERTROOTCONTEXTISACCEPTED", "ASSERTROOTENTITY", "ATTRIBUTESMODIFIED", "BACKEND", "BASECONTEXT", "CACHE", "CACHEABLE", "CACHEACCESSCOUNT", "CACHEACCESSTIME", "CACHED", "CLASS", "CLASSBASENAME", "CLASSID", "CLASSVARIABLES", "CLEARONREMOTESAVE", "CLEARTOKENLOCK", "COLUMNCOUNT", "COLUMNNAME", "COLUMNNAMES", "COLUMNPREFIX", "COMPARETO", "COMPOSITE", "CONFIGUREEMBEDDEDCOLUMNS", "CONFIGUREREMOTEOBJECT", "CONFIGUREREMOTEOBJECTS", "CONTAINSPATTERN", "CONTEXTID", "CONTEXTUSERID", "COPY", "COUNTINGMODIFICATION", "COUNTMODIFICATION", "CREATEATTRIBUTESNORMTEXT", "CREATEDELETEALLSQL", "CREATEDELETESQL", "CREATEDUMMYUPDATESQL", "CREATEINSERTSQL", "CREATEMODIFICATIONLOG", "CREATEPREPAREDSTATEMENT", "CREATEQUERY", "CREATERELATIONSNORMTEXT", "CREATESELECTALLBYIDINNERSQL", "CREATESELECTALLIDSERIALINNERSQL", "CREATESELECTALLINNERSQL", "CREATESELECTALLSQL", "CREATESELECTALLWITHEXPIREDTABLESERIALSSQL", "CREATESELECTBYNORMTEXTSQL", "CREATESELECTEXPIREDTABLESERIALS1SQL", "CREATESELECTEXPIREDTABLESERIALS2SQL", "CREATESELECTIDINNERSQL", "CREATESELECTMAXIDSQL", "CREATESELECTMAXTABLESERIALSQL", "CREATESELECTOBJECTSWITHEXPIREDTABLESERIALSSQL", "CREATESELECTSERIALSQL", "CREATESELECTSQL", "CREATESELECTTOKENLOCKSQL", "CREATESNAPSHOT", "CREATESQLUPDATE", "CREATETRANSFERTOKENLOCKSQL", "CREATETRANSFERTOKENLOCKWITHTABLESERIALSQL", "CREATEUPDATEANDSETSERIALSQL", "CREATEUPDATESERIALANDTABLESERIALSQL", "CREATEUPDATESERIALSQL", "CREATEUPDATESQL", "CREATEUPDATETOKENLOCKONLYSQL", "CREATEUPDATETOKENLOCKSQL", "CREATEUPDATETOKENLOCKWITHCOUNTSQL", "CREATEVALIDCONTEXT", "DEFAULTSCOPES", "DELETE", "DELETED", "DELETEOBJECT", "DELETEPLAIN", "DELETEPLAINWITHCOMPONENTS", "DELETEREFERENCEDRELATIONS", "DELETEREFERENCINGRELATIONS", "DERIVEPDOFROMPO", "DETERMINECONTEXTID", "DIFFERSPERSISTED", "DISCARDSNAPSHOT", "DISCARDSNAPSHOTS", "DOMAINCONTEXT", "DOMAINCONTEXTIMMUTABLE", "DOMAINDELEGATE", "DUMMYUPDATE", "EAGERJOINEDSELECT", "EAGERJOINS", "EDITALLOWED", "EDITEDBY", "EDITEDEXPIRY", "EDITEDSINCE", "EFFECTIVECLASS", "EFFECTIVESUPERCLASSES", "EMBEDDED", "EMBEDDEDFIELDS", "EMBEDDINGPARENT", "EMBEDDINGPERSISTENTOBJECT", "ENTITY", "EQUALS", "EXECUTEFIRSTPDOQUERY", "EXECUTELISTQUERY", "EXECUTEQUERY", "EXECUTEQUERYTOLIST", "EXECUTESCROLLABLEQUERY", "EXECUTETRACKEDLISTQUERY", "EXPIRATIONBACKLOG", "EXPIRECACHE", "EXPIRED", "EXPIREDTABLESERIALS", "EXPLICITIDALIASREQUIREDINJOINS", "FIELDS", "FINALLYIMMUTABLE", "FINDDUPLICATE", "FORCEDMODIFIED", "FROMTHISJVM", "HASHCODE", "ID", "IDSOURCE", "IDVALID", "IMMUTABLE", "IMMUTABLELOGGINGLEVEL", "INSERTOBJECT", "INSERTPLAIN", "INSERTPLAINWITHCOMPONENTS", "LOADCOMPONENTS", "LOADLAZYREFERENCES", "LOGGINGMODIFICATION", "LOGMODIFICATION", "MARKCACHEACCESS", "MARKDELETED", "ME", "MODIFICATIONCOUNT", "MODIFICATIONLOG", "MODIFIED", "NEW", "NEWID", "NEWINSTANCE", "NORMTEXT", "NORMTEXTPROVIDED", "NOTIFY", "NOTIFYALL", "ON", "OP", "ORDERBY", "OVERLOADABLE", "PDO", "PDOCLASS", "PDOMETHODCACHE", "PERMISSIONACCEPTED", "PERSIST", "PERSISTABLE", "PERSISTENCECLASS", "PERSISTOBJECT", "PERSISTTOKENLOCKED", "PREPAREDELETE", "PREPAREDSTATEMENT", "PREPARESAVE", "PREPARESETFIELDS", "READALLOWED", "READFROMRESULTSETWRAPPER", "READJOINEDROW", "REFERENCED", "RELEASETOKENLOCK", "RELOAD", "RELOADFORUPDATE", "RELOADOBJECT", "RELOADOBJECTFORUPDATE", "REMOTEDELEGATE", "REMOVABLE", "REMOVEALLPROPERTYLISTENERS", "REMOVEPROPERTYLISTENER", "REMOVEREFERENCINGCLASS", "RENEWTOKENLOCKREQUESTED", "REPLAYEDLENIENTLY", "REQUESTTOKENLOCK", "RESERVEID", "RESULTALL", "RESULTALLCURSOR", "RESULTALLIDSERIAL", "RESULTALLOBJECTS", "RESULTALLWITHEXPIREDTABLESERIALS", "RESULTBYNORMTEXT", "RESULTBYNORMTEXTCURSOR", "RESULTOBJECTSWITHEXPIREDTABLESERIALS", "REVERTTOSNAPSHOT", "ROOTCLASSID", "ROOTCLASSIDPROVIDED", "ROOTENTITY", "ROOTENTITYOF", "ROOTID", "ROOTIDPROVIDED", "SAVE", "SAVEOBJECT", "SAVEREFERENCEDRELATIONS", "SAVEREFERENCINGRELATIONS", "SECURITYRESULT", "SELECT", "SELECTALL", "SELECTALLASCURSOR", "SELECTALLCACHED", "SELECTALLFORCACHE", "SELECTALLIDSERIAL", "SELECTALLOBJECTS", "SELECTALLWITHEXPIREDTABLESERIALS", "SELECTBYNORMTEXT", "SELECTBYNORMTEXTASCURSOR", "SELECTBYTEMPLATE", "SELECTCACHED", "SELECTCACHEDONLY", "SELECTEXPIREDTABLESERIALS", "SELECTFORCACHE", "SELECTFORUPDATE", "SELECTLATEST", "SELECTMAXID", "SELECTMAXTABLESERIAL", "SELECTNEXTOBJECT", "SELECTOBJECT", "SELECTOBJECTFORUPDATE", "SELECTOBJECTSWITHEXPIREDTABLESERIALS", "SELECTSERIAL", "SERIAL", "SESSION", "SESSIONHOLDER", "SESSIONIMMUTABLE", "SNAPSHOT", "SNAPSHOTS", "SQLCLASSIDCONDITION", "SQLCONTEXTCONDITION", "STATEMENTALWAYSPREPARED", "TABLEALIAS", "TABLENAME", "TABLESERIAL", "TABLESERIALPROVIDED", "TOGENERICSTRING", "TOIDSTRING", "TOKENLOCKABLEBYME", "TOKENLOCKED", "TOKENLOCKEDBY", "TOKENLOCKEDBYME", "TOKENLOCKPROVIDED", "TOKENLOCKTIMEOUT", "TOPSUPERTABLEALIAS", "TOPSUPERTABLENAME", "TOSTRING", "TRACKED", "TRANSFERTOKENLOCK", "TRANSIENTDATA", "UNMARKDELETED", "UPDATENORMTEXT", "UPDATEOBJECT", "UPDATEPLAIN", "UPDATEROOTCONTEXT", "UPDATESERIAL", "UPDATESERIALANDTABLESERIAL", "UPDATETOKENLOCK", "UPDATETOKENLOCKONLY", "UPDATINGSERIALEVENIFNOTMODIFIED", "VALIDATE", "VALIDATED", "VALIDCLASSIDS", "VIEWALLOWED", "VIRGIN", "WAIT", "WRITEALLOWED");

    @Override
    public String verifyEntityName(Entity entity) {
        String name = entity.getName();
        return StringHelper.isValidJavaClassName((String)name) ? null : "'" + name + "' is not a valid Java class name";
    }

    @Override
    public String verifyTableName(Entity entity) {
        String name = entity.getTableName();
        if (this.isNotQuotedOrProvided(name, entity)) {
            return this.isAllUpperOrLowerCase(name, entity) ? null : TABLE_NAME + name + MIXED_UC_LC;
        }
        return TABLE_NAME + name + QUOTED;
    }

    @Override
    public String verifyTableAlias(Entity entity) {
        String name = entity.getTableAlias();
        if (this.isNotQuotedOrProvided(name, entity)) {
            return this.isAllUpperOrLowerCase(name, entity) ? null : TABLE_ALIAS + name + MIXED_UC_LC;
        }
        return TABLE_ALIAS + name + QUOTED;
    }

    @Override
    public String verifyAttributeName(Attribute attribute) {
        return attribute.isImplicit() ? null : this.validateJavaIdentifier(attribute.getName());
    }

    @Override
    public String verifyRelationName(Relation relation) {
        return this.validateJavaIdentifier(relation.getVariableName());
    }

    @Override
    public String verifyColumnName(Attribute attribute) {
        String name = attribute.getColumnName();
        if (this.isNotQuotedOrProvided(name, attribute.getEntity())) {
            return this.isAllUpperOrLowerCase(name, attribute.getEntity()) ? null : COLUMN_NAME + name + MIXED_UC_LC;
        }
        return COLUMN_NAME + name + QUOTED;
    }

    @Override
    public String verifyIndexName(Index index) {
        String name = index.getName();
        return this.isAllUpperOrLowerCase(name, index.getEntity()) ? null : "index name '" + name + MIXED_UC_LC;
    }

    protected boolean isAllUpperOrLowerCase(String name, Entity entity) {
        return name == null || entity.getOptions().isProvided() || name.equals(name.toLowerCase(Locale.ROOT)) || name.equals(name.toUpperCase(Locale.ROOT));
    }

    protected boolean isNotQuotedOrProvided(String name, Entity entity) {
        return name == null || !name.startsWith("\"") || entity.getOptions().isProvided();
    }

    protected String validateJavaIdentifier(String name) {
        if (!StringHelper.isValidJavaIdentifier((String)name)) {
            return "'" + name + "' is not a valid Java identifier name";
        }
        if (this.getIllegalNames().contains(name)) {
            return "'" + name + "' conflicts with method in superclasses";
        }
        if (this.getConfusingNames().contains(name.toUpperCase(Locale.ROOT))) {
            return "'" + name + "' may be confused with similar method in superclasses";
        }
        return null;
    }

    protected Set<String> getIllegalNames() {
        return ILLEGAL_NAMES;
    }

    protected Set<String> getConfusingNames() {
        return CONFUSING_NAMES;
    }
}

