/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.tentackle.model.ModelException;

public class EntityAliases
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;

    public EntityAliases() {
    }

    public EntityAliases(String str) throws ModelException {
        this.parse(str);
    }

    public void parse(String str) throws ModelException {
        this.clear();
        StringTokenizer stok = new StringTokenizer(str, ";,\n\r");
        while (stok.hasMoreTokens()) {
            String name;
            String token = stok.nextToken();
            int ndx = token.indexOf(61);
            if (ndx < 0) {
                throw new ModelException("missing delimiter '=' in entity alias: " + token);
            }
            String alias = token.substring(0, ndx).trim();
            String oldName = this.put(alias, name = token.substring(ndx + 1).trim());
            if (oldName == null || oldName.equals(name)) continue;
            throw new ModelException("alias '" + alias + "' already mapped to '" + oldName + "'");
        }
    }

    public String translate(String name) {
        String mappedName = (String)this.get(name);
        return mappedName == null ? name : mappedName;
    }
}

