/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import org.tentackle.model.ForeignKey;
import org.tentackle.model.ModelException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.ForeignKeyMetaData;

public class ForeignKeyMigrator {
    private final Backend backend;
    private final ForeignKey foreignKey;
    private final ForeignKeyMetaData foreignKeyMetaData;

    public ForeignKeyMigrator(Backend backend, ForeignKey foreignKey, ForeignKeyMetaData foreignKeyMetaData) {
        this.backend = backend;
        this.foreignKey = foreignKey;
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public String migrate() throws ModelException {
        StringBuilder buf = new StringBuilder();
        if (this.foreignKey == null) {
            buf.append(this.backend.sqlDropForeignKey(this.foreignKeyMetaData.getFullForeignKeyTableName(), this.foreignKeyMetaData.getForeignKeyName()));
        } else if (this.foreignKeyMetaData == null) {
            buf.append(this.foreignKey.sqlCreateForeignKey(this.backend));
        } else {
            throw new ModelException("cannot migrate existing foreign key");
        }
        return buf.toString();
    }
}

