/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.model.ModelDefaults;

public class PrintConfiguration {
    private final boolean printingAsComment;
    private final boolean usingVariables;
    private final ModelDefaults modelDefaults;
    private final List<String> optionAnnotations;
    private final int columnGap;

    public PrintConfiguration(boolean printingAsComment, boolean usingVariables, ModelDefaults modelDefaults, List<String> optionAnnotations, int columnGap) {
        this.printingAsComment = printingAsComment;
        this.usingVariables = usingVariables;
        this.modelDefaults = modelDefaults;
        this.optionAnnotations = optionAnnotations == null ? new ArrayList() : optionAnnotations;
        this.columnGap = Math.max(columnGap, 1);
    }

    public boolean isPrintingAsComment() {
        return this.printingAsComment;
    }

    public boolean isUsingVariables() {
        return this.usingVariables;
    }

    public ModelDefaults getModelDefaults() {
        return this.modelDefaults;
    }

    public List<String> getOptionAnnotations() {
        return this.optionAnnotations;
    }

    public int getColumnGap() {
        return this.columnGap;
    }

    public boolean isOptionAnnotation(String annotation) {
        for (String anno : this.optionAnnotations) {
            if (!annotation.startsWith(anno) || !annotation.equals(anno) && Character.isJavaIdentifierPart(annotation.charAt(anno.length()))) continue;
            return true;
        }
        return false;
    }
}

