/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.List;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactoryHolder;
import org.tentackle.model.Entity;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;

@Service(value=CodeFactory.class)
public class CodeFactory {
    public static CodeFactory getInstance() {
        return CodeFactoryHolder.INSTANCE;
    }

    public String createBindableAnnotation(Attribute attribute) {
        if (attribute.getOptions().isBindable()) {
            String bindOptions = attribute.getOptions().getBindOptions();
            if (StringHelper.isAllWhitespace((String)bindOptions)) {
                return "@Bindable";
            }
            return "@Bindable(options=\"" + bindOptions + "\")";
        }
        return null;
    }

    public String createMethodArgument(Attribute attribute, String value) throws ModelException {
        String downCast;
        DataType<?> dataType = attribute.getEffectiveDataType();
        if (dataType.isDowncastNecessary() && !((String)value).startsWith(downCast = "(" + dataType.getJavaType() + ")")) {
            value = downCast + " " + (String)value;
        }
        return value;
    }

    public String createGetterName(Attribute attribute) {
        StringBuilder buf = new StringBuilder();
        if (attribute.getDataType().isBool()) {
            buf.append("is");
        } else {
            buf.append("get");
        }
        buf.append(attribute.getMethodNameSuffix());
        return buf.toString();
    }

    public String createSetterName(Attribute attribute) {
        return "set" + attribute.getMethodNameSuffix();
    }

    public String createGetterName(Relation relation) {
        return "get" + relation.getMethodNameSuffix();
    }

    public String createSetterName(Relation relation) {
        return "set" + relation.getMethodNameSuffix();
    }

    public String createDeclaredJavaType(Relation relation, boolean withinForeignEntity) {
        Object type = relation.getClassName();
        if (relation.getForeignEntity().isAbstract()) {
            type = withinForeignEntity ? "T" : (String)type + "<?>";
        }
        if (relation.getRelationType() == RelationType.LIST && !relation.isReversed()) {
            return (relation.isTracked() ? "TrackedList" : "List") + "<" + (String)type + ">";
        }
        return type;
    }

    public String createJavaType(Relation relation) {
        if (relation.getRelationType() == RelationType.LIST && !relation.isReversed()) {
            return (relation.isTracked() ? "TrackedArrayList" : "ArrayList") + "<>";
        }
        return relation.getClassName();
    }

    public String createSqlTable(Entity entity, Backend backend) throws ModelException {
        String columnName;
        int columnIndex;
        DataType<?> dataType;
        StringBuilder buf = new StringBuilder();
        buf.append(backend.sqlCreateTableIntro(entity.getTableName(), entity.getOptions().getComment()));
        List<Attribute> tableAttributes = entity.getTableAttributes();
        int attributeNum = tableAttributes.size();
        int attributeCount = 1;
        for (Attribute attribute : tableAttributes) {
            dataType = attribute.getEffectiveDataType();
            for (columnIndex = 0; columnIndex < dataType.getColumnCount(backend); ++columnIndex) {
                buf.append("    ");
                columnName = attribute.getColumnName(backend, columnIndex);
                int size = dataType.getSize(backend, columnIndex, attribute.getSize());
                int scale = dataType.getScale(backend, columnIndex, attribute.getScale());
                Object comment = attribute.getOptions().getComment();
                if (comment != null && !((String)comment).isEmpty()) {
                    comment = (String)comment + String.valueOf(dataType.getCommentSuffix(backend, columnIndex).orElse(""));
                }
                Object defaultValue = dataType.getColumnValue(backend, columnIndex, attribute.getOptions().getDefaultValue());
                buf.append(backend.sqlCreateColumn(columnName, (String)comment, dataType.getSqlType(backend, columnIndex), size, scale, attribute.isNullable(), defaultValue, attribute.getName().equals("id") && !entity.getOptions().isNoPrimaryKey(), attributeCount < attributeNum || columnIndex < dataType.getColumnCount(backend) - 1));
            }
            ++attributeCount;
        }
        buf.append(backend.sqlCreateTableClosing(entity.getTableName(), entity.getOptions().getComment()));
        buf.append(backend.sqlCreateTableComment(entity.getTableName(), entity.getOptions().getComment()));
        for (Attribute attribute : tableAttributes) {
            dataType = attribute.getEffectiveDataType();
            for (columnIndex = 0; columnIndex < dataType.getColumnCount(backend); ++columnIndex) {
                columnName = attribute.getColumnName(backend, columnIndex);
                Object comment = attribute.getOptions().getComment();
                if (comment != null && !((String)comment).isEmpty()) {
                    comment = (String)comment + String.valueOf(dataType.getCommentSuffix(backend, columnIndex).orElse(""));
                }
                buf.append(backend.sqlCreateColumnComment(entity.getTableName(), columnName, (String)comment));
            }
        }
        return buf.toString();
    }

    public String createSqlIndex(Backend backend, Entity entity, Index index) {
        StringBuilder buf = new StringBuilder();
        if (index.getComment() != null) {
            buf.append(backend.getSingleLineComment()).append(' ');
            buf.append(index.getComment());
            buf.append('\n');
        }
        String[] columnNames = new String[index.getAttributes().size()];
        int attributeCount = 0;
        for (IndexAttribute indexAttribute : index.getAttributes()) {
            Object indexPart = indexAttribute.getFunctionName() != null ? indexAttribute.getFunctionName() + "(" + indexAttribute.getColumnName() + ")" : indexAttribute.getColumnName();
            columnNames[attributeCount] = indexAttribute.isDescending() ? "-" + (String)indexPart : indexPart;
            ++attributeCount;
        }
        buf.append(backend.sqlCreateIndex(entity.getTableName(), index.createDatabaseIndexName(entity), index.isUnique(), index.getFilterCondition(), columnNames));
        return buf.toString();
    }

    public String createSqlForeignKey(ForeignKey foreignKey, Backend backend) {
        return backend.sqlCreateForeignKey(foreignKey.getReferencingTableProvidingEntity().getTableName(), foreignKey.getReferencingAttribute().getColumnName(), foreignKey.getReferencedTableProvidingEntity().getTableName(), foreignKey.getReferencedAttribute().getColumnName(), foreignKey.getReferencingEntity().getTableAlias() + "_" + foreignKey.getReferencingAttribute().getColumnName() + "_fkey", foreignKey.isComposite() && foreignKey.getReferencingEntity().getIntegrity().isCompositesCheckedByDatabase());
    }
}

