/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.print;

import org.tentackle.common.StringHelper;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.model.print.PrintConfiguration;

public class IndexPrinter {
    private final Index index;
    private final PrintConfiguration configuration;

    public IndexPrinter(Index index, PrintConfiguration configuration) {
        this.index = index;
        this.configuration = configuration;
    }

    public String print() {
        StringBuilder buf = new StringBuilder();
        if (!StringHelper.isAllWhitespace((String)this.index.getComment())) {
            if (this.configuration.isPrintingAsComment()) {
                buf.append(" * ");
            }
            buf.append("# ").append(this.index.getComment()).append('\n');
        }
        if (this.configuration.isPrintingAsComment()) {
            buf.append(" * ");
        }
        if (this.index.isUnique()) {
            buf.append("unique ");
        }
        buf.append("index ").append(this.index.getName()).append(" := ");
        boolean needComma = false;
        for (IndexAttribute attr : this.index.getAttributes()) {
            if (needComma) {
                buf.append(", ");
            } else {
                needComma = true;
            }
            if (attr.isDescending()) {
                buf.append('-');
            } else {
                buf.append('+');
            }
            buf.append(attr.getAttribute().getColumnName());
        }
        if (this.index.getFilterCondition() != null) {
            buf.append(" | ").append(this.index.getFilterCondition());
        }
        buf.append('\n');
        return buf.toString();
    }
}

