/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.CodeFactory;
import org.tentackle.model.Entity;
import org.tentackle.model.Index;
import org.tentackle.model.IndexAttribute;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelException;
import org.tentackle.model.NameVerifier;
import org.tentackle.model.SourceInfo;
import org.tentackle.model.impl.EntityFactoryImpl;
import org.tentackle.model.impl.IndexAttributeImpl;
import org.tentackle.model.parse.ConfigurationLine;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlNameType;

public class IndexImpl
implements Index {
    private final Entity entity;
    private final EntityFactoryImpl factory;
    private final SourceInfo sourceInfo;
    private final List<IndexAttribute> attributes;
    private ConfigurationLine sourceLine;
    private String name;
    private String comment;
    private boolean unique;
    private String filterCondition;
    private boolean parsed;

    public IndexImpl(EntityFactoryImpl factory, Entity entity, SourceInfo sourceInfo) {
        this.entity = entity;
        this.sourceInfo = sourceInfo;
        this.factory = factory;
        this.attributes = new ArrayList<IndexAttribute>();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public ModelElement getParent() {
        return this.entity;
    }

    public void parse(Entity entity) throws ModelException {
        this.parsed = true;
        StringTokenizer stok = new StringTokenizer(this.sourceLine.getKey());
        boolean indexFound = false;
        boolean uniqueFound = false;
        block8: while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            switch (token.toLowerCase()) {
                case "index": {
                    this.setUnique(uniqueFound);
                    indexFound = true;
                    uniqueFound = false;
                    continue block8;
                }
                case "unique": {
                    if (indexFound) {
                        throw this.sourceLine.createModelException("keyword 'unique' not allowed after 'index'");
                    }
                    uniqueFound = true;
                    continue block8;
                }
            }
            if (!indexFound) {
                throw this.sourceLine.createModelException("unknown configuration keyword: " + token);
            }
            int ndx = token.indexOf(46);
            if (ndx > 0) {
                token = token.substring(ndx + 1);
            }
            this.setName(token);
        }
        if (!indexFound) {
            throw this.sourceLine.createModelException("illegal configuration: " + this.sourceLine.getKey());
        }
        if (entity.getAttributes().isEmpty()) {
            throw this.sourceLine.createModelException("index configuration line not allowed before attribute section");
        }
        String text = this.sourceLine.getValue();
        int ndx = text.indexOf(124);
        if (ndx > 0) {
            this.setFilterCondition(text.substring(ndx + 1));
            text = text.substring(0, ndx);
        } else {
            ndx = text.toUpperCase().indexOf("WHERE");
            if (ndx > 0) {
                this.setFilterCondition(text.substring(ndx + 5));
                text = text.substring(0, ndx);
            }
        }
        stok = new StringTokenizer(text, " \t,");
        IndexAttributeImpl indexAttribute = null;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (token.toLowerCase().equals("desc")) {
                if (indexAttribute == null) {
                    throw this.sourceLine.createModelException("keyword 'desc' must follow column name");
                }
                indexAttribute.setDescending(true);
                continue;
            }
            if (token.toLowerCase().equals("asc")) {
                if (indexAttribute == null) {
                    throw this.sourceLine.createModelException("keyword 'asc' must follow column name");
                }
                indexAttribute.setDescending(false);
                continue;
            }
            if (indexAttribute != null) {
                this.getAttributes().add(indexAttribute);
                indexAttribute = null;
            }
            Boolean descending = null;
            if (token.startsWith("+")) {
                descending = Boolean.FALSE;
                token = token.substring(1);
            }
            if (token.startsWith("-")) {
                descending = Boolean.TRUE;
                token = token.substring(1);
            }
            for (Attribute attribute : entity.getAttributes()) {
                if (!attribute.getColumnName().equals(token) && !attribute.getName().equals(token)) continue;
                indexAttribute = this.factory.createIndexAttribute(this);
                indexAttribute.setAttribute(attribute);
                if (descending == null) break;
                indexAttribute.setDescending(descending);
                break;
            }
            if (indexAttribute != null) continue;
            throw this.sourceLine.createModelException("undefined column name: " + token);
        }
        if (indexAttribute != null) {
            this.getAttributes().add(indexAttribute);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String createDatabaseIndexName(Entity entity) {
        return entity.getTableNameWithoutSchema() + "_" + this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @Override
    public List<IndexAttribute> getAttributes() {
        return this.attributes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = StringHelper.isAllWhitespace((String)filterCondition) ? null : filterCondition.trim();
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public void validate() throws ModelException {
        if (this.getEntity().getOptions().isProvided()) {
            throw this.createModelException("[PROVIDED] entities cannot have index definitions");
        }
        if (StringHelper.isAllWhitespace((String)this.getName())) {
            throw this.createModelException("missing index name");
        }
        String diag = NameVerifier.getInstance().verifyIndexName(this);
        if (diag != null) {
            throw this.createModelException(diag);
        }
        for (Backend backend : this.factory.getBackends()) {
            try {
                backend.assertValidName(SqlNameType.INDEX_NAME, this.createDatabaseIndexName(this.entity));
            }
            catch (RuntimeException rex) {
                throw new ModelException(rex.getMessage(), this, rex);
            }
        }
        if (this.getAttributes().isEmpty()) {
            throw this.createModelException("index " + this + " does not contain any attributes");
        }
    }

    public ConfigurationLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(ConfigurationLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    public ModelException createModelException(String message) {
        ModelException ex = this.sourceLine != null ? this.sourceLine.createModelException(message) : new ModelException(message, this.entity);
        return ex;
    }

    @Override
    public String sqlCreateIndex(Backend backend, Entity entity) {
        return CodeFactory.getInstance().createSqlIndex(backend, entity, this);
    }

    public boolean isLogicallyEqualTo(Index otherIndex) {
        boolean logicallyEqual = true;
        if (Objects.equals(this.getFilterCondition(), otherIndex.getFilterCondition())) {
            if (this.getAttributes().size() == otherIndex.getAttributes().size()) {
                for (int position = 0; position < this.getAttributes().size(); ++position) {
                    IndexAttribute indexAttribute = this.getAttributes().get(position);
                    IndexAttribute otherAttribute = otherIndex.getAttributes().get(position);
                    if (!indexAttribute.isDescending() != otherAttribute.isDescending() && indexAttribute.getAttribute().getColumnName().equals(otherAttribute.getAttribute().getColumnName())) continue;
                    logicallyEqual = false;
                    break;
                }
            } else {
                logicallyEqual = false;
            }
        } else {
            logicallyEqual = false;
        }
        return logicallyEqual;
    }
}

