/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model;

import java.util.Collection;
import org.tentackle.model.ModelElement;
import org.tentackle.model.ModelError;

public class ModelException
extends Exception {
    private static final long serialVersionUID = 3405985077474898397L;
    private ModelElement element;
    public static final String AT_ELEMENT = " @ ";

    public ModelException(String message, ModelElement element, Throwable cause) {
        super(message, cause);
        this.element = element;
    }

    public ModelException(String message, ModelElement element) {
        super(message);
        this.element = element;
    }

    public ModelException(String message, Throwable cause) {
        super(message, cause);
    }

    public ModelException(String message) {
        super(message);
    }

    public ModelException(Collection<ModelError> errors) {
        super(ModelError.toString(errors));
        for (ModelError error : errors) {
            if (error.getElement() == null) continue;
            this.element = error.getElement();
            break;
        }
    }

    public ModelElement getElement() {
        return this.element;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (!(this.element == null || message != null && message.contains(AT_ELEMENT) || this.element.getSourceInfo() == null)) {
            return message + AT_ELEMENT + this.element.getSourceInfo();
        }
        return message;
    }

    public boolean isRelatedTo(ModelElement otherElement) {
        for (ModelElement elem = this.element; elem != null; elem = elem.getParent()) {
            if (!elem.equals(otherElement)) continue;
            return true;
        }
        return false;
    }
}

