/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.model.migrate;

import java.util.Collection;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.ModelException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.ColumnMetaData;

public class ColumnMigrator {
    private final Entity entity;
    private final Attribute attribute;
    private final Backend backend;
    private final ColumnMetaData[] columns;
    private ColumnMetaData column;
    private String columnName;
    private String comment;
    private SqlType sqlType;
    private int columnSize;
    private int columnScale;
    private Object defaultValue;

    public ColumnMigrator(Entity entity, Attribute attribute, Backend backend, ColumnMetaData ... columns) {
        this.entity = entity;
        this.attribute = attribute;
        this.backend = backend;
        this.columns = columns;
    }

    public ColumnMigrator(Entity entity, Attribute attribute, Backend backend, Collection<ColumnMetaData> columns) {
        this.entity = entity;
        this.attribute = attribute;
        this.backend = backend;
        this.columns = columns == null || columns.isEmpty() ? null : columns.toArray(new ColumnMetaData[columns.size()]);
    }

    public Backend getBackend() {
        return this.backend;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public ColumnMetaData[] getColumns() {
        return this.columns;
    }

    public String migrate() throws ModelException {
        StringBuilder buf = new StringBuilder();
        if (this.attribute != null) {
            DataType dataType = this.attribute.getEffectiveType();
            int migratedColumnIndex = 0;
            boolean[] migrated = new boolean[dataType.getSqlTypes().length];
            for (int round = 0; round < 2; ++round) {
                int multiColumnIndex = 0;
                for (DataType.SqlTypeWithPostfix sp : dataType.getSqlTypesWithPostfix()) {
                    if (!migrated[multiColumnIndex]) {
                        this.columnName = this.attribute.getColumnName() + sp.getPostfix();
                        this.sqlType = sp.getSqlType();
                        this.columnSize = this.attribute.getSizeWithDefault();
                        this.columnScale = this.attribute.getScaleWithDefault();
                        this.comment = multiColumnIndex == 0 ? this.attribute.getOptions().getComment() : null;
                        this.defaultValue = this.attribute.getOptions().getDefaultValue();
                        if (multiColumnIndex > 0 && this.defaultValue != null) {
                            this.defaultValue = this.sqlType.getDefaultValue();
                        }
                        if (dataType.isScaleInSecondColumn()) {
                            if (multiColumnIndex == 1) {
                                this.columnSize = 0;
                            }
                            this.columnScale = 0;
                        }
                        ColumnMetaData columnMetaData = this.column = this.columns == null || migratedColumnIndex >= this.columns.length ? null : this.columns[migratedColumnIndex];
                        if (this.column == null) {
                            buf.append(this.addColumn());
                            migrated[multiColumnIndex] = true;
                        } else if (round == 1 || this.column.getColumnName().equals(this.columnName)) {
                            buf.append(this.migrateColumn());
                            ++migratedColumnIndex;
                            migrated[multiColumnIndex] = true;
                        }
                    }
                    ++multiColumnIndex;
                }
            }
        } else {
            for (ColumnMetaData col : this.columns) {
                buf.append(this.dropColumn(col));
            }
        }
        return buf.toString();
    }

    private String addColumn() throws ModelException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.backend.sqlAddColumn(this.entity.getTableName(), this.columnName, this.comment, this.sqlType, this.columnSize, this.columnScale, this.attribute.isNullable() || this.defaultValue == null, this.defaultValue));
        if (!this.attribute.isNullable() && this.defaultValue == null) {
            buf.append(this.updateToNotNull());
            buf.append(this.alterNull());
        }
        if (this.comment != null) {
            buf.append(this.backend.sqlCreateColumnComment(this.entity.getTableName(), this.columnName, this.comment));
        }
        return buf.toString();
    }

    private String dropColumn(ColumnMetaData column) {
        return this.backend.sqlDropColumn(this.entity.getTableName(), column.getColumnName());
    }

    private String migrateColumn() throws ModelException {
        MigrationStrategy[] strategies;
        StringBuilder buf = new StringBuilder();
        block9: for (MigrationStrategy strategy : strategies = this.backend.getMigrationStrategy(this.column, this.columnName, this.comment, this.sqlType, this.columnSize, this.columnScale, this.attribute.isNullable(), this.defaultValue)) {
            switch (strategy) {
                case NAME: {
                    buf.append(this.alterName());
                    continue block9;
                }
                case TYPE: {
                    buf.append(this.alterType());
                    continue block9;
                }
                case TYPE_WARNING: {
                    buf.append("-- ").append(this.alterType());
                    continue block9;
                }
                case NAME_AND_TYPE: {
                    buf.append(this.alterNameAndType());
                    continue block9;
                }
                case NULL: {
                    if (!this.attribute.isNullable()) {
                        buf.append(this.updateToNotNull());
                    }
                    buf.append(this.alterNull());
                    continue block9;
                }
                case DEFAULT: {
                    buf.append(this.alterDefault());
                    continue block9;
                }
                case COMMENT: {
                    buf.append(this.alterComment());
                }
            }
        }
        return buf.toString();
    }

    private String alterType() throws ModelException {
        return this.toNonNullString(this.backend.sqlAlterColumnType(this.entity.getTableName(), this.columnName, this.comment, this.sqlType, this.columnSize, this.columnScale, this.attribute.isNullable(), this.defaultValue));
    }

    private String updateToNotNull() {
        return this.toNonNullString(this.backend.sqlUpdateToNotNull(this.entity.getTableName(), this.columnName, this.sqlType, this.defaultValue));
    }

    private String alterNull() throws ModelException {
        return this.toNonNullString(this.backend.sqlAlterColumnNullConstraint(this.entity.getTableName(), this.columnName, this.attribute.isNullable()));
    }

    private String alterName() {
        return this.toNonNullString(this.backend.sqlRenameColumn(this.entity.getTableName(), this.column.getColumnName(), this.columnName));
    }

    private String alterNameAndType() throws ModelException {
        return this.toNonNullString(this.backend.sqlRenameAndAlterColumnType(this.entity.getTableName(), this.column.getColumnName(), this.columnName, this.comment, this.sqlType, this.columnSize, this.columnScale, this.attribute.isNullable(), this.defaultValue));
    }

    private String alterComment() {
        return this.toNonNullString(this.backend.sqlAlterColumnComment(this.entity.getTableName(), this.columnName, this.comment));
    }

    private String alterDefault() {
        return this.toNonNullString(this.backend.sqlAlterColumnDefault(this.entity.getTableName(), this.columnName, this.sqlType, this.defaultValue));
    }

    private String toNonNullString(String sql) {
        if (sql == null) {
            return "";
        }
        return sql;
    }
}

