/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.tentackle.common.StringHelper;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.wurbelizer.wurbel.WurbelException;

public class PdoRelations
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + this + " failed", t);
        }
    }

    private void wurbel() throws WurbelException, ModelException {
        String var;
        boolean useDatabaseRefInt;
        String mainClass = this.getClassName();
        String pdoName = null;
        try {
            pdoName = this.getPdoClassName();
        }
        catch (WurbelException we) {
            pdoName = this.getClassName();
        }
        boolean generateDeclarations = false;
        boolean generateIsModified = false;
        boolean generateIsComposite = false;
        boolean generateSaveReferencingRelations = false;
        boolean generateSaveReferencedRelations = false;
        boolean generateDeleteReferencingRelations = false;
        boolean generateDeleteReferencedRelations = false;
        boolean generateLazyDeleteReferencingRelations = false;
        boolean generateLazyDeleteReferencedRelations = false;
        boolean generateSetSession = false;
        Boolean generateLoadComponents = null;
        Boolean generateInsertComponents = null;
        Boolean generateDeleteComponents = null;
        boolean generateMarkDeleted = false;
        boolean generateIsReferencing = true;
        boolean generateAddReferencing = false;
        boolean generateSelects = true;
        boolean generateDeletes = true;
        Boolean generateValidate = null;
        boolean generateSetImmutable = false;
        boolean generateSnapshot = false;
        boolean generateClearOnRemoteSave = false;
        boolean generateAlignComponents = false;
        for (Object rel : this.getEntity().getReferencingRelations()) {
            if (rel.isComposite() || rel.getRelationType() != RelationType.OBJECT || rel.getForeignEntity() == null || !rel.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
            generateAddReferencing = true;
            break;
        }
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("noloadcomponents")) {
                generateLoadComponents = false;
                continue;
            }
            if (arg.equals("noinsertcomponents")) {
                generateInsertComponents = false;
                continue;
            }
            if (arg.equals("nodeletecomponents")) {
                generateDeleteComponents = false;
                continue;
            }
            if (arg.equals("novalidate")) {
                generateValidate = false;
                continue;
            }
            if (arg.equals("loadcomponents")) {
                generateLoadComponents = true;
                continue;
            }
            if (arg.equals("insertcomponents")) {
                generateInsertComponents = true;
                continue;
            }
            if (arg.equals("deletecomponents")) {
                generateDeleteComponents = true;
                continue;
            }
            if (arg.equals("nori")) {
                generateIsReferencing = false;
                generateAddReferencing = false;
                continue;
            }
            if (arg.equals("noselects")) {
                generateSelects = false;
                continue;
            }
            if (!arg.equals("nodeletes")) continue;
            generateDeletes = false;
        }
        for (Object rel : this.getEntity().getRelations()) {
            if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                generateDeclarations = true;
                if (!rel.isSelectionCached()) {
                    generateSetSession = true;
                }
            }
            if (rel.isComposite()) {
                generateIsComposite = true;
                generateDeclarations = true;
                generateIsModified = true;
                generateSetSession = true;
                generateMarkDeleted = true;
                generateSnapshot = true;
                generateSetImmutable = true;
                if (generateValidate == null) {
                    generateValidate = true;
                }
                if (rel.getRelationType() == RelationType.OBJECT) {
                    generateSaveReferencedRelations = true;
                    generateDeleteReferencedRelations = true;
                    generateLazyDeleteReferencedRelations = true;
                } else {
                    generateSaveReferencingRelations = true;
                    generateDeleteReferencingRelations = true;
                    if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        generateLazyDeleteReferencingRelations = true;
                        if (rel.getCountAttribute() != null) {
                            generateAlignComponents = true;
                        }
                    }
                }
            }
            if (!rel.isClearOnRemoteSave()) continue;
            generateClearOnRemoteSave = true;
        }
        boolean bl = useDatabaseRefInt = this.getEntity().getIntegrity().isCompositesCheckedByDatabase() && Boolean.FALSE.equals(this.getEntity().isDeletionCascaded());
        if (generateLoadComponents == null) {
            generateLoadComponents = generateIsComposite;
        }
        if (generateInsertComponents == null) {
            generateInsertComponents = generateIsComposite;
        }
        if (generateDeleteComponents == null) {
            generateDeleteComponents = generateIsComposite && (!useDatabaseRefInt || this.getEntity().isRootEntity());
        }
        if (generateDeclarations) {
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
                    String type = rel.getDeclaredJavaType(false);
                    String transientModifier = this.isRelationTransient((Relation)rel) ? "transient " : "";
                    this.out.print(this.source[0]);
                    this.out.print(rel);
                    this.out.print(this.source[1]);
                    this.out.print(transientModifier);
                    this.out.print(type);
                    this.out.print(this.source[2]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[3]);
                    if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        this.out.print(this.source[4]);
                        this.out.print(transientModifier);
                        this.out.print(this.source[5]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[6]);
                    }
                    if (rel.isComposite()) {
                        if (rel.getRelationType() == RelationType.OBJECT || rel.isTracked()) {
                            this.out.print(this.source[7]);
                            this.out.print(type);
                            this.out.print(this.source[8]);
                            this.out.print(rel.getVariableName());
                            this.out.print(this.source[9]);
                        }
                        if (rel.getRelationType() == RelationType.OBJECT) {
                            this.out.print(this.source[10]);
                            this.out.print(rel.getVariableName());
                            this.out.print(this.source[11]);
                        }
                    }
                }
                if (rel.getNmName() == null) continue;
                Object nmVar = rel.getNmMethodName() != null ? StringHelper.firstToLower((String)rel.getNmMethodName()) : StringHelper.firstToLower((String)rel.getNmName()) + "List";
                this.out.print(this.source[12]);
                this.out.print(rel.getNmRelation().getDeclaredJavaType(false));
                this.out.print(this.source[13]);
                this.out.print((String)nmVar);
                this.out.print(this.source[14]);
            }
        }
        if (generateClearOnRemoteSave) {
            this.out.print(this.source[15]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isClearOnRemoteSave()) continue;
                this.out.print(this.source[16]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[17]);
                if (rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
                this.out.print(this.source[18]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[19]);
            }
            this.out.print(this.source[20]);
        }
        for (Object rel : this.getEntity().getRelations()) {
            String linkMethodName;
            var = rel.getVariableName();
            String type = rel.getDeclaredJavaType(false);
            String effType = rel.getJavaType();
            String scope = rel.getAccessScope().toString();
            boolean hidden = rel.getAccessScope() != AccessScope.PUBLIC;
            boolean createGetter = !rel.isWriteOnly();
            boolean createSetter = !(rel.isReadOnly() || rel.getSelectionType() == SelectionType.ALWAYS && !rel.isSelectionCached() || rel.isComposite() && rel.getRelationType() != RelationType.OBJECT);
            Attribute attr = rel.getAttribute();
            if (attr != null) {
                scope = attr.getOptions().getAccessScope().toString();
                hidden |= attr.isHidden();
                createGetter &= !attr.getOptions().isWriteOnly();
                createSetter &= !attr.getOptions().isReadOnly();
            }
            if (rel.getForeignRelation() != null && (linkMethodName = rel.getForeignRelation().getLinkMethodName()) != null && !rel.getSetterName().equals(linkMethodName)) {
                createSetter = false;
            }
            Relation nmRel = rel.getNmRelation();
            Object nmName = null;
            Object nmVar = null;
            if (nmRel != null) {
                if (rel.getNmMethodName() != null) {
                    nmName = StringHelper.firstToUpper((String)rel.getNmMethodName());
                    nmVar = StringHelper.firstToLower((String)rel.getNmMethodName());
                } else {
                    nmName = StringHelper.firstToUpper((String)rel.getNmName()) + "Via" + rel.getMethodNameSuffix();
                    nmVar = StringHelper.firstToLower((String)rel.getNmName()) + "List";
                }
            }
            if (createGetter) {
                String checkNull = ((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument() + " == 0";
                if (attr != null && !attr.getDataType().isPrimitive()) {
                    checkNull = ((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument() + " == null || " + checkNull;
                }
                this.out.print(this.source[21]);
                if (!hidden) {
                    this.out.print(this.source[22]);
                }
                if (rel.getForeignEntity().isAbstract()) {
                    this.out.print(this.source[23]);
                }
                this.out.print(this.source[24]);
                this.out.print(scope);
                this.out.print(this.source[25]);
                this.out.print(type);
                this.out.print(this.source[26]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[27]);
                if (rel.getSelectionType() == SelectionType.ALWAYS) {
                    if (rel.getRelationType() == RelationType.LIST) {
                        if (rel.isSelectionCached()) {
                            this.out.print(this.source[28]);
                            this.out.print(var);
                            this.out.print(this.source[29]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[30]);
                        } else {
                            this.out.print(this.source[31]);
                            this.out.print(type);
                            this.out.print(this.source[32]);
                            this.out.print(var);
                            this.out.print(this.source[33]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[34]);
                        }
                        if (rel.isReferenced()) {
                            if (rel.getLinkMethodIndex() != null) {
                                this.out.print(this.source[35]);
                            }
                            this.out.print(this.source[36]);
                            this.out.print(rel.getClassName());
                            this.out.print(this.source[37]);
                            this.out.print(var);
                            this.out.print(this.source[38]);
                            this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                            this.out.print(this.source[39]);
                        }
                        this.out.print(this.source[40]);
                        this.out.print(var);
                        this.out.print(this.source[41]);
                    } else if (rel.isComposite()) {
                        this.out.print(this.source[42]);
                        this.out.print(var);
                        this.out.print(this.source[43]);
                        this.out.print(checkNull);
                        this.out.print(this.source[44]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[45]);
                        if (rel.isReferenced()) {
                            this.out.print(this.source[46]);
                            this.out.print(var);
                            this.out.print(this.source[47]);
                            this.out.print(var);
                            this.out.print(this.source[48]);
                            this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                            this.out.print(this.source[49]);
                        }
                        if (rel.isProcessed()) {
                            this.out.print(this.source[50]);
                            this.out.print(var);
                            this.out.print(this.source[51]);
                            this.out.print(rel.getMethodNameSuffix());
                            this.out.print(this.source[52]);
                            this.out.print(var);
                            this.out.print(this.source[53]);
                        }
                        this.out.print(this.source[54]);
                        this.out.print(var);
                        this.out.print(this.source[55]);
                    } else if (rel.isReferenced()) {
                        this.out.print(this.source[56]);
                        this.out.print(type);
                        this.out.print(this.source[57]);
                        this.out.print(checkNull);
                        this.out.print(this.source[58]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[59]);
                        this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                        this.out.print(this.source[60]);
                    } else {
                        this.out.print(this.source[61]);
                        this.out.print(checkNull);
                        this.out.print(this.source[62]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[63]);
                    }
                } else if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[64]);
                    this.out.print(var);
                    this.out.print(this.source[65]);
                    if (rel.isComposite()) {
                        if (rel.getRelationType() == RelationType.LIST) {
                            Object condition = "isNew()";
                            Attribute countAttribute = rel.getCountAttribute();
                            if (countAttribute != null) {
                                condition = (String)condition + " || " + countAttribute.getName() + " == 0";
                            }
                            this.out.print(this.source[66]);
                            this.out.print(var);
                            this.out.print(this.source[67]);
                            this.out.print((String)condition);
                            this.out.print(this.source[68]);
                            this.out.print(effType);
                            this.out.print(this.source[69]);
                            this.out.print(rel.isTracked() ? "false" : "");
                            this.out.print(this.source[70]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[71]);
                            if (rel.isReferenced()) {
                                if (rel.getLinkMethodIndex() != null) {
                                    this.out.print(this.source[72]);
                                }
                                this.out.print(this.source[73]);
                                this.out.print(rel.getClassName());
                                this.out.print(this.source[74]);
                                this.out.print(var);
                                this.out.print(this.source[75]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[76]);
                            }
                        } else {
                            this.out.print(this.source[77]);
                            this.out.print(var);
                            this.out.print(this.source[78]);
                            this.out.print(checkNull);
                            this.out.print(this.source[79]);
                            this.out.print(this.createRelationSelectCode((Relation)rel));
                            this.out.print(this.source[80]);
                            if (rel.isReferenced()) {
                                this.out.print(this.source[81]);
                                this.out.print(var);
                                this.out.print(this.source[82]);
                                this.out.print(var);
                                this.out.print(this.source[83]);
                                this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                                this.out.print(this.source[84]);
                            }
                        }
                        if (rel.isProcessed()) {
                            this.out.print(this.source[85]);
                            this.out.print(var);
                            this.out.print(this.source[86]);
                            this.out.print(rel.getMethodNameSuffix());
                            this.out.print(this.source[87]);
                            this.out.print(var);
                            this.out.print(this.source[88]);
                        }
                        if (rel.getRelationType() == RelationType.LIST) {
                            if (rel.isTracked()) {
                                if (rel.isImmutable()) {
                                    this.out.print(this.source[89]);
                                    this.out.print(var);
                                    this.out.print(this.source[90]);
                                } else {
                                    this.out.print(this.source[91]);
                                    this.out.print(var);
                                    this.out.print(this.source[92]);
                                }
                            }
                        } else if (rel.isImmutable()) {
                            this.out.print(this.source[93]);
                            this.out.print(var);
                            this.out.print(this.source[94]);
                        } else {
                            this.out.print(this.source[95]);
                            this.out.print(var);
                            this.out.print(this.source[96]);
                            this.out.print(var);
                            this.out.print(this.source[97]);
                        }
                    } else if (rel.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[98]);
                        this.out.print(var);
                        this.out.print(this.source[99]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[100]);
                        if (rel.isReferenced()) {
                            if (rel.getLinkMethodIndex() != null) {
                                this.out.print(this.source[101]);
                            }
                            this.out.print(this.source[102]);
                            this.out.print(rel.getClassName());
                            this.out.print(this.source[103]);
                            this.out.print(var);
                            this.out.print(this.source[104]);
                            this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                            this.out.print(this.source[105]);
                        }
                    } else {
                        this.out.print(this.source[106]);
                        this.out.print(var);
                        this.out.print(this.source[107]);
                        this.out.print(checkNull);
                        this.out.print(this.source[108]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[109]);
                        if (rel.isReferenced()) {
                            this.out.print(this.source[110]);
                            this.out.print(var);
                            this.out.print(this.source[111]);
                            this.out.print(var);
                            this.out.print(this.source[112]);
                            this.out.print(this.createRelationUpdateReferenceCode((Relation)rel));
                            this.out.print(this.source[113]);
                        }
                    }
                    this.out.print(this.source[114]);
                    this.out.print(var);
                    this.out.print(this.source[115]);
                    if (nmRel != null) {
                        this.out.print(this.source[116]);
                        this.out.print(var);
                        this.out.print(this.source[117]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[118]);
                        this.out.print((String)nmName);
                        this.out.print(this.source[119]);
                        this.out.print(nmRel.getGetterName());
                        this.out.print(this.source[120]);
                        this.out.print(rel.getClassName());
                        this.out.print(this.source[121]);
                        this.out.print((String)nmName);
                        this.out.print(this.source[122]);
                        this.out.print(nmRel.getGetterName());
                        this.out.print(this.source[123]);
                    }
                    this.out.print(this.source[124]);
                    this.out.print(var);
                    this.out.print(this.source[125]);
                }
                this.out.print(this.source[126]);
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    if (rel.getRelationType() == RelationType.LIST && !rel.isReversed()) {
                        this.out.print(this.source[127]);
                        this.out.print(var);
                        this.out.print(this.source[128]);
                        this.out.print(var);
                        this.out.print(this.source[129]);
                        this.out.print(rel.getComment());
                        this.out.print(this.source[130]);
                        this.out.print(scope);
                        this.out.print(this.source[131]);
                        this.out.print(type);
                        this.out.print(this.source[132]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[133]);
                        this.out.print(var);
                        this.out.print(this.source[134]);
                        this.out.print(var);
                        this.out.print(this.source[135]);
                        this.out.print(effType);
                        this.out.print(this.source[136]);
                        this.out.print(rel.isTracked() ? "false" : "");
                        this.out.print(this.source[137]);
                        this.out.print(var);
                        this.out.print(this.source[138]);
                        this.out.print(var);
                        this.out.print(this.source[139]);
                        this.out.print(var);
                        this.out.print(this.source[140]);
                    } else if (rel.getRelationType() == RelationType.OBJECT && rel.isSerialized()) {
                        this.out.print(this.source[141]);
                        this.out.print(var);
                        this.out.print(this.source[142]);
                        this.out.print(var);
                        this.out.print(this.source[143]);
                        this.out.print(rel.getComment());
                        this.out.print(this.source[144]);
                        this.out.print(scope);
                        this.out.print(this.source[145]);
                        this.out.print(type);
                        this.out.print(this.source[146]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[147]);
                        this.out.print(var);
                        this.out.print(this.source[148]);
                    }
                }
                if (nmRel != null) {
                    String nmType = nmRel.getDeclaredJavaType(false);
                    this.out.print(this.source[149]);
                    this.out.print(nmType);
                    this.out.print(this.source[150]);
                    this.out.print((String)nmName);
                    this.out.print(this.source[151]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[152]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[153]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[154]);
                    this.out.print(rel.getForeignEntity());
                    this.out.print(this.source[155]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[156]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[157]);
                    this.out.print(nmRel.getGetterName());
                    this.out.print(this.source[158]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[159]);
                    this.out.print(nmType);
                    this.out.print(this.source[160]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[161]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[162]);
                    this.out.print(nmRel.getSetterName());
                    this.out.print(this.source[163]);
                    this.out.print(nmType);
                    this.out.print(this.source[164]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[165]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[166]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[167]);
                    this.out.print(nmRel.getGetterName());
                    this.out.print(this.source[168]);
                    this.out.print((String)nmVar);
                    this.out.print(this.source[169]);
                }
                if (rel.isComposite() && (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER)) {
                    if (rel.getAccessScope() == AccessScope.PUBLIC) {
                        this.out.print(this.source[170]);
                    } else {
                        this.out.print(this.source[171]);
                        this.out.print(rel.getName());
                        this.out.print(this.source[172]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[173]);
                    }
                    this.out.print(this.source[174]);
                    this.out.print(scope);
                    this.out.print(this.source[175]);
                    this.out.print(StringHelper.firstToUpper((String)var));
                    this.out.print(this.source[176]);
                    this.out.print(var);
                    this.out.print(this.source[177]);
                }
            }
            if (createSetter) {
                String nullVal = attr != null && !attr.getDataType().isPrimitive() ? "null" : "0";
                String linkMethodIndex = rel.getForeignRelation() != null ? rel.getForeignRelation().getLinkMethodIndex() : null;
                this.out.print(this.source[178]);
                if (!hidden) {
                    this.out.print(this.source[179]);
                }
                if (linkMethodIndex != null) {
                    this.out.print(this.source[180]);
                    this.out.print(scope);
                    this.out.print(this.source[181]);
                    this.out.print(rel.getForeignRelation().getLinkMethodName());
                    this.out.print(this.source[182]);
                    this.out.print(type);
                    this.out.print(this.source[183]);
                    this.out.print(var);
                    this.out.print(this.source[184]);
                } else {
                    this.out.print(this.source[185]);
                    this.out.print(scope);
                    this.out.print(this.source[186]);
                    this.out.print(rel.getSetterName());
                    this.out.print(this.source[187]);
                    this.out.print(type);
                    this.out.print(this.source[188]);
                    this.out.print(var);
                    this.out.print(this.source[189]);
                }
                if (!rel.isReversed()) {
                    this.out.print(this.source[190]);
                }
                if (rel.getRelationType() == RelationType.LIST && !rel.isReversed() || rel.getSelectionType() != SelectionType.ALWAYS || rel.isComposite()) {
                    if (rel.isComposite() && rel.getRelationType() == RelationType.OBJECT) {
                        this.out.print(this.source[191]);
                        this.out.print(var);
                        this.out.print(this.source[192]);
                        this.out.print(var);
                        this.out.print(this.source[193]);
                    }
                    this.out.print(this.source[194]);
                    this.out.print(var);
                    this.out.print(this.source[195]);
                    this.out.print(var);
                    this.out.print(this.source[196]);
                    if (linkMethodIndex != null) {
                        this.out.print(this.source[197]);
                        this.out.print(StringHelper.firstToUpper((String)linkMethodIndex));
                        this.out.print(this.source[198]);
                    }
                }
                if (rel.getRelationType() == RelationType.OBJECT) {
                    if (rel.isComposite()) {
                        if (attr != null && !attr.getDataType().isPrimitive()) {
                            this.out.print(this.source[199]);
                            this.out.print(attr.getJavaType());
                            this.out.print(this.source[200]);
                            this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                            this.out.print(this.source[201]);
                        } else {
                            this.out.print(this.source[202]);
                            this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                            this.out.print(this.source[203]);
                        }
                    }
                    this.out.print(this.source[204]);
                    this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                    this.out.print(this.source[205]);
                    this.out.print(var);
                    this.out.print(this.source[206]);
                    this.out.print(nullVal);
                    this.out.print(this.source[207]);
                    this.out.print(var);
                    this.out.print(this.source[208]);
                }
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[209]);
                    this.out.print(var);
                    this.out.print(this.source[210]);
                }
                if (rel.getRelationType() == RelationType.OBJECT && rel.isComposite()) {
                    if (attr != null && !attr.getDataType().isPrimitive()) {
                        this.out.print(this.source[211]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[212]);
                        this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                        this.out.print(this.source[213]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[214]);
                    } else {
                        this.out.print(this.source[215]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[216]);
                        this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getMethodArgument());
                        this.out.print(this.source[217]);
                        this.out.print(rel.getVariableName());
                        this.out.print(this.source[218]);
                    }
                }
                this.out.print(this.source[219]);
            }
            if (rel.getRelationType() != RelationType.OBJECT || !rel.isSerialized() || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
            this.out.print(this.source[220]);
            this.out.print(var);
            this.out.print(this.source[221]);
            this.out.print(var);
            this.out.print(this.source[222]);
            this.out.print(rel.getComment());
            this.out.print(this.source[223]);
            this.out.print(scope);
            this.out.print(this.source[224]);
            this.out.print(rel.getSetterName());
            this.out.print(this.source[225]);
            this.out.print(type);
            this.out.print(this.source[226]);
            this.out.print(var);
            this.out.print(this.source[227]);
            this.out.print(var);
            this.out.print(this.source[228]);
            this.out.print(var);
            this.out.print(this.source[229]);
            this.out.print(var);
            this.out.print(this.source[230]);
        }
        if (generateSetSession) {
            this.out.print(this.source[231]);
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.isSelectionCached() || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER && !rel.isComposite()) continue;
                this.out.print(this.source[232]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[233]);
            }
            this.out.print(this.source[234]);
            for (Object rel : this.getEntity().getRelations()) {
                if (rel.isSelectionCached() || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER && !rel.isComposite()) continue;
                this.out.print(this.source[235]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[236]);
            }
            this.out.print(this.source[237]);
        }
        if (generateDeleteReferencingRelations) {
            if (useDatabaseRefInt) {
                this.out.print(this.source[238]);
                for (Object rel : this.getEntity().getRelations()) {
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    if (!rel.isTracked()) {
                        throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
                    }
                    var = rel.getVariableName();
                    this.out.print(this.source[239]);
                    this.out.print(var);
                    this.out.print(this.source[240]);
                    this.out.print(var);
                    this.out.print(this.source[241]);
                    this.out.print(var);
                    this.out.print(this.source[242]);
                }
                this.out.print(this.source[243]);
            } else if (generateLazyDeleteReferencingRelations) {
                this.out.print(this.source[244]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST || rel.getSelectionType() != SelectionType.LAZY && rel.getSelectionType() != SelectionType.EAGER) continue;
                    if (rel.isTracked()) {
                        this.out.print(this.source[245]);
                        if (rel.isDeletionCascaded()) {
                            this.out.print(this.source[246]);
                            this.out.print(rel.getGetterName());
                            this.out.print(this.source[247]);
                        } else {
                            this.out.print(this.source[248]);
                            this.out.print(var);
                            this.out.print(this.source[249]);
                            this.out.print(this.createRelationDeleteCode((Relation)rel));
                            this.out.print(this.source[250]);
                        }
                        this.out.print(this.source[251]);
                        this.out.print(var);
                        this.out.print(this.source[252]);
                        this.out.print(var);
                        this.out.print(this.source[253]);
                        this.out.print(var);
                        this.out.print(this.source[254]);
                        continue;
                    }
                    this.out.print(this.source[255]);
                    this.out.print(var);
                    this.out.print(this.source[256]);
                    if (rel.isDeletionCascaded()) {
                        this.out.print(this.source[257]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[258]);
                        this.out.print(this.createRelationSelectCode((Relation)rel));
                        this.out.print(this.source[259]);
                        this.out.print(var);
                        this.out.print(this.source[260]);
                    } else {
                        this.out.print(this.source[261]);
                        this.out.print(var);
                        this.out.print(this.source[262]);
                        this.out.print(this.createRelationDeleteCode((Relation)rel));
                        this.out.print(this.source[263]);
                    }
                    this.out.print(this.source[264]);
                }
                this.out.print(this.source[265]);
            } else {
                this.out.print(this.source[266]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    if (rel.isDeletionCascaded()) {
                        this.out.print(this.source[267]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[268]);
                        continue;
                    }
                    this.out.print(this.source[269]);
                    this.out.print(var);
                    this.out.print(this.source[270]);
                    this.out.print(this.createRelationDeleteCode((Relation)rel));
                    this.out.print(this.source[271]);
                }
                this.out.print(this.source[272]);
            }
        }
        if (generateDeleteReferencedRelations) {
            String selectStmt;
            if (useDatabaseRefInt) {
                this.out.print(this.source[273]);
                for (Object rel : this.getEntity().getRelations()) {
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (!rel.isTracked()) {
                        throw new WurbelException("inconsistent model: untracked not allowed with db-integrity");
                    }
                    var = rel.getVariableName();
                    selectStmt = this.createRelationSelectCode((Relation)rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
                    this.out.print(this.source[274]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[275]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[276]);
                    this.out.print(selectStmt);
                    this.out.print(this.source[277]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[278]);
                }
                this.out.print(this.source[279]);
            } else if (generateLazyDeleteReferencedRelations) {
                this.out.print(this.source[280]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                        this.out.print(this.source[281]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[282]);
                        this.out.print(var);
                        this.out.print(this.source[283]);
                        this.out.print(var);
                        this.out.print(this.source[284]);
                    }
                    selectStmt = this.createRelationSelectCode((Relation)rel).replace(rel.getVariableName() + "Id", rel.getVariableName() + "RemovedId");
                    this.out.print(this.source[285]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[286]);
                    this.out.print(rel.getClassName());
                    this.out.print(this.source[287]);
                    this.out.print(selectStmt);
                    this.out.print(this.source[288]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[289]);
                }
                this.out.print(this.source[290]);
            } else {
                this.out.print(this.source[291]);
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                    if (rel.getSelectionType() == SelectionType.ALWAYS) {
                        throw new WurbelException("internal wurblet logic error");
                    }
                    this.out.print(this.source[292]);
                    this.out.print(var);
                    this.out.print(this.source[293]);
                    this.out.print(var);
                    this.out.print(this.source[294]);
                }
                this.out.print(this.source[295]);
            }
        }
        if (generateSaveReferencingRelations) {
            this.out.print(this.source[296]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[297]);
            } else {
                this.out.print(this.source[298]);
                this.out.print(generateLazyDeleteReferencingRelations ? "false" : "");
                this.out.print(this.source[299]);
            }
            this.out.print(this.source[300]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                if (rel.isProcessed()) {
                    this.out.print(this.source[301]);
                    this.out.print(var);
                    this.out.print(this.source[302]);
                    this.out.print(rel.getMethodNameSuffix());
                    this.out.print(this.source[303]);
                    this.out.print(var);
                    this.out.print(this.source[304]);
                }
                this.out.print(this.source[305]);
                this.out.print(var);
                this.out.print(this.source[306]);
                this.out.print(var);
                this.out.print(this.source[307]);
                if (rel.getLinkMethodName() != null && rel.getLinkMethodIndex() != null) {
                    this.out.print(this.source[308]);
                }
                this.out.print(this.source[309]);
                this.out.print(rel.getClassName());
                this.out.print(this.source[310]);
                this.out.print(var);
                this.out.print(this.source[311]);
                this.out.print(this.createRelationLinkCode((Relation)rel));
                this.out.print(this.source[312]);
                boolean firstSkipped = false;
                for (MethodArgument ma : rel.getMethodArgs()) {
                    if (firstSkipped) {
                        this.out.print(this.source[313]);
                        this.out.print(ma.getSetterMethod());
                        this.out.print(this.source[314]);
                        this.out.print(ma.getMethodArgument());
                        this.out.print(this.source[315]);
                    }
                    firstSkipped = true;
                }
                this.out.print(this.source[316]);
                this.out.print(var);
                this.out.print(this.source[317]);
                this.out.print(rel.isTracked() ? "true" : "false");
                this.out.print(this.source[318]);
            }
            this.out.print(this.source[319]);
        }
        if (generateSaveReferencedRelations) {
            this.out.print(this.source[320]);
            if (this.getEntity().isRootEntity()) {
                this.out.print(this.source[321]);
            }
            this.out.print(this.source[322]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[323]);
            } else {
                this.out.print(this.source[324]);
                this.out.print(generateLazyDeleteReferencedRelations ? "false" : "");
                this.out.print(this.source[325]);
            }
            this.out.print(this.source[326]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                this.out.print(this.source[327]);
                this.out.print(var);
                this.out.print(this.source[328]);
                if (rel.isProcessed()) {
                    this.out.print(this.source[329]);
                    this.out.print(var);
                    this.out.print(this.source[330]);
                    this.out.print(rel.getMethodNameSuffix());
                    this.out.print(this.source[331]);
                    this.out.print(var);
                    this.out.print(this.source[332]);
                }
                if (rel.isTracked()) {
                    this.out.print(this.source[333]);
                    this.out.print(var);
                    this.out.print(this.source[334]);
                    this.out.print(var);
                    this.out.print(this.source[335]);
                    this.out.print(var);
                    this.out.print(this.source[336]);
                    this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                    this.out.print(this.source[337]);
                    this.out.print(var);
                    this.out.print(this.source[338]);
                    continue;
                }
                this.out.print(this.source[339]);
                this.out.print(var);
                this.out.print(this.source[340]);
                this.out.print(var);
                this.out.print(this.source[341]);
                this.out.print(this.createRelationSetFirstArgMethodName((Relation)rel));
                this.out.print(this.source[342]);
                this.out.print(var);
                this.out.print(this.source[343]);
            }
            this.out.print(this.source[344]);
        }
        if (Boolean.TRUE.equals(generateValidate)) {
            this.out.print(this.source[345]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite()) continue;
                this.out.print(this.source[346]);
                this.out.print(var);
                this.out.print(this.source[347]);
                if (rel.getRelationType() == RelationType.LIST) {
                    this.out.print(this.source[348]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[349]);
                    this.out.print(var);
                    this.out.print(this.source[350]);
                } else {
                    this.out.print(this.source[351]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[352]);
                    this.out.print(var);
                    this.out.print(this.source[353]);
                }
                this.out.print(this.source[354]);
            }
            this.out.print(this.source[355]);
        }
        if (generateSetImmutable) {
            this.out.print(this.source[356]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isComposite()) continue;
                this.out.print(this.source[357]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[358]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[359]);
            }
            this.out.print(this.source[360]);
        }
        if (generateIsModified) {
            this.out.print(this.source[361]);
            for (Object rel : this.getEntity().getRelations()) {
                if (!rel.isComposite()) continue;
                if (rel.getRelationType() == RelationType.LIST) {
                    this.out.print(this.source[362]);
                    this.out.print(rel.getVariableName());
                    this.out.print(this.source[363]);
                    continue;
                }
                this.out.print(this.source[364]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[365]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[366]);
            }
            this.out.print(this.source[367]);
        }
        if (generateAlignComponents) {
            this.out.print(this.source[368]);
            for (Object rel : this.getEntity().getRelations()) {
                Attribute countAttribute = rel.getCountAttribute();
                if (countAttribute == null) continue;
                this.out.print(this.source[369]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[370]);
                this.out.print(countAttribute.getSetterName());
                this.out.print(this.source[371]);
                this.out.print(rel.getVariableName());
                this.out.print(this.source[372]);
            }
            this.out.print(this.source[373]);
        }
        if (this.getEntity().isDeeplyReferenced()) {
            Iterator<Relation> deepRelations = new ArrayList();
            for (Relation rel2 : this.getEntity().getRelations()) {
                if (!rel2.isComposite() || !rel2.getForeignEntity().isDeeplyReferenced()) continue;
                deepRelations.add(rel2);
            }
            if (!deepRelations.isEmpty()) {
                Object rel;
                this.out.print(this.source[374]);
                rel = deepRelations.iterator();
                while (rel.hasNext()) {
                    Relation rel2;
                    rel2 = (Relation)rel.next();
                    if (rel2.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[375]);
                        this.out.print(rel2.getForeignEntity());
                        this.out.print(this.source[376]);
                        this.out.print(rel2.getGetterName());
                        this.out.print(this.source[377]);
                        continue;
                    }
                    this.out.print(this.source[378]);
                    this.out.print(rel2.getGetterName());
                    this.out.print(this.source[379]);
                    this.out.print(rel2.getGetterName());
                    this.out.print(this.source[380]);
                }
                this.out.print(this.source[381]);
            }
        }
        if (generateIsComposite) {
            this.out.print(this.source[382]);
        }
        if (generateLoadComponents.booleanValue()) {
            this.out.print(this.source[383]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite()) continue;
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[384]);
                    this.out.print(var);
                    this.out.print(this.source[385]);
                    if (rel.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[386]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[387]);
                    } else {
                        this.out.print(this.source[388]);
                        this.out.print(rel.getGetterName());
                        this.out.print(this.source[389]);
                        this.out.print(var);
                        this.out.print(this.source[390]);
                    }
                    this.out.print(this.source[391]);
                    continue;
                }
                if (rel.getRelationType() == RelationType.LIST) {
                    this.out.print(this.source[392]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[393]);
                    continue;
                }
                this.out.print(this.source[394]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[395]);
                this.out.print(var);
                this.out.print(this.source[396]);
            }
            this.out.print(this.source[397]);
        }
        if (generateInsertComponents.booleanValue()) {
            this.out.print(this.source[398]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                this.out.print(this.source[399]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[400]);
                this.out.print(var);
                this.out.print(this.source[401]);
            }
            this.out.print(this.source[402]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                this.out.print(this.source[403]);
                this.out.print(rel.getGetterName());
                this.out.print(this.source[404]);
            }
            this.out.print(this.source[405]);
        }
        if (generateDeleteComponents.booleanValue()) {
            this.out.print(this.source[406]);
            if (useDatabaseRefInt) {
                this.out.print(this.source[407]);
            } else {
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.LIST) continue;
                    this.out.print(this.source[408]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[409]);
                }
            }
            this.out.print(this.source[410]);
            if (!useDatabaseRefInt) {
                for (Object rel : this.getEntity().getRelations()) {
                    var = rel.getVariableName();
                    if (!rel.isComposite() || rel.getRelationType() != RelationType.OBJECT) continue;
                    this.out.print(this.source[411]);
                    this.out.print(rel.getGetterName());
                    this.out.print(this.source[412]);
                    this.out.print(var);
                    this.out.print(this.source[413]);
                }
            }
            this.out.print(this.source[414]);
        }
        if (generateMarkDeleted) {
            this.out.print(this.source[415]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite()) continue;
                this.out.print(this.source[416]);
                this.out.print(var);
                this.out.print(this.source[417]);
            }
            this.out.print(this.source[418]);
        }
        if (generateSnapshot) {
            this.out.print(this.source[419]);
            this.out.print(mainClass);
            this.out.print(this.getEntity().isAbstract() ? "<T,?>" : "");
            this.out.print(this.source[420]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isShallow()) continue;
                if (rel.getRelationType() == RelationType.LIST) {
                    if (!rel.isTracked()) continue;
                    this.out.print(this.source[421]);
                    this.out.print(var);
                    this.out.print(this.source[422]);
                    this.out.print(var);
                    this.out.print(this.source[423]);
                    continue;
                }
                this.out.print(this.source[424]);
                this.out.print(var);
                this.out.print(this.source[425]);
                this.out.print(var);
                this.out.print(this.source[426]);
            }
            this.out.print(this.source[427]);
            this.out.print(mainClass);
            this.out.print(this.getEntity().isAbstract() ? "<T,?>" : "");
            this.out.print(this.source[428]);
            for (Object rel : this.getEntity().getRelations()) {
                var = rel.getVariableName();
                if (!rel.isComposite() || rel.isShallow()) continue;
                Relation nmRel = rel.getNmRelation();
                Object nmVar = null;
                if (nmRel != null) {
                    nmVar = rel.getNmMethodName() != null ? StringHelper.firstToLower((String)rel.getNmMethodName()) : StringHelper.firstToLower((String)rel.getNmName()) + "List";
                }
                if (rel.getRelationType() == RelationType.LIST) {
                    if (rel.isTracked()) {
                        this.out.print(this.source[429]);
                        this.out.print(var);
                        this.out.print(this.source[430]);
                        this.out.print(var);
                        this.out.print(this.source[431]);
                        this.out.print(var);
                        this.out.print(this.source[432]);
                    }
                } else {
                    this.out.print(this.source[433]);
                    this.out.print(var);
                    this.out.print(this.source[434]);
                    this.out.print(var);
                    this.out.print(this.source[435]);
                    this.out.print(var);
                    this.out.print(this.source[436]);
                }
                if (rel.getSelectionType() == SelectionType.LAZY || rel.getSelectionType() == SelectionType.EAGER) {
                    this.out.print(this.source[437]);
                    this.out.print(var);
                    this.out.print(this.source[438]);
                    this.out.print(var);
                    this.out.print(this.source[439]);
                }
                if (rel.getRelationType() == RelationType.OBJECT) {
                    this.out.print(this.source[440]);
                    this.out.print(var);
                    this.out.print(this.source[441]);
                    this.out.print(var);
                    this.out.print(this.source[442]);
                }
                if (nmVar == null) continue;
                this.out.print(this.source[443]);
                this.out.print((String)nmVar);
                this.out.print(this.source[444]);
            }
            this.out.print(this.source[445]);
        }
        if (generateIsReferencing && this.isEntityPersistable()) {
            for (Object rel : this.getEntity().getTableRelations()) {
                if (rel.isComposite() || rel.getRelationType() != RelationType.OBJECT || rel.getForeignRelation() != null && rel.getForeignRelation().isComposite() || rel.getForeignEntity() == null || !rel.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
                String tagName = "isReferencing" + rel.getClassName() + "By" + StringHelper.firstToUpper((String)((MethodArgument)rel.getMethodArgs().get(0)).getAttribute().getName());
                this.out.print(this.source[446]);
                this.out.print(pdoName);
                this.out.print(this.source[447]);
                this.out.print(rel.getClassName());
                this.out.print(this.source[448]);
                this.out.print(tagName);
                this.out.print(this.source[449]);
                this.out.print(((MethodArgument)rel.getMethodArgs().get(0)).getAttribute().getName());
                this.out.print(this.source[450]);
            }
        }
        if (generateSelects && this.isEntityPersistable()) {
            HashSet wurbletArgSet = new HashSet();
            for (Relation rel2 : this.getEntity().getReferencingRelations()) {
                Object join;
                Attribute attribute;
                if (rel2.getAccessScope() != AccessScope.PUBLIC || rel2.getRelationType() != RelationType.LIST || (attribute = rel2.getForeignAttribute()) == null) continue;
                String trackedOption = rel2.isTracked() ? "--tracked " : "";
                Object joins = "";
                if (rel2.getNmName() != null && (join = rel2.getNmRelation()) != null && join.getRelationType() == RelationType.OBJECT && join.getSelectionType() == SelectionType.LAZY && !join.isComposite() && join.isSerialized()) {
                    joins = " *" + rel2.getNmName();
                }
                join = this.getEntity().getRelationsIncludingInherited().iterator();
                while (join.hasNext()) {
                    Relation eRel = (Relation)join.next();
                    if (eRel.getSelectionType() != SelectionType.EAGER) continue;
                    joins = (String)joins + " *" + eRel.getName();
                }
                Object extraWurbletOptions = rel2.getSelectionWurbletArguments();
                extraWurbletOptions = extraWurbletOptions == null ? "" : " " + (String)extraWurbletOptions;
                String wurbletArgs = this.createRelationWurbletArgString(rel2);
                if (!wurbletArgSet.add(wurbletArgs)) continue;
                this.out.print(this.source[451]);
                this.out.print(rel2);
                this.out.print(this.source[452]);
                if (rel2.isReversed()) {
                    this.out.print(this.source[453]);
                    this.out.print(this.createRelationSelectMethodName(rel2));
                    this.out.print(this.source[454]);
                    this.out.print(wurbletArgs);
                    this.out.print((String)joins);
                    this.out.print((String)extraWurbletOptions);
                    this.out.print(this.source[455]);
                    continue;
                }
                this.out.print(this.source[456]);
                this.out.print(this.createRelationSelectMethodName(rel2));
                this.out.print(this.source[457]);
                this.out.print(trackedOption);
                this.out.print(wurbletArgs);
                this.out.print((String)joins);
                this.out.print((String)extraWurbletOptions);
                this.out.print(this.source[458]);
            }
        }
        if (generateDeletes && this.isEntityPersistable()) {
            for (Object rel : this.getEntity().getReferencingRelations()) {
                Attribute attribute;
                if (rel.getAccessScope() != AccessScope.PUBLIC || rel.getRelationType() != RelationType.LIST || (attribute = rel.getForeignAttribute()) == null || !rel.isComposite() || rel.isDeletionCascaded() || useDatabaseRefInt) continue;
                this.out.print(this.source[459]);
                this.out.print(rel);
                this.out.print(this.source[460]);
                this.out.print(this.createListRelationDeleteMethodName((Relation)rel));
                this.out.print(this.source[461]);
                this.out.print(this.createRelationWurbletArgString((Relation)rel));
                this.out.print(this.source[462]);
            }
        }
        if (generateAddReferencing) {
            ArrayList<Relation> refRels = new ArrayList<Relation>();
            for (Relation rel2 : this.getEntity().getReferencingRelations()) {
                if (rel2.isComposite() || rel2.getRelationType() != RelationType.OBJECT || rel2.getForeignRelation() != null && rel2.getForeignRelation().isComposite() || rel2.getForeignEntity() == null || !rel2.getForeignEntity().getIntegrity().isCheckedByApplication()) continue;
                refRels.add(rel2);
            }
            if (!refRels.isEmpty()) {
                this.out.print(this.source[463]);
                if (this.getEntity().isAbstract()) {
                    this.out.print(this.source[464]);
                }
                this.out.print(this.source[465]);
                this.out.print(pdoName);
                this.out.print(this.source[466]);
                for (Relation rel2 : refRels) {
                    String methodName = "isReferencing" + rel2.getClassName() + "By" + StringHelper.firstToUpper((String)((MethodArgument)rel2.getMethodArgs().get(0)).getAttribute().getName());
                    for (Entity leaf : rel2.getEntity().getLeafEntities()) {
                        this.out.print(this.source[467]);
                        this.out.print(leaf.getName());
                        this.out.print(this.source[468]);
                        this.out.print(methodName);
                        this.out.print(this.source[469]);
                    }
                }
                this.out.print(this.source[470]);
            }
        }
    }
}

